/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.ui.preferences.DefaultPreferencePanel;
import org.openconcerto.ui.preferences.EmailProps;

public class EmailNode
extends DefaultPreferencePanel {
    private static final long serialVersionUID = -2626095170221913765L;
    private JFileChooser fileChooser;
    private JRadioButton radioDefault;
    private JTextField textThunderbirdPath;
    private JRadioButton radioThunderbird;
    private JRadioButton radioOutlook;
    private JTextField textFrom;
    private JTextField textTitle;
    private JTextArea textHeader;
    private JTextArea textFooter;

    public EmailNode() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 2;
        JLabel l = new JLabel("Envoyer les emails avec :");
        c.gridwidth = 3;
        this.add((Component)l, c);
        this.radioDefault = new JRadioButton("le logiciel email par d\u00e9faut");
        ++c.gridy;
        this.add((Component)this.radioDefault, c);
        this.radioThunderbird = new JRadioButton("Mozilla Thunderbird");
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)this.radioThunderbird, c);
        this.textThunderbirdPath = new JTextField();
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)this.textThunderbirdPath, c);
        JButton buttonModele = new JButton("Selectionner");
        ++c.gridx;
        c.weightx = 0.0;
        buttonModele.setEnabled(false);
        this.add((Component)buttonModele, c);
        this.radioOutlook = new JRadioButton("Microsoft Outlook");
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)this.radioOutlook, c);
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.radioDefault);
        grp.add(this.radioThunderbird);
        grp.add(this.radioOutlook);
        this.radioDefault.setSelected(true);
        JLabel le = new JLabel("Pr\u00e9remplissage des champs :");
        ++c.gridy;
        c.gridwidth = 3;
        this.add((Component)le, c);
        JLabel labelExp = new JLabel("Exp\u00e9diteur", 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)labelExp, c);
        this.textFrom = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)this.textFrom, c);
        JLabel labelTitle = new JLabel("Titre", 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)labelTitle, c);
        this.textTitle = new JTextField();
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)this.textTitle, c);
        JLabel labelHeader = new JLabel("Ent\u00eate", 4);
        c.anchor = 18;
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)labelHeader, c);
        this.textHeader = new ITextArea(3, 3);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)this.textHeader, c);
        JLabel labelFooter = new JLabel("Signature", 4);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        c.gridwidth = 1;
        this.add((Component)labelFooter, c);
        this.textFooter = new ITextArea(3, 3);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 2;
        c.weighty = 1.0;
        this.add((Component)this.textFooter, c);
        buttonModele.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailNode.this.directoryChoose(EmailNode.this.textThunderbirdPath);
            }
        });
        this.textThunderbirdPath.setEditable(false);
        this.radioDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailNode.this.textThunderbirdPath.setEnabled(false);
            }
        });
        this.radioThunderbird.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailNode.this.textThunderbirdPath.setEnabled(true);
                EmailNode.this.textThunderbirdPath.setEditable(true);
            }
        });
        this.radioOutlook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailNode.this.textThunderbirdPath.setEnabled(false);
            }
        });
        this.setValues();
    }

    public void setValues() {
        try {
            this.textFrom.setText(EmailProps.getInstance().getFrom());
            this.textTitle.setText(EmailProps.getInstance().getTitle());
            this.textHeader.setText(EmailProps.getInstance().getHeader());
            this.textFooter.setText(EmailProps.getInstance().getFooter());
            this.textThunderbirdPath.setText(EmailProps.getInstance().getThunderbirdPath());
            int mode = EmailProps.getInstance().getMode();
            if (mode == 1) {
                this.radioThunderbird.setSelected(true);
            } else if (mode == 2) {
                this.radioOutlook.setSelected(true);
            } else {
                this.radioDefault.setSelected(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void storeValues() {
        try {
            EmailProps.getInstance().setFrom(this.textFrom.getText());
            EmailProps.getInstance().setTitle(this.textTitle.getText());
            EmailProps.getInstance().setHeader(this.textHeader.getText());
            EmailProps.getInstance().setFooter(this.textFooter.getText());
            EmailProps.getInstance().setThunderbirdPath(this.textThunderbirdPath.getText());
            int mode = 0;
            if (this.radioThunderbird.isSelected()) {
                mode = 1;
            } else if (this.radioOutlook.isSelected()) {
                mode = 2;
            }
            EmailProps.getInstance().setMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EmailProps.getInstance().store();
    }

    @Override
    public void restoreToDefaults() {
        this.textThunderbirdPath.setText("C:\\Program Files\\Mozilla Thunderbird\\thunderbird.exe");
        this.radioDefault.setSelected(true);
        this.textHeader.setText("Bonjour,\n");
        this.textFooter.setText("\nCordialement,\nLa direction");
    }

    @Override
    public String getTitleName() {
        return "Emails";
    }

    public void directoryChoose(final JTextField field) {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (EmailNode.this.fileChooser.showDialog(EmailNode.this, "S\u00e9lectionner") == 0) {
                    field.setText(EmailNode.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
    }
}

