/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.grid;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class YearsHeaderPanel
extends JPanel {
    private final int year;
    private String[] months = new String[]{"Janv.", "F\u00e9v.", "Mars", "Avr.", "Mai", "Juin", "Juil.", "Ao\u00fbt", "Sept.", "Oct.", "Nov.", "D\u00e9c."};
    private final int yearCount;

    public YearsHeaderPanel(int year, int yearCount) {
        this.year = year;
        this.yearCount = yearCount;
        if (yearCount < 1) {
            throw new IllegalArgumentException("year count must be >= 1");
        }
        this.setBackground(Color.white);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setFont(g.getFont().deriveFont(1));
        int componentWidth = this.getWidth();
        int componentHeight = this.getHeight();
        int yearWidth = componentWidth / this.yearCount;
        int i = 0;
        while (i < this.yearCount) {
            int x1 = yearWidth / 2 + yearWidth * i;
            String str1 = String.valueOf(this.year + i);
            int w1 = g.getFontMetrics().stringWidth(str1);
            g.drawString(str1, x1 - w1 / 2, 16);
            ++i;
        }
        int gw = componentWidth / (12 * this.yearCount);
        g.setColor(Color.LIGHT_GRAY);
        int space3 = gw * 3;
        int x = 0;
        while (x < componentWidth) {
            g.drawLine(x, 36, x, componentHeight);
            x += space3;
        }
        g.setColor(Color.GRAY);
        int space6 = gw * 6;
        int x2 = 0;
        while (x2 < componentWidth) {
            g.drawLine(x2, 24, x2, componentHeight);
            x2 += space6;
        }
        g.setColor(Color.BLACK);
        int space12 = gw * 12;
        int x3 = 0;
        while (x3 < componentWidth) {
            g.drawLine(x3, 0, x3, componentHeight);
            x3 += space12;
        }
        g.setFont(g.getFont().deriveFont(0));
        int i2 = 0;
        while (i2 < 12) {
            String str = this.months[i2];
            int w = g.getFontMetrics().stringWidth(str);
            int x4 = i2 * gw + gw / 2 - w / 2;
            int j = 0;
            while (j < this.yearCount) {
                g.drawString(str, x4, 40);
                x4 += yearWidth;
                ++j;
            }
            ++i2;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.getPreferredSize().width, 48);
    }
}

