/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.util.List;
import org.openconcerto.erp.core.supplychain.stock.element.BatchNode;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRowValues;

class StockNode {
    private final SQLRowValues sqlRowValues;
    private final List<BatchNode> lots;

    public StockNode(SQLRowValues sqlRowValues, List<BatchNode> lots) {
        this.sqlRowValues = sqlRowValues;
        this.lots = lots;
    }

    public int getLotSize() {
        if (this.lots == null) {
            return 0;
        }
        return this.lots.size();
    }

    public Object getValueAt(FieldPath fieldPath, int columnIndex) {
        return this.sqlRowValues.followPath(fieldPath.getPath()).getObject(fieldPath.getFieldName());
    }

    public BatchNode getLot(int index) {
        if (this.lots == null) {
            return null;
        }
        return this.lots.get(index);
    }

    public String toString() {
        return this.sqlRowValues.getForeign("ID_DEPOT_STOCK").getString("NOM");
    }
}

