/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.supplychain.order.component.CommandeSQLComponent;
import org.openconcerto.erp.core.supplychain.order.element.DemandePrixSQLComponent;
import org.openconcerto.erp.core.supplychain.order.element.DemandePrixSheetXML;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.users.rights.UserRightsManager;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.utils.ListMap;

public class DemandePrixSQLElement
extends ComptaSQLConfElement {
    public static final String RIGHT_ACCEPT_DMD_PRIX = "dmd.prix.accept";

    private SQLRowValues getLivraisonAdr(SQLRowAccessor rowAffaire) {
        SQLRowAccessor rowClient = rowAffaire.getForeign("ID_CLIENT");
        SQLRowAccessor rowAdrL = rowClient.getForeign("ID_ADRESSE_L");
        if (rowAdrL == null || rowAdrL.isUndefined()) {
            rowAdrL = rowClient.getForeign("ID_ADRESSE");
        }
        SQLRowValues rowVals = rowAdrL.asRowValues();
        rowVals.clearPrimaryKeys();
        return rowVals;
    }

    @Override
    protected void _initTableSource(SQLTableModelSource source) {
        super._initTableSource(source);
    }

    public DemandePrixSQLElement() {
        super("DEMANDE_PRIX");
        MouseSheetXmlListeListener l = new MouseSheetXmlListeListener(this, DemandePrixSheetXML.class){

            protected String getMailObject(SQLRow row) {
                return "Veuillez trouver en pi\u00e8ce jointe notre demande de prix.";
            }

            public List<RowAction> addToMenu() {
                ArrayList<RowAction> actions = new ArrayList<RowAction>();
                if (UserRightsManager.getCurrentUserRights().haveRight(DemandePrixSQLElement.RIGHT_ACCEPT_DMD_PRIX)) {
                    RowAction.PredicateRowAction action = new RowAction.PredicateRowAction(new AbstractAction("Marqu\u00e9 comme accept\u00e9e et transf\u00e9rer en commande"){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            SQLRow row = IListe.get(arg0).getSelectedRow().asRow();
                            SQLRowValues rowVals = row.asRowValues();
                            rowVals.put("ID_ETAT_DEMANDE_PRIX", 4);
                            try {
                                rowVals.update();
                            }
                            catch (SQLException exn) {
                                exn.printStackTrace();
                            }
                            SQLInjector inj = SQLInjector.getInjector(row.getTable(), row.getTable().getTable("COMMANDE"));
                            EditFrame f = new EditFrame(Configuration.getInstance().getDirectory().getElement("COMMANDE"));
                            CommandeSQLComponent sqlComponent = (CommandeSQLComponent)f.getPanel().getSQLComponent();
                            sqlComponent.select(inj.createRowValuesFrom(((SQLRowAccessor)row).getID()));
                            sqlComponent.loadItem(sqlComponent.getRowValuesTablePanel(), Configuration.getInstance().getDirectory().getElement("DEMANDE_PRIX"), ((SQLRowAccessor)row).getID(), Configuration.getInstance().getDirectory().getElement("DEMANDE_PRIX_ELEMENT"));
                            f.setVisible(true);
                        }
                    }, false);
                    action.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                    actions.add(action);
                }
                RowAction.PredicateRowAction actionCreate = new RowAction.PredicateRowAction(new AbstractAction("Cr\u00e9er \u00e0 partir de ..."){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        SQLRow row = IListe.get(arg0).getSelectedRow().asRow();
                        DemandePrixSQLComponent createComponent = (DemandePrixSQLComponent)DemandePrixSQLElement.this.createComponent();
                        EditFrame frame = new EditFrame(createComponent, EditPanel.EditMode.CREATION);
                        createComponent.loadDemandeExistant(((SQLRowAccessor)row).getID());
                        frame.setVisible(true);
                    }
                }, false);
                actionCreate.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
                actions.add(actionCreate);
                return actions;
            }
        };
        this.getRowActions().addAll(l.getRowActions());
    }

    @Override
    public Set<String> getReadOnlyFields() {
        if (!UserRightsManager.getCurrentUserRights().haveRight(RIGHT_ACCEPT_DMD_PRIX)) {
            HashSet<String> s = new HashSet<String>();
            s.add("ID_ETAT_DEMANDE_PRIX");
            return s;
        }
        return super.getReadOnlyFields();
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("ID_FOURNISSEUR");
        l.add("DATE");
        l.add("ID_ETAT_DEMANDE_PRIX");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("NUMERO");
        l.add("ID_FOURNISSEUR");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, "NUMERO");
    }

    @Override
    public SQLComponent createComponent() {
        return new DemandePrixSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".demande";
    }
}

