/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.component;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingWorker;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.openconcerto.erp.core.sales.product.element.LotSQLElement;
import org.openconcerto.erp.core.sales.product.model.BatchQuantity;
import org.openconcerto.erp.core.supplychain.receipt.ui.BatchQuantityRenderer;
import org.openconcerto.erp.core.supplychain.receipt.ui.BatchQuantityTableCellEditor;
import org.openconcerto.erp.core.supplychain.stock.element.StockSQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.VerticalLayout;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.utils.cc.ITransformer;

public class BatchSelectorFrame
extends JDialog {
    private SQLElementDirectory dir;
    private SQLRow product;
    private List<BatchQuantity> quantities = new ArrayList<BatchQuantity>();
    private List<SQLRowValues> all = new ArrayList<SQLRowValues>();
    private Map<Integer, SQLRowValues> mapAll = new HashMap<Integer, SQLRowValues>();
    private List<SQLRowValues> available = new ArrayList<SQLRowValues>();
    private JTable leftTable;
    private JTable rightTable;
    private JLabel productName = new JLabel("...");
    private JButton toRigthButton;
    private JButton toLeftButton;
    private DefaultTableModel leftModel;
    private DefaultTableModel rightModel;
    private final int C_STOCK = 0;
    private final int C_QUANTITY = 1;
    private final int C_BATCH = 2;
    private final int C_DLC = 3;
    private final int C_DLUO = 4;
    private final int C_SERIAL = 5;
    private boolean cancelled = false;

    public BatchSelectorFrame(Frame owner, SQLElementDirectory dir, final SQLRow product, List<BatchQuantity> list) {
        super(owner);
        this.dir = dir;
        this.product = product;
        for (BatchQuantity q : list) {
            this.quantities.add(new BatchQuantity(q.getIdBatch(), q.getQuantity(), q.getQuantityInDB()));
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                BatchSelectorFrame.this.loadData();
            }
        });
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.gridwidth = 3;
        c.weighty = 0.0;
        this.productName.setText(product.getString("NOM"));
        this.add((Component)this.productName, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.gridx = 0;
        c.weightx = 1.0;
        this.add((Component)new JLabelBold("En stock"), c);
        c.gridx = 2;
        this.add((Component)new JLabelBold("S\u00e9lection"), c);
        c.weighty = 1.0;
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        this.leftModel = this.createLeftTableModel();
        this.leftTable = new JTable(this.leftModel);
        this.add((Component)new JScrollPane(this.leftTable), c);
        this.leftTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == -1 && BatchSelectorFrame.this.leftTable.getColumnCount() > 2) {
                    BatchQuantityTableCellEditor qtyEditor = new BatchQuantityTableCellEditor(product.getForeignIDNumber("ID_UNITE_VENTE"));
                    TableColumn qtyCol = BatchSelectorFrame.this.leftTable.getColumnModel().getColumn(1);
                    qtyCol.setCellEditor(qtyEditor);
                    qtyCol.setCellRenderer(new BatchQuantityRenderer());
                }
            }
        });
        ++c.gridx;
        c.weightx = 0.0;
        JPanel moveButtons = new JPanel();
        moveButtons.setOpaque(false);
        moveButtons.setLayout(new VerticalLayout());
        this.toRigthButton = new JButton(">");
        moveButtons.add(this.toRigthButton);
        this.toLeftButton = new JButton("<");
        moveButtons.add(this.toLeftButton);
        this.add((Component)moveButtons, c);
        ++c.gridx;
        c.weightx = 1.0;
        this.rightModel = this.createRightTableModel();
        this.rightTable = new JTable(this.rightModel);
        this.add((Component)new JScrollPane(this.rightTable), c);
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.setOpaque(false);
        JButton cancelButton = new JButton("Annuler");
        JButton closeButton = new JButton("Fermer");
        buttons.add(cancelButton);
        buttons.add(closeButton);
        ++c.gridy;
        ++c.gridwidth;
        c.fill = 0;
        c.anchor = 13;
        this.add((Component)buttons, c);
        this.toRigthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = BatchSelectorFrame.this.leftTable.getSelectedRows();
                if (rows.length > 0) {
                    ArrayList<SQLRowValues> toRemove = new ArrayList<SQLRowValues>();
                    int i = 0;
                    while (i < rows.length) {
                        int rowIndex = rows[i];
                        SQLRowValues rv = (SQLRowValues)BatchSelectorFrame.this.available.get(rowIndex);
                        int idBatch = rv.getID();
                        BatchQuantity found = null;
                        for (BatchQuantity q : BatchSelectorFrame.this.quantities) {
                            if (q.getIdBatch() != idBatch) continue;
                            found = q;
                            break;
                        }
                        if (found == null) {
                            found = new BatchQuantity(idBatch, BigDecimal.ZERO, BigDecimal.ZERO);
                            BatchSelectorFrame.this.quantities.add(found);
                        }
                        found.addQuantity(rv.getBigDecimal("QUANTITE"));
                        rv.put("QUANTITE", BigDecimal.ZERO);
                        toRemove.add(rv);
                        ++i;
                    }
                    BatchSelectorFrame.this.available.removeAll(toRemove);
                    BatchSelectorFrame.this.dataChanged();
                }
            }
        });
        this.toLeftButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = BatchSelectorFrame.this.rightTable.getSelectedRows();
                if (rows.length > 0) {
                    ArrayList<BatchQuantity> toRemove = new ArrayList<BatchQuantity>();
                    int i = 0;
                    while (i < rows.length) {
                        int rowIndex = rows[i];
                        BatchQuantity q = (BatchQuantity)BatchSelectorFrame.this.quantities.get(rowIndex);
                        SQLRowAccessor found = null;
                        for (SQLRowValues rv : BatchSelectorFrame.this.available) {
                            if (q.getIdBatch() != rv.getID()) continue;
                            found = rv;
                            break;
                        }
                        if (found == null) {
                            found = (SQLRowValues)BatchSelectorFrame.this.mapAll.get(q.getIdBatch());
                            BatchSelectorFrame.this.available.add(found);
                        }
                        ((SQLRowValues)found).put("QUANTITE", found.getBigDecimal("QUANTITE").add(q.getQuantity()));
                        toRemove.add(q);
                        ++i;
                    }
                    BatchSelectorFrame.this.quantities.removeAll(toRemove);
                    BatchSelectorFrame.this.dataChanged();
                }
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelectorFrame.this.cancelled = true;
                BatchSelectorFrame.this.dispose();
            }
        });
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BatchSelectorFrame.this.dispose();
            }
        });
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public BigDecimal getTotalSelectedQuantity() {
        BigDecimal total = BigDecimal.ZERO;
        int i = 0;
        while (i < this.rightTable.getRowCount()) {
            total = total.add((BigDecimal)this.rightTable.getValueAt(i, 0));
            ++i;
        }
        return total;
    }

    private DefaultTableModel createLeftTableModel() {
        DefaultTableModel model = new DefaultTableModel(){
            private final List<Integer> cols = new ArrayList<Integer>();

            @Override
            public Object getValueAt(int row, int column) {
                SQLRowValues r = (SQLRowValues)BatchSelectorFrame.this.available.get(row);
                int c = this.cols.get(column);
                if (c == 0) {
                    return r.getForeign("ID_STOCK").getForeign("ID_DEPOT_STOCK").getString("NOM");
                }
                if (c == 1) {
                    return r.getBigDecimal("QUANTITE");
                }
                if (c == 2) {
                    return r.getString("NUMERO_LOT");
                }
                if (c == 3) {
                    return r.getDate("DLC") == null ? null : r.getDate("DLC").getTime();
                }
                if (c == 4) {
                    return r.getDate("DLUO") == null ? null : r.getDate("DLUO").getTime();
                }
                if (c == 5) {
                    return r.getString("NUMERO_SERIE");
                }
                return "??" + c;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }

            @Override
            public int getColumnCount() {
                if (this.cols == null) {
                    return 0;
                }
                return this.cols.size();
            }

            @Override
            public int getRowCount() {
                return BatchSelectorFrame.this.available.size();
            }

            @Override
            public String getColumnName(int column) {
                int c = this.cols.get(column);
                if (c == 0) {
                    return "Stock";
                }
                if (c == 1) {
                    return "Quantit\u00e9";
                }
                if (c == 2) {
                    return "Lot";
                }
                if (c == 3) {
                    return "D.L.C.";
                }
                if (c == 4) {
                    return "D.L.U.O.";
                }
                if (c == 5) {
                    return "N\u00b0 de s\u00e9rie";
                }
                return "??" + c;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                int c = this.cols.get(columnIndex);
                if (c == 0) {
                    return String.class;
                }
                if (c == 1) {
                    return BigDecimal.class;
                }
                if (c == 2) {
                    return String.class;
                }
                if (c == 3) {
                    return Date.class;
                }
                if (c == 4) {
                    return Date.class;
                }
                if (c == 5) {
                    return String.class;
                }
                return String.class;
            }

            @Override
            public void fireTableDataChanged() {
                this.cols.clear();
                this.cols.add(0);
                this.cols.add(1);
                for (SQLRowValues r : BatchSelectorFrame.this.available) {
                    if (r.getString("NUMERO_LOT").isEmpty()) continue;
                    this.cols.add(2);
                    break;
                }
                for (SQLRowValues r : BatchSelectorFrame.this.available) {
                    if (r.getObject("DCL") == null) continue;
                    this.cols.add(3);
                    break;
                }
                for (SQLRowValues r : BatchSelectorFrame.this.available) {
                    if (r.getObject("DLUO") == null) continue;
                    this.cols.add(4);
                    break;
                }
                for (SQLRowValues r : BatchSelectorFrame.this.available) {
                    if (r.getString("NUMERO_SERIE").isEmpty()) continue;
                    this.cols.add(5);
                    break;
                }
                super.fireTableDataChanged();
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                if (BatchSelectorFrame.this.leftTable != null && BatchSelectorFrame.this.leftTable.getColumnCount() > 1) {
                    BatchQuantityTableCellEditor qtyEditor = new BatchQuantityTableCellEditor(BatchSelectorFrame.this.product.getForeignIDNumber("ID_UNITE_VENTE"));
                    TableColumn qtyCol = BatchSelectorFrame.this.leftTable.getColumnModel().getColumn(1);
                    qtyCol.setCellEditor(qtyEditor);
                    qtyCol.setCellRenderer(new BatchQuantityRenderer());
                    AlternateTableCellRenderer.UTILS.setAllColumns(BatchSelectorFrame.this.leftTable);
                }
            }
        };
        return model;
    }

    private DefaultTableModel createRightTableModel() {
        DefaultTableModel model = new DefaultTableModel(){
            private final List<Integer> cols = new ArrayList<Integer>();

            @Override
            public Object getValueAt(int row, int column) {
                BatchQuantity b = (BatchQuantity)BatchSelectorFrame.this.quantities.get(row);
                int c = this.cols.get(column);
                if (c == 1) {
                    return b.getQuantity();
                }
                if (c == 2) {
                    SQLRowValues r = (SQLRowValues)BatchSelectorFrame.this.mapAll.get(b.getIdBatch());
                    return r.getString("NUMERO_LOT");
                }
                if (c == 3) {
                    SQLRowValues r = (SQLRowValues)BatchSelectorFrame.this.mapAll.get(b.getIdBatch());
                    return r.getDate("DLC") == null ? null : r.getDate("DLC").getTime();
                }
                if (c == 4) {
                    SQLRowValues r = (SQLRowValues)BatchSelectorFrame.this.mapAll.get(b.getIdBatch());
                    return r.getDate("DLUO") == null ? null : r.getDate("DLUO").getTime();
                }
                if (c == 5) {
                    SQLRowValues r = (SQLRowValues)BatchSelectorFrame.this.mapAll.get(b.getIdBatch());
                    return r.getString("NUMERO_SERIE");
                }
                return "??" + c;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (column == 0) {
                    BigDecimal newQty = (BigDecimal)aValue;
                    BigDecimal previousQty = (BigDecimal)this.getValueAt(row, column);
                    if (newQty.compareTo(BigDecimal.ZERO) > 0 && newQty.compareTo(previousQty) < 0) {
                        ((BatchQuantity)BatchSelectorFrame.this.quantities.get(row)).setQuantity(newQty);
                        SQLRowValues rv = (SQLRowValues)BatchSelectorFrame.this.mapAll.get(((BatchQuantity)BatchSelectorFrame.this.quantities.get(row)).getIdBatch());
                        if (!BatchSelectorFrame.this.available.contains(rv)) {
                            BatchSelectorFrame.this.available.add(rv);
                        }
                        rv.put("QUANTITE", rv.getBigDecimal("QUANTITE").add(previousQty).subtract(newQty));
                        BatchSelectorFrame.this.leftModel.fireTableDataChanged();
                        BatchSelectorFrame.this.leftModel.fireTableStructureChanged();
                    }
                }
            }

            @Override
            public int getColumnCount() {
                if (this.cols == null) {
                    return 0;
                }
                return this.cols.size();
            }

            @Override
            public int getRowCount() {
                return BatchSelectorFrame.this.quantities.size();
            }

            @Override
            public String getColumnName(int column) {
                int c = this.cols.get(column);
                if (c == 1) {
                    return "Quantit\u00e9";
                }
                if (c == 2) {
                    return "Lot";
                }
                if (c == 3) {
                    return "D.L.C.";
                }
                if (c == 4) {
                    return "D.L.U.O.";
                }
                if (c == 5) {
                    return "N\u00b0 de s\u00e9rie";
                }
                return "??" + c;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                int c = this.cols.get(columnIndex);
                if (c == 0) {
                    return String.class;
                }
                if (c == 1) {
                    return BigDecimal.class;
                }
                if (c == 2) {
                    return String.class;
                }
                if (c == 3) {
                    return Date.class;
                }
                if (c == 4) {
                    return Date.class;
                }
                if (c == 5) {
                    return String.class;
                }
                return String.class;
            }

            @Override
            public void fireTableDataChanged() {
                this.cols.clear();
                this.cols.add(1);
                ArrayList<SQLRowValues> values = new ArrayList<SQLRowValues>();
                for (BatchQuantity q : BatchSelectorFrame.this.quantities) {
                    values.add((SQLRowValues)BatchSelectorFrame.this.mapAll.get(q.getIdBatch()));
                }
                for (SQLRowValues r : values) {
                    if (r.getString("NUMERO_LOT").isEmpty()) continue;
                    this.cols.add(2);
                    break;
                }
                for (SQLRowValues r : values) {
                    if (r.getObject("DCL") == null) continue;
                    this.cols.add(3);
                    break;
                }
                for (SQLRowValues r : values) {
                    if (r.getObject("DLUO") == null) continue;
                    this.cols.add(4);
                    break;
                }
                for (SQLRowValues r : values) {
                    if (r.getString("NUMERO_SERIE").isEmpty()) continue;
                    this.cols.add(5);
                    break;
                }
                super.fireTableDataChanged();
            }

            @Override
            public void fireTableStructureChanged() {
                super.fireTableStructureChanged();
                if (BatchSelectorFrame.this.rightTable != null && BatchSelectorFrame.this.rightTable.getColumnCount() > 0) {
                    BatchQuantityTableCellEditor qtyEditor = new BatchQuantityTableCellEditor(BatchSelectorFrame.this.product.getForeignIDNumber("ID_UNITE_VENTE"));
                    TableColumn qtyCol = BatchSelectorFrame.this.rightTable.getColumnModel().getColumn(0);
                    qtyCol.setCellEditor(qtyEditor);
                    qtyCol.setCellRenderer(new BatchQuantityRenderer());
                    AlternateTableCellRenderer.UTILS.setAllColumns(BatchSelectorFrame.this.rightTable);
                }
            }
        };
        return model;
    }

    protected void loadData() {
        final ArrayList<Integer> ids = new ArrayList<Integer>();
        for (BatchQuantity batchQuantity : this.quantities) {
            ids.add(batchQuantity.getIdBatch());
        }
        SwingWorker<List<SQLRowValues>, List<SQLRowValues>> worker = new SwingWorker<List<SQLRowValues>, List<SQLRowValues>>(){

            @Override
            protected List<SQLRowValues> doInBackground() throws Exception {
                final SQLTable batchTable = BatchSelectorFrame.this.dir.getElement(LotSQLElement.class).getTable();
                SQLTable stockTable = BatchSelectorFrame.this.dir.getElement(StockSQLElement.class).getTable();
                SQLRowValues r = new SQLRowValues(batchTable);
                r.putNulls(batchTable.getFieldsName());
                SQLRowValues rStock = r.putRowValues("ID_STOCK");
                rStock.putNulls(stockTable.getFieldsName());
                rStock.putRowValues("ID_DEPOT_STOCK").putNulls("NOM");
                SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(r);
                fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        SQLSelectJoin join = input.getJoin(batchTable.getField("ID_STOCK"));
                        Where w = Where.inValues(batchTable.getKey(), ids);
                        Where wSameProduct = new Where(join.getJoinedTable().getField("ID_ARTICLE"), "=", BatchSelectorFrame.this.product.getID());
                        Where wNotEmpty = new Where((FieldRef)batchTable.getField("QUANTITE"), ">", 0);
                        input.setWhere(w.or(wNotEmpty).and(wSameProduct));
                        System.err.println(input.asString());
                        return input;
                    }
                });
                return fetcher.fetch();
            }

            @Override
            protected void done() {
                try {
                    List r = (List)this.get();
                    BatchSelectorFrame.this.all.clear();
                    BatchSelectorFrame.this.all.addAll(r);
                    BatchSelectorFrame.this.mapAll.clear();
                    BatchSelectorFrame.this.available.clear();
                    for (SQLRowValues v : BatchSelectorFrame.this.all) {
                        if (v.getBigDecimal("QUANTITE").compareTo(BigDecimal.ZERO) > 0) {
                            BatchSelectorFrame.this.available.add(v);
                        }
                        BatchSelectorFrame.this.mapAll.put(v.getID(), v);
                    }
                    BatchSelectorFrame.this.dataChanged();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    public List<BatchQuantity> getQuantities() {
        return this.quantities;
    }

    public void dataChanged() {
        this.leftModel.fireTableDataChanged();
        this.leftModel.fireTableStructureChanged();
        this.rightModel.fireTableDataChanged();
        this.rightModel.fireTableStructureChanged();
    }
}

