/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.ui.ArticleModel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.CategorieModel;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.ui.touch.ScrollableList;

public class CategorieSelector
extends JPanel
implements ListSelectionListener,
CaisseListener {
    private CategorieModel model;
    private ScrollableList list;
    private StatusBar comp;
    private Categorie previous;
    private ArticleModel articleModel;
    private CaisseControler controller;

    CategorieSelector(final CaisseControler controller, final ArticleModel articleModel) {
        this.setBackground(Color.WHITE);
        this.articleModel = articleModel;
        this.controller = controller;
        controller.addCaisseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 1;
        this.comp = new StatusBar();
        this.comp.setTitle("Cat\u00e9gories");
        this.add((Component)this.comp, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.model = new CategorieModel();
        this.model.setRoot(null);
        final Font f = new Font("Arial", 0, 36);
        final Font smallFont = new Font("Arial", 0, 23);
        this.list = new ScrollableList(this.model){
            int maxWidth;
            {
                super($anonymous0);
                this.maxWidth = 0;
            }

            @Override
            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                if (this.maxWidth == 0) {
                    int strW;
                    g.setFont(f);
                    int w = this.getWidth();
                    int maxW = w - 2 * this.getLeftMargin();
                    String str = "a";
                    do {
                        strW = (int)g.getFontMetrics(f).getStringBounds(str, g).getWidth();
                        str = String.valueOf(str) + "a";
                    } while (strW < maxW);
                    this.maxWidth = Math.max(1, str.length() - 1);
                    System.out.println(String.valueOf(w) + " " + this.getLeftMargin() + " " + this.maxWidth);
                }
                super.paint(g);
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(0, 0, 0, this.getHeight());
            }

            private int getLeftMargin() {
                return 10;
            }

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean selected, int posY) {
                g.setColor(Color.WHITE);
                g.fillRect(0, posY, this.getWidth(), this.getCellHeight());
                g.setColor(Color.GRAY);
                g.drawLine(0, posY + this.getCellHeight() - 1, this.getWidth(), posY + this.getCellHeight() - 1);
                if (selected) {
                    g.setColor(Color.BLACK);
                } else {
                    g.setColor(Color.GRAY);
                }
                String label = object.toString();
                if (label.length() > this.maxWidth * 2) {
                    label = String.valueOf(label.substring(0, this.maxWidth * 2)) + "...";
                }
                String label2 = null;
                if (label.length() > this.maxWidth) {
                    String t = label.substring(0, this.maxWidth).trim();
                    int lastSpace = t.lastIndexOf(32);
                    if (lastSpace <= 0) {
                        lastSpace = this.maxWidth;
                    }
                    label2 = label.substring(lastSpace).trim();
                    label = label.substring(0, lastSpace).trim();
                    if (label2.length() > this.maxWidth) {
                        label2 = String.valueOf(label2.substring(0, this.maxWidth)) + "...";
                    }
                }
                if (label2 == null) {
                    g.setFont(f);
                    g.drawString(label, this.getLeftMargin(), posY + 44);
                } else {
                    g.setFont(smallFont);
                    g.drawString(label, this.getLeftMargin(), posY + 26);
                    g.drawString(label2, this.getLeftMargin(), posY + 52);
                }
            }
        };
        this.list.setFixedCellHeight(64);
        this.list.setOpaque(true);
        this.list.setBackground(Color.WHITE);
        this.add((Component)this.list, c);
        this.list.addListSelectionListener(this);
        this.comp.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Categorie newCategory = CategorieSelector.this.previous;
                CategorieSelector.this.model.setRoot(newCategory);
                CategorieSelector.this.list.clearSelection();
                if (newCategory == null) {
                    CategorieSelector.this.comp.setTitle("Cat\u00e9gories");
                    CategorieSelector.this.previous = null;
                } else {
                    CategorieSelector.this.comp.setTitle(newCategory.getName());
                    CategorieSelector.this.previous = newCategory.getParent();
                }
                articleModel.setCategorie(newCategory);
                controller.setArticleSelected(null);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object sel = this.list.getSelectedValue();
        if (sel != null && !e.getValueIsAdjusting()) {
            Categorie c = (Categorie)sel;
            if (!c.getSubCategories().isEmpty()) {
                this.previous = this.model.getRoot();
                this.model.setRoot(c);
                this.comp.setTitle(c.getName());
                this.list.clearSelection();
            }
            this.articleModel.setCategorie(c);
            if (this.controller.getArticleSelected() != null && !this.controller.getArticleSelected().getCategorie().equals(c)) {
                this.controller.setArticleSelected(null);
            }
        }
    }

    @Override
    public void caisseStateChanged() {
        Article articleSelected = this.controller.getArticleSelected();
        if (articleSelected != null) {
            Categorie c = articleSelected.getCategorie();
            if (c.getParent() != null) {
                this.previous = c.getParent().getParent();
                this.model.setRoot(c.getParent());
                this.comp.setTitle(c.getParent().getName());
            }
            this.list.setSelectedValue(c, true);
        }
    }
}

