/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.element;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.shipment.element.BonDeLivraisonSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.panel.TaskProgressPanel;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;

public class TransfertCommandeAutoUtils {
    private final SQLTable table;

    public TransfertCommandeAutoUtils(SQLTable tableCmd) {
        this.table = tableCmd;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public void transfertMultiBL(final List<SQLRowValues> cmds) {
        final TaskProgressPanel panel = new TaskProgressPanel("Transfert des commandes en bons de livraison", cmds.size());
        final JFrame frame = new JFrame("Transfert des commandes");
        frame.setContentPane(panel);
        SwingWorker<Object, Object> w = new SwingWorker<Object, Object>(){

            @Override
            protected Object doInBackground() throws Exception {
                Date toDay = new Date();
                int p = 0;
                for (SQLRowValues sqlRowValues : cmds) {
                    try {
                        TransfertCommandeAutoUtils.this.transfertBL(toDay, sqlRowValues);
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Erreur lors du transfert en bl!", e);
                    }
                    final int progress = ++p;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            panel.updateProgress(progress);
                        }
                    });
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                frame.dispose();
            }
        };
        w.execute();
        FrameUtil.showPacked(frame);
    }

    public SQLRow transfertBL(Date dateTransfert, SQLRowValues sqlRowCmd) throws Exception {
        SQLTable tableTR = sqlRowCmd.getTable().getTable("TR_COMMANDE_CLIENT");
        SQLRowValues rowValsTR = new SQLRowValues(tableTR);
        rowValsTR.setAllToNull();
        List<SQLRowValues> fetchTR = SQLRowValuesListFetcher.create(rowValsTR).fetch(new Where((FieldRef)tableTR.getField("ID_COMMANDE_CLIENT"), "=", sqlRowCmd.getID()).and(new Where((FieldRef)tableTR.getField("ID_BON_DE_LIVRAISON"), ">", 1)));
        if (fetchTR.isEmpty()) {
            SQLInjector inj = SQLInjector.getInjector(this.getTable(), this.getTable().getTable("BON_DE_LIVRAISON"));
            SQLRowValues rowValuesBL = inj.createRowValuesFrom(sqlRowCmd.asRow());
            SQLTable referentTable = this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
            rowValuesBL.put("DATE", dateTransfert);
            BonDeLivraisonSQLElement elementBL = (BonDeLivraisonSQLElement)Configuration.getInstance().getDirectory().getElement(rowValuesBL.getTable());
            rowValuesBL.put("NUMERO", this.getNextNumero(rowValuesBL.getTable(), elementBL.getClass(), dateTransfert));
            rowValuesBL.put("TOTAL_HT", sqlRowCmd.getObject("T_HT"));
            rowValuesBL.put("TOTAL_TVA", sqlRowCmd.getObject("T_TVA"));
            rowValuesBL.put("TOTAL_TTC", sqlRowCmd.getObject("T_TTC"));
            SQLInsert insert = new SQLInsert();
            insert.importValuesFrom(rowValuesBL);
            List<Number> executeSimilarInserts = SQLInsert.executeSimilarInserts(elementBL.getTable().getDBSystemRoot(), Arrays.asList(insert), true);
            Collection<SQLRowValues> refs = rowValuesBL.getReferentRows(referentTable);
            ArrayList<SQLInsert> items = new ArrayList<SQLInsert>(refs.size());
            for (SQLRowValues refRow : refs) {
                refRow.put("QTE_LIVREE", refRow.getObject("QTE"));
                refRow.put("ID_BON_DE_LIVRAISON", executeSimilarInserts.get(0));
                SQLInsert insertitem = new SQLInsert();
                insertitem.importValuesFrom(refRow);
                items.add(insertitem);
            }
            SQLInsert.executeSimilarInserts(elementBL.getTable().getDBSystemRoot(), items, false);
            SQLRow row = elementBL.getTable().getRow(executeSimilarInserts.get(0).intValue());
            inj.commitTransfert(Arrays.asList(sqlRowCmd), row.getID());
            this.updateStock(row, referentTable, "Bon de livraison N\u00b0");
            List<Object> cmdDourceTrRowsFrom = elementBL.getSourceTrRowsFrom(row.getID(), "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
            elementBL.updateQteLivree(cmdDourceTrRowsFrom, "COMMANDE_CLIENT_ELEMENT", "COMMANDE_CLIENT");
            List<Object> devisSourceTrRowsFrom = elementBL.getSourceTrRowsFrom(row.getID(), "DEVIS_ELEMENT", "DEVIS");
            elementBL.updateQteLivree(devisSourceTrRowsFrom, "DEVIS_ELEMENT", "DEVIS");
            return row;
        }
        return null;
    }

    public void transfertFacture(List<SQLRowValues> cmds) {
        for (SQLRowValues sqlRowValues : cmds) {
            SQLInjector inj = SQLInjector.getInjector(this.getTable(), this.getTable().getTable("SAISIE_VENTE_FACTURE"));
            SQLRow asRowCmd = sqlRowValues.asRow();
            SQLRowValues rowValuesfacture = inj.createRowValuesFrom(asRowCmd);
            try {
                SQLRowValues rowVals = new SQLRowValues(this.getTable().getTable("MODE_REGLEMENT"));
                rowVals.put("ID_TYPE_REGLEMENT", 7);
                rowVals.put("DATE_FACTURE", Boolean.TRUE);
                rowVals.put("COMPTANT", Boolean.FALSE);
                rowVals.put("FIN_MOIS", Boolean.FALSE);
                rowVals.put("LENJOUR", 0);
                rowVals.put("AJOURS", 0);
                SQLRow commit = rowVals.commit();
                rowValuesfacture.put("ID_MODE_REGLEMENT", commit.getID());
                rowValuesfacture.put("ID_COMMERCIAL", asRowCmd.getForeignID("ID_COMMERCIAL"));
                Date dateToday = new Date();
                rowValuesfacture.put("DATE", dateToday);
                SQLElement elementFActure = Configuration.getInstance().getDirectory().getElement(rowValuesfacture.getTable());
                rowValuesfacture.put("NUMERO", this.getNextNumero(rowValuesfacture.getTable(), elementFActure.getClass(), dateToday));
                if (this.getTable().contains("ID_TAXE_PORT")) {
                    SQLRow taxeDefault = TaxeCache.getCache().getFirstTaxe();
                    rowValuesfacture.put("ID_TAXE_PORT", taxeDefault.getID());
                }
                rowValuesfacture.put("T_HT", asRowCmd.getObject("T_HT"));
                rowValuesfacture.put("T_TVA", asRowCmd.getObject("T_TVA"));
                rowValuesfacture.put("T_TTC", asRowCmd.getObject("T_TTC"));
                rowValuesfacture.put("NET_A_PAYER", asRowCmd.getObject("T_TTC"));
                SQLTable referentTable = this.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT");
                SQLInsert insert = new SQLInsert();
                insert.importValuesFrom(rowValuesfacture);
                List<Number> executeSimilarInserts = SQLInsert.executeSimilarInserts(elementFActure.getTable().getDBSystemRoot(), Arrays.asList(insert), true);
                Collection<SQLRowValues> refs = rowValuesfacture.getReferentRows(referentTable);
                ArrayList<SQLInsert> items = new ArrayList<SQLInsert>(refs.size());
                for (SQLRowValues refRow : refs) {
                    refRow.put("ID_SAISIE_VENTE_FACTURE", executeSimilarInserts.get(0));
                    SQLInsert insertitem = new SQLInsert();
                    insertitem.importValuesFrom(refRow);
                    items.add(insertitem);
                }
                SQLInsert.executeSimilarInserts(elementFActure.getTable().getDBSystemRoot(), items, false);
                SQLRow row = elementFActure.getTable().getRow(executeSimilarInserts.get(0).intValue());
                inj.commitTransfert(Arrays.asList(sqlRowValues), row.getID());
                new GenerationMvtSaisieVenteFacture(row.getID());
                this.updateStock(row, referentTable, "Facture N\u00b0");
            }
            catch (Exception e) {
                ExceptionHandler.handle("Erreur lors du transfert en facture!", e);
            }
        }
    }

    private String getNextNumero(SQLTable table, Class<? extends SQLElement> element, Date toDay) throws IllegalStateException {
        SQLTable tableNum = this.getTable().getTable("NUMEROTATION_AUTO");
        String num = NumerotationAutoSQLElement.getNextNumero(element, toDay);
        SQLSelect selNum = new SQLSelect();
        selNum.addSelect(table.getKey(), "COUNT");
        Where w = new Where((FieldRef)table.getField("NUMERO"), "=", (Object)num);
        selNum.setWhere(w);
        String req = selNum.asString();
        Number l = (Number)this.getTable().getBase().getDataSource().execute(req, new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false));
        if (l.intValue() <= 0) {
            SQLRow rowNum = tableNum.getRow(2);
            SQLRowValues rowValsNum = rowNum.createEmptyUpdateRow();
            String labelNumberFor = NumerotationAutoSQLElement.getLabelNumberFor(element);
            int val = rowNum.getInt(labelNumberFor);
            rowValsNum.put(labelNumberFor, (Object)(++val));
            try {
                rowValsNum.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("La num\u00e9ratotation automatique n'est pas correcte! Un num\u00e9ro existant est retourn\u00e9!");
        }
        return num;
    }

    private void updateStock(SQLRow row, SQLTable referentTable, final String labelPrefix) throws SQLException {
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        boolean stockOnFacture = prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true);
        if (row.getTable().getName().equals("BON_DE_LIVRAISON") && !stockOnFacture || row.getTable().getName().equals("SAISIE_VENTE_FACTURE") && stockOnFacture) {
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return String.valueOf(labelPrefix) + rowOrigin.getString("NUMERO");
                }
            }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(referentTable), StockItemsUpdater.TypeStockUpdate.REAL_DELIVER);
            stockUpdater.update();
        }
    }
}

