/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.DeviseField;
import org.openconcerto.erp.core.finance.accounting.report.RapprochementBancaireSheetXML;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.ExceptionHandler;

public class ImpressionEtatRapprochementPanel
extends JPanel {
    private final JDate dateEnd;
    private final JDate dateStart;
    private JButton valid;
    private JButton annul;
    private JTextField numeroReleve;
    private SQLRequestComboBox compteDeb;

    public ImpressionEtatRapprochementPanel(final SQLElement eltCpt, int idCptSel) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        this.dateEnd = new JDate();
        this.dateStart = new JDate();
        this.add((Component)new JLabel("Ecritures du"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.dateStart, c);
        ++c.gridx;
        this.add((Component)new JLabel("au"), c);
        ++c.gridx;
        c.weightx = 1.0;
        c.gridwidth = 1;
        this.add((Component)this.dateEnd, c);
        String valueDateEnd = DefaultNXProps.getInstance().getStringProperty("EtatRapproDateEnd");
        if (valueDateEnd.trim().length() > 0) {
            Long l = new Long(valueDateEnd);
            this.dateEnd.setValue(new Date(l));
        } else {
            this.dateEnd.setValue((Date)rowExercice.getObject("DATE_FIN"));
        }
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Filtr\u00e9 sur le relev\u00e9"), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.numeroReleve = new JTextField(15);
        this.add((Component)this.numeroReleve, c);
        JLabel labelSolde = new JLabel("Solde bancaire de d\u00e9part");
        ++c.gridx;
        this.add((Component)labelSolde, c);
        ++c.gridx;
        final DeviseField fieldSolde = new DeviseField(20);
        c.weightx = 1.0;
        this.add((Component)fieldSolde, c);
        this.compteDeb = new SQLRequestComboBox(false);
        this.compteDeb.uiInit(eltCpt.getComboRequest(true));
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Du compte "), c);
        ++c.gridx;
        c.weightx = 1.0;
        this.add((Component)this.compteDeb, c);
        c.gridx += 2;
        final JCheckBox box = new JCheckBox("Ne pas afficher le d\u00e9tail des lignes point\u00e9es");
        this.add((Component)box, c);
        this.valid = new JButton("Valider");
        this.annul = new JButton("Fermer");
        ++c.gridy;
        c.gridx = 0;
        c.fill = 0;
        c.anchor = 10;
        this.add((Component)this.valid, c);
        c.gridx += 2;
        this.add((Component)this.annul, c);
        this.checkValidity();
        this.valid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImpressionEtatRapprochementPanel.this.valid.setEnabled(false);
                BigDecimal soldeDepart = fieldSolde.getValue() == null ? null : new BigDecimal(fieldSolde.getValue()).movePointLeft(2);
                RapprochementBancaireSheetXML sheet = new RapprochementBancaireSheetXML(ImpressionEtatRapprochementPanel.this.dateStart.getDate(), ImpressionEtatRapprochementPanel.this.dateEnd.getDate(), eltCpt.getTable().getRow(ImpressionEtatRapprochementPanel.this.compteDeb.getWantedID()).getString("NUMERO"), !box.isSelected(), ImpressionEtatRapprochementPanel.this.numeroReleve.getText(), soldeDepart);
                try {
                    sheet.createDocument();
                    sheet.openDocument(false);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du document", e1);
                }
            }
        });
        this.annul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ImpressionEtatRapprochementPanel.this)).dispose();
            }
        });
        this.dateEnd.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionEtatRapprochementPanel.this.checkValidity();
                ImpressionEtatRapprochementPanel.this.storeValue();
            }
        });
        this.compteDeb.addModelListener("wantedID", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ImpressionEtatRapprochementPanel.this.checkValidity();
            }
        });
        if (idCptSel != -1) {
            this.compteDeb.setValue(idCptSel);
        }
    }

    private void checkValidity() {
        if (this.compteDeb.getWantedID() != -1) {
            Date endDate = this.dateEnd.getDate();
            if (endDate == null) {
                this.valid.setEnabled(false);
            } else {
                this.valid.setEnabled(true);
            }
        } else {
            this.valid.setEnabled(false);
        }
    }

    private void storeValue() {
        Date dFin = this.dateEnd.getDate();
        if (dFin != null) {
            DefaultNXProps.getInstance().setProperty("EtatRapproDateEnd", String.valueOf(dFin.getTime()));
        }
        DefaultNXProps.getInstance().store();
    }
}

