/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.customerrelationship.customer.report;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import org.openconcerto.erp.core.customerrelationship.customer.report.ReportingDecadeXmlSheet;
import org.openconcerto.erp.core.sales.invoice.report.VenteFactureXmlSheet;
import org.openconcerto.erp.core.sales.shipment.report.BonLivraisonXmlSheet;
import org.openconcerto.erp.generationDoc.SheetXml;
import org.openconcerto.erp.generationDoc.gestcomm.AvoirClientXmlSheet;
import org.openconcerto.erp.utils.PDFMerger;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;

public class ReportingDecadePanel
extends JPanel {
    public ReportingDecadePanel(final DBRoot root, final SQLElement clientSQLElement) {
        super(new GridBagLayout());
        JLabel labelCom = new JLabel("D\u00e9cade");
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        this.add((Component)labelCom, c);
        ++c.gridx;
        String[] values = new String[]{"D\u00e9cade 1", "D\u00e9cade 2", "D\u00e9cade 3", "Tous"};
        final JComboBox<String> decade = new JComboBox<String>(values);
        this.add(decade, c);
        JLabel labelYear = new JLabel("Mois");
        List<String> monthValues = Arrays.asList("Janvier", "F\u00e9vrier", "Mars", "Avril", "Mai", "Juin", "Juillet", "Ao\u00fbt", "Septembre", "Octobre", "Novembre", "D\u00e9cembre");
        final JComboBox<String> monthBox = new JComboBox<String>((String[])monthValues.toArray());
        ++c.gridx;
        this.add((Component)labelYear, c);
        ++c.gridx;
        this.add(monthBox, c);
        final JSpinner spin = new JSpinner();
        spin.setValue(Calendar.getInstance().get(1));
        ++c.gridx;
        this.add((Component)spin, c);
        String[] typeValues = new String[]{"Bons de livraison", "Factures"};
        final JComboBox<String> types = new JComboBox<String>(typeValues);
        ++c.gridx;
        this.add((Component)new JLabel("Type"), c);
        ++c.gridx;
        this.add(types, c);
        final SQLRequestComboBox boxClient = new SQLRequestComboBox(false);
        boxClient.uiInit(clientSQLElement.getComboRequest(true));
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)new JLabel("Client"), c);
        ++c.gridx;
        this.add((Component)boxClient, c);
        JButton buttonValid = new JButton(new AbstractAction("Valider"){

            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread(){

                    @Override
                    public void run() {
                        Date dateFin;
                        Date dateDebut;
                        String decadeLabel;
                        Calendar calDebut = Calendar.getInstance();
                        calDebut.set(2, 0);
                        calDebut.set(5, 1);
                        calDebut.set(10, 0);
                        calDebut.set(12, 0);
                        calDebut.set(13, 1);
                        calDebut.set(1, (Integer)spin.getValue());
                        calDebut.set(2, monthBox.getSelectedIndex());
                        String mois = String.valueOf(monthBox.getSelectedIndex() + 1);
                        String year = String.valueOf((Integer)spin.getValue());
                        if (decade.getSelectedIndex() == 0) {
                            decadeLabel = "D1";
                            dateDebut = calDebut.getTime();
                            calDebut.set(5, 10);
                            calDebut.set(11, 23);
                            calDebut.set(12, 59);
                            calDebut.set(13, 59);
                            dateFin = calDebut.getTime();
                        } else if (decade.getSelectedIndex() == 1) {
                            decadeLabel = "D2";
                            calDebut.set(5, 11);
                            dateDebut = calDebut.getTime();
                            calDebut.set(5, 20);
                            calDebut.set(11, 23);
                            calDebut.set(12, 59);
                            calDebut.set(13, 59);
                            dateFin = calDebut.getTime();
                        } else if (decade.getSelectedIndex() == 2) {
                            decadeLabel = "D3";
                            calDebut.set(5, 21);
                            dateDebut = calDebut.getTime();
                            calDebut.set(5, calDebut.getActualMaximum(5));
                            calDebut.set(11, 23);
                            calDebut.set(12, 59);
                            calDebut.set(13, 59);
                            dateFin = calDebut.getTime();
                        } else {
                            decadeLabel = "Tout";
                            calDebut.set(5, 1);
                            dateDebut = calDebut.getTime();
                            calDebut.set(5, calDebut.getActualMaximum(5));
                            calDebut.set(11, 23);
                            calDebut.set(12, 59);
                            calDebut.set(13, 59);
                            dateFin = calDebut.getTime();
                        }
                        String table = types.getSelectedIndex() == 0 ? "BON_DE_LIVRAISON" : "SAISIE_VENTE_FACTURE";
                        SQLTable tableVenteFacture = root.getTable(table);
                        SQLSelect sel = new SQLSelect();
                        sel.addSelectStar(tableVenteFacture);
                        Where w = new Where((FieldRef)tableVenteFacture.getField("DATE"), dateDebut, (Object)dateFin);
                        w = w.and(new Where((FieldRef)tableVenteFacture.getField("ID_CLIENT"), "=", boxClient.getWantedID()));
                        sel.setWhere(w);
                        List<SQLRow> execute = SQLRowListRSH.execute(sel);
                        ArrayList<SQLRow> result = new ArrayList<SQLRow>();
                        result.addAll(execute);
                        if (types.getSelectedIndex() == 1) {
                            SQLSelect selAvoir = new SQLSelect();
                            SQLTable tableAvoir = root.getTable("AVOIR_CLIENT");
                            selAvoir.addSelectStar(tableAvoir);
                            Where wA = new Where((FieldRef)tableAvoir.getField("DATE"), dateDebut, (Object)dateFin);
                            wA = wA.and(new Where((FieldRef)tableAvoir.getField("ID_CLIENT"), "=", boxClient.getWantedID()));
                            selAvoir.setWhere(wA);
                            List<SQLRow> executeA = SQLRowListRSH.execute(selAvoir);
                            result.addAll(executeA);
                        }
                        ArrayList<File> files = new ArrayList<File>();
                        SQLRow rowClient = clientSQLElement.getTable().getRow(boxClient.getWantedID());
                        ReportingDecadeXmlSheet shhet = new ReportingDecadeXmlSheet(clientSQLElement.getDirectory(), table, dateDebut, dateFin, rowClient);
                        try {
                            shhet.createDocument();
                            shhet.showPrintAndExport(false, false, true, true, true);
                            File pdfDecade = shhet.getOrCreatePDFDocumentFile(true);
                            files.add(pdfDecade);
                            for (SQLRow r : result) {
                                File blPdf;
                                Object b;
                                if (types.getSelectedIndex() == 0) {
                                    b = new BonLivraisonXmlSheet(r);
                                    ((SheetXml)b).createDocument();
                                    ((SheetXml)b).showPrintAndExport(false, false, true, true, true);
                                    blPdf = ((SheetXml)b).getOrCreatePDFDocumentFile(true);
                                    files.add(blPdf);
                                    continue;
                                }
                                if (r.getTable().getName().equals("SAISIE_VENTE_FACTURE")) {
                                    b = new VenteFactureXmlSheet(r);
                                    ((SheetXml)b).createDocument();
                                    ((SheetXml)b).showPrintAndExport(false, false, true, true, true);
                                    blPdf = ((SheetXml)b).getOrCreatePDFDocumentFile(true);
                                    files.add(blPdf);
                                    continue;
                                }
                                b = new AvoirClientXmlSheet(r);
                                ((SheetXml)b).createDocument();
                                ((SheetXml)b).showPrintAndExport(false, false, true, true, true);
                                blPdf = ((SheetXml)b).getOrCreatePDFDocumentFile(true);
                                files.add(blPdf);
                            }
                            ArrayList<FileInputStream> is = new ArrayList<FileInputStream>();
                            for (File f : files) {
                                is.add(new FileInputStream(f));
                            }
                            String clientName = FileUtils.sanitize(StringUtils.limitLength(rowClient.getString("NOM"), 15));
                            File file = new File(pdfDecade.getParent(), String.valueOf(clientName) + "_" + decadeLabel + "_" + mois + "_" + year + "_" + pdfDecade.getName());
                            PDFMerger.mergePdfFiles(is, (OutputStream)new FileOutputStream(file));
                            FileUtils.openFile(file);
                        }
                        catch (Exception e1) {
                            ExceptionHandler.handle(ReportingDecadePanel.this, "Erreur lors de la cr\u00e9ation du r\u00e9capitulatif", e1);
                        }
                    }
                }.start();
            }
        });
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)buttonValid, c);
    }
}

