/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.openconcerto.erp.core.finance.accounting.model.Currency;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.GestionDevise;
import org.openconcerto.utils.StringUtils;

public class Acompte {
    protected BigDecimal montant;
    protected BigDecimal montantRemise = BigDecimal.ZERO;
    protected BigDecimal montantPort = BigDecimal.ZERO;
    protected BigDecimal percent;
    private CurrencyConverter converter = new CurrencyConverter();
    public static final Acompte HUNDRED_PERCENT = new Acompte(new BigDecimal(100), null);

    public BigDecimal getMontant() {
        return this.montant;
    }

    public BigDecimal getPercent() {
        return this.percent;
    }

    public Acompte(BigDecimal percent, BigDecimal montant) {
        this.montant = montant;
        this.percent = percent;
    }

    public String toPlainString(boolean withCurrencySymbol) {
        if (this.percent != null) {
            DecimalFormat format = new DecimalFormat("##0.00");
            return String.valueOf(format.format(this.percent)) + "%";
        }
        if (this.montant != null) {
            DecimalFormat format = new DecimalFormat("###,##0.00");
            String string = format.format(this.montant);
            if (withCurrencySymbol) {
                string = String.valueOf(string) + Currency.getSymbol(this.converter.getCompanyCurrencyCode());
            }
            return string;
        }
        return "";
    }

    public void setMontantRemise(BigDecimal montantRemise) {
        this.montantRemise = montantRemise;
    }

    public void setMontantPort(BigDecimal montantPort) {
        this.montantPort = montantPort;
    }

    public BigDecimal getMontantPort() {
        return this.montantPort;
    }

    public BigDecimal getMontantRemise() {
        return this.montantRemise;
    }

    public String toString() {
        if (this.percent != null) {
            return String.valueOf(this.percent.toString()) + "%";
        }
        if (this.montant != null) {
            return GestionDevise.currencyToString(this.montant);
        }
        return "";
    }

    public BigDecimal getResultFrom(BigDecimal montant) {
        if (this.percent != null) {
            return montant.multiply(this.percent.movePointLeft(2), DecimalUtils.HIGH_PRECISION);
        }
        if (this.getMontant() == null) {
            return montant;
        }
        return this.getMontant();
    }

    public static Acompte fromString(String s) {
        Acompte a;
        if (s == null || s.trim().length() == 0) {
            return null;
        }
        if (s.contains("%")) {
            String replace = s.replace("%", "");
            BigDecimal percent = StringUtils.getBigDecimalFromUserText(replace);
            if (percent == null) {
                percent = BigDecimal.ZERO;
            }
            a = new Acompte(percent, null);
        } else {
            a = new Acompte(null, StringUtils.getBigDecimalFromUserText(s.replaceAll(",", ".")));
        }
        return a;
    }
}

