/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.alg.color;

import java.util.BitSet;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.experimental.alg.ExactAlgorithm;
import org.jgrapht.experimental.alg.IntArrayGraphAlgorithm;

public class BrownBacktrackColoring<V, E>
extends IntArrayGraphAlgorithm<V, E>
implements ExactAlgorithm<Integer, V> {
    private int[] _color;
    private int[] _colorCount;
    private BitSet[] _allowedColors;
    private int _chi;

    public BrownBacktrackColoring(Graph<V, E> g) {
        super(g);
    }

    void recursiveColor(int pos) {
        this._colorCount[pos] = this._colorCount[pos - 1];
        this._allowedColors[pos].set(0, this._colorCount[pos] + 1);
        int i = 0;
        while (i < this._neighbors[pos].length) {
            int nb = this._neighbors[pos][i];
            if (this._color[nb] > 0) {
                this._allowedColors[pos].clear(this._color[nb]);
            }
            ++i;
        }
        i = 1;
        while (i <= this._colorCount[pos] && this._colorCount[pos] < this._chi) {
            if (this._allowedColors[pos].get(i)) {
                this._color[pos] = i;
                if (pos < this._neighbors.length - 1) {
                    this.recursiveColor(pos + 1);
                } else {
                    this._chi = this._colorCount[pos];
                }
            }
            ++i;
        }
        if (this._colorCount[pos] + 1 < this._chi) {
            int n = pos;
            this._colorCount[n] = this._colorCount[n] + 1;
            this._color[pos] = this._colorCount[pos];
            if (pos < this._neighbors.length - 1) {
                this.recursiveColor(pos + 1);
            } else {
                this._chi = this._colorCount[pos];
            }
        }
        this._color[pos] = 0;
    }

    @Override
    public Integer getResult(Map<V, Object> additionalData) {
        this._chi = this._neighbors.length;
        this._color = new int[this._neighbors.length];
        this._color[0] = 1;
        this._colorCount = new int[this._neighbors.length];
        this._colorCount[0] = 1;
        this._allowedColors = new BitSet[this._neighbors.length];
        int i = 0;
        while (i < this._neighbors.length) {
            this._allowedColors[i] = new BitSet(1);
            ++i;
        }
        this.recursiveColor(1);
        i = 0;
        while (i < this._vertices.size()) {
            additionalData.put(this._vertices.get(i), this._color[i]);
            ++i;
        }
        return this._chi;
    }
}

