/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import net.jcip.annotations.Immutable;
import org.openconcerto.utils.i18n.I18nUtils;

@Immutable
public class BooleanFormat
extends Format {
    private static final boolean[] BOOLEAN_VALUES;
    private static final BooleanFormat NUMBER_INSTANCE;
    private final String[] formattedValues;

    static {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        BOOLEAN_VALUES = blArray;
        NUMBER_INSTANCE = new BooleanFormat("0", "1");
    }

    private static String[] getFormattedBooleans(Locale l, boolean yesNo) {
        ResourceBundle bundle = ResourceBundle.getBundle(I18nUtils.RSRC_BASENAME, l);
        String[] res = new String[BOOLEAN_VALUES.length];
        int i = 0;
        while (i < res.length) {
            boolean b = BOOLEAN_VALUES[i];
            res[i] = bundle.getString(yesNo ? I18nUtils.getYesNoKey(b) : I18nUtils.getBooleanKey(b));
            ++i;
        }
        return res;
    }

    public static BooleanFormat createYesNo(Locale l) {
        return new BooleanFormat(BooleanFormat.getFormattedBooleans(l, true));
    }

    public static BooleanFormat createTrueFalse(Locale l) {
        return new BooleanFormat(BooleanFormat.getFormattedBooleans(l, false));
    }

    public static final BooleanFormat getNumberInstance() {
        return NUMBER_INSTANCE;
    }

    public static final BooleanFormat[] getAll(Locale l) {
        return new BooleanFormat[]{BooleanFormat.createTrueFalse(l), BooleanFormat.createYesNo(l), BooleanFormat.getNumberInstance()};
    }

    public BooleanFormat() {
        this(BooleanFormat.getFormattedBooleans(Locale.getDefault(), false));
    }

    public BooleanFormat(String falseValue, String trueValue) {
        this(new String[]{falseValue, trueValue});
    }

    private BooleanFormat(String[] formattedValues) {
        this.formattedValues = formattedValues;
    }

    public final String format(boolean b) {
        return this.formattedValues[b ? 1 : 0];
    }

    protected final String format(Boolean b) {
        return b == null ? "" : this.format((boolean)b);
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj == null) {
            return toAppendTo;
        }
        if (obj instanceof Boolean) {
            return toAppendTo.append(this.format((Boolean)obj));
        }
        throw new IllegalArgumentException("Not a boolean : " + obj);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        boolean[] blArray = BOOLEAN_VALUES;
        int n = BOOLEAN_VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            String value = this.format(b);
            if (source.substring(pos.getIndex()).startsWith(value)) {
                pos.setIndex(pos.getIndex() + value.length());
                return b;
            }
            ++n2;
        }
        pos.setErrorIndex(pos.getIndex());
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.formattedValues);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanFormat other = (BooleanFormat)obj;
        return Arrays.equals(this.formattedValues, other.formattedValues);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " with " + Arrays.asList(this.formattedValues);
    }
}

