/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import org.jopencalendar.ui.DatePickerPanel;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.ui.TimeSpinField;
import org.openconcerto.ui.TimeTextField;

public class TimestampEditorPanel
extends JPanel
implements ActionListener {
    private TimeSpinField timeSpinner;
    private TimeTextField timeText;
    private JPanel panelHour;
    private DatePickerPanel pickerPanel;
    private List<ActionListener> listeners = new ArrayList<ActionListener>();
    private Calendar calendar = Calendar.getInstance();
    private JDate dateEditor;
    private boolean allowNull = false;
    final JButton buttonClear;

    public TimestampEditorPanel() {
        this(false);
    }

    public TimestampEditorPanel(boolean useSpinner) {
        this(useSpinner, null);
    }

    public TimestampEditorPanel(boolean useSpinner, final ActionListener validateListener) {
        this.calendar.set(13, 0);
        this.calendar.set(14, 0);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 3, 0, 2);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 13;
        c.fill = 2;
        this.panelHour = new JPanel(new GridBagLayout());
        JLabel labelHour = new JLabel("Heure ", 4);
        labelHour.setFont(labelHour.getFont().deriveFont(1));
        this.panelHour.add((Component)labelHour, c);
        ++c.gridx;
        if (useSpinner) {
            this.timeSpinner = new TimeSpinField();
            this.timeSpinner.setMinimumSize(new Dimension(this.timeSpinner.getPreferredSize()));
            this.panelHour.add((Component)this.timeSpinner, c);
        } else {
            this.timeText = new TimeTextField();
            this.timeText.grabFocus();
            this.panelHour.add((Component)this.timeText, c);
        }
        ++c.gridx;
        this.buttonClear = new JButton(new ImageIcon(TimestampEditorPanel.class.getResource("close_popup_gray.png")));
        this.buttonClear.setVisible(false);
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimestampEditorPanel.this.calendar = null;
                TimestampEditorPanel.this.fireTimeChangedPerformed();
                if (validateListener != null) {
                    validateListener.actionPerformed(e);
                }
            }
        });
        this.buttonClear.setBorderPainted(false);
        this.buttonClear.setOpaque(false);
        this.buttonClear.setFocusPainted(false);
        this.buttonClear.setContentAreaFilled(false);
        this.buttonClear.setMargin(new Insets(1, 1, 1, 1));
        this.buttonClear.setFocusable(false);
        JButton buttonClose = new JButton(new ImageIcon(TimestampEditorPanel.class.getResource("validate_popup.png")));
        if (validateListener != null) {
            buttonClose.addActionListener(validateListener);
        }
        buttonClose.setBorderPainted(false);
        buttonClose.setOpaque(false);
        buttonClose.setFocusPainted(false);
        buttonClose.setContentAreaFilled(false);
        buttonClose.setMargin(new Insets(1, 1, 1, 1));
        buttonClose.setFocusable(false);
        c.gridx = 0;
        this.panelHour.setOpaque(false);
        ++c.gridy;
        this.panelHour.add((Component)new JLabelBold("Date "), c);
        ++c.gridx;
        c.gridwidth = 2;
        this.dateEditor = new JDate(true, true);
        this.dateEditor.getTextComp().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                final JTextComponent textComp = TimestampEditorPanel.this.dateEditor.getTextComp();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComp.selectAll();
                    }
                });
            }
        });
        this.dateEditor.setButtonVisible(false);
        this.dateEditor.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Calendar c = Calendar.getInstance();
                java.util.Date date = TimestampEditorPanel.this.dateEditor.getDate();
                if (date != null) {
                    c.setTimeInMillis(date.getTime());
                    TimestampEditorPanel.this.pickerPanel.setSelectedDate(c);
                    TimestampEditorPanel.this.calendar.set(1, c.get(1));
                    TimestampEditorPanel.this.calendar.set(2, c.get(2));
                    TimestampEditorPanel.this.calendar.set(5, c.get(5));
                    TimestampEditorPanel.this.dateOrTimeChanged();
                }
            }
        });
        this.panelHour.add((Component)this.dateEditor, c);
        c.gridwidth = 1;
        this.add((Component)this.panelHour, c);
        c.fill = 0;
        c.anchor = 12;
        c.weightx = 1.0;
        ++c.gridx;
        this.add((Component)this.buttonClear, c);
        ++c.gridx;
        this.add((Component)buttonClose, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 4;
        c.insets = new Insets(4, 0, 0, 0);
        c.fill = 2;
        this.add((Component)new JSeparator(0), c);
        this.setBackground(Color.WHITE);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.fill = 1;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        this.pickerPanel = new DatePickerPanel();
        this.pickerPanel.setFocusable(false);
        this.add((Component)this.pickerPanel, c);
        ++c.gridy;
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.pickerPanel.addPropertyChangeListener("timeInMillis", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TimestampEditorPanel.this.dateOrTimeChanged();
            }
        });
        if (useSpinner) {
            this.timeSpinner.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TimestampEditorPanel.this.dateOrTimeChanged();
                }
            });
        } else {
            this.timeText.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    TimestampEditorPanel.this.dateOrTimeChanged();
                }
            });
            this.timeText.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    if ((e.getKeyCode() == 9 || e.getKeyCode() == 10) && validateListener != null) {
                        validateListener.actionPerformed(new ActionEvent(e.getSource(), e.getID(), null));
                    }
                }
            });
        }
    }

    public void setTime(java.util.Date time) {
        if (time == null && !this.allowNull) {
            throw new IllegalArgumentException("null is not allowed, use setAllowNull() if needed");
        }
        Calendar c = Calendar.getInstance();
        if (time == null) {
            this.calendar = null;
        } else {
            c.setTimeInMillis(time.getTime());
            this.calendar = c;
        }
        int hour = c.get(11);
        int minute = c.get(12);
        this.pickerPanel.setSelectedDate(c);
        if (this.timeSpinner != null) {
            this.timeSpinner.setTime(hour, minute);
        } else {
            this.timeText.setTime(hour, minute);
        }
    }

    public final Timestamp getTimestamp() {
        if (this.calendar == null) {
            return null;
        }
        return new Timestamp(this.calendar.getTimeInMillis());
    }

    public final Time getTime() {
        if (this.calendar == null) {
            return null;
        }
        return Time.valueOf(String.valueOf(this.calendar.get(11)) + ":" + this.calendar.get(12) + ":00");
    }

    public final Date getDate() {
        if (this.calendar == null) {
            return null;
        }
        return Date.valueOf(String.valueOf(this.calendar.get(1)) + "-" + (this.calendar.get(2) + 1) + "-" + this.calendar.get(5));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dateOrTimeChanged();
    }

    public void dateOrTimeChanged() {
        this.stateChanged();
        this.fireTimeChangedPerformed();
    }

    public void stateChanged() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTime(this.pickerPanel.getSelectedDate());
        this.dateEditor.setDate(this.pickerPanel.getSelectedDate());
        if (this.timeSpinner != null) {
            this.calendar.set(11, this.timeSpinner.getHours());
            this.calendar.set(12, this.timeSpinner.getMinutes());
        } else {
            this.calendar.set(11, this.timeText.getHours());
            this.calendar.set(12, this.timeText.getMinutes());
        }
    }

    private void fireTimeChangedPerformed() {
        int size = this.listeners.size();
        int i = 0;
        while (i < size) {
            ActionListener element = this.listeners.get(i);
            element.actionPerformed(null);
            ++i;
        }
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(listener);
    }

    public void setHourVisible(boolean b) {
        this.panelHour.setVisible(b);
    }

    @Override
    public void requestFocus() {
        this.timeText.requestFocus();
        this.timeText.setCaretPosition(0);
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        final TimestampEditorPanel t = new TimestampEditorPanel();
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(1, 2014);
        c.set(6, 8);
        c.set(11, 13);
        c.set(12, 14);
        t.setTime(c.getTime());
        t.setAllowNull(true);
        t.setTime(null);
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("TimestampEditorPanel got timestamp :" + t.getTimestamp());
                System.out.println("TimestampEditorPanel got date :" + t.getDate());
                System.out.println("TimestampEditorPanel got time :" + t.getTime());
            }
        });
        f.setContentPane(t);
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    public void setAllowNull(boolean b) {
        this.allowNull = b;
        this.buttonClear.setVisible(b);
    }
}

