/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableEvent;
import org.openconcerto.sql.model.SQLTableModifiedListener;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserSingleton;
import org.openconcerto.sql.users.UserSingletonManager;
import org.openconcerto.utils.CompareUtils;
import org.openconcerto.utils.ThreadFactory;

@ThreadSafe
public class UserManager
implements UserSingleton {
    private static final UserSingletonManager<UserManager> sMngr = new UserSingletonManager<UserManager>("USER_COMMON"){

        @Override
        protected UserManager createInstance(SQLTable t) {
            return new UserManager(t).start();
        }
    };
    private static final long MAX_AGE_MS = 480000L;
    public static final String CURRENT_USERID_PROPNAME = "currentUserID";
    public static final String USERS_PROPNAME = "users";
    private final SQLTable t;
    @GuardedBy(value="this")
    private Map<Integer, User> byID = null;
    @GuardedBy(value="this")
    private long timeOfLastFill = -1L;
    @GuardedBy(value="this")
    private Integer currentUserID = null;
    private final SQLTableModifiedListener tableL;
    @GuardedBy(value="this")
    private ScheduledFuture<?> scheduledUpdateUsers;
    @GuardedBy(value="this")
    private Future<?> updateUsers;
    @GuardedBy(value="this")
    private Future<?> userFuture;
    private final ScheduledExecutorService exec;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);

    public static UserSingletonManager<UserManager> getSingletonManager() {
        return sMngr;
    }

    public static UserManager setInstance(SQLTable t) {
        return UserManager.getSingletonManager().setInstance(t);
    }

    public static final UserManager getInstance() {
        return UserManager.getSingletonManager().getInstance();
    }

    public static final User getUser() {
        UserManager mngr = UserManager.getInstance();
        return UserManager.getCurrentUser(mngr);
    }

    public static User getCurrentUser(UserManager mngr) {
        return mngr == null ? null : mngr.getCurrentUser();
    }

    public static final int getUserID() {
        User user = UserManager.getUser();
        return user == null ? -1 : user.getId();
    }

    public UserManager(SQLTable t) {
        this.t = t;
        this.exec = Executors.newScheduledThreadPool(1, new ThreadFactory(String.valueOf(UserManager.class.getSimpleName()) + " executor for " + t.getSQLName(), true).setPriority(1));
        this.tableL = new SQLTableModifiedListener(){

            @Override
            public void tableModified(SQLTableEvent evt) {
                UserManager.this.refresh(true);
            }
        };
    }

    public final UserManager start() {
        return this.start(480000L);
    }

    public final synchronized UserManager start(final long maxAge) {
        if (this.getState() != State.CREATED) {
            throw new IllegalStateException("Already started");
        }
        this.t.addTableModifiedListener(this.tableL);
        this.fillUsers();
        this.scheduledUpdateUsers = this.exec.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                UserManager.this.refreshIfNeeded(maxAge);
            }
        }, maxAge / 4L, maxAge / 4L, TimeUnit.MILLISECONDS);
        return this;
    }

    public final boolean isValid() {
        return this.getState() == State.VALID;
    }

    public final synchronized State getState() {
        if (this.scheduledUpdateUsers == null) {
            return State.CREATED;
        }
        if (this.scheduledUpdateUsers.isDone()) {
            return State.DESTROYED;
        }
        return State.VALID;
    }

    @Override
    public final synchronized void destroy() {
        State s = this.getState();
        if (s == State.DESTROYED) {
            return;
        }
        if (s == State.VALID) {
            this.getTable().removeTableModifiedListener(this.tableL);
            this.scheduledUpdateUsers.cancel(true);
            this.cancelUpdate();
        }
        this.exec.shutdown();
        assert (this.getState() == State.DESTROYED);
    }

    private void cancelUpdate() {
        assert (Thread.holdsLock(this));
        if (this.updateUsers != null && (this.userFuture == null || this.userFuture.isDone())) {
            this.updateUsers.cancel(true);
        }
    }

    private boolean isUpdatePending() {
        assert (Thread.holdsLock(this));
        return this.updateUsers != null && !this.updateUsers.isDone();
    }

    private synchronized void refreshIfNeeded(long maxAge) {
        long dataAge = System.currentTimeMillis() - this.timeOfLastFill;
        if (dataAge > maxAge && !this.isUpdatePending()) {
            this.refresh(true);
        }
    }

    public void refresh() {
        if (!this.isValid()) {
            throw new IllegalStateException("No longer valid");
        }
        this.refresh(false);
    }

    private synchronized void refresh(final boolean thisClass) {
        this.cancelUpdate();
        this.updateUsers = this.invokeLater(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (thisClass) {
                    Thread.sleep(30L);
                }
                UserManager.this.fillUsers();
                return null;
            }
        }, false);
        this.userFuture = null;
    }

    public final <T> Future<T> invokeLater(Callable<T> c) {
        return this.invokeLater(c, true);
    }

    public final synchronized <T> Future<T> invokeLater(Callable<T> c, boolean needsPreviousUpdate) {
        if (!this.isValid()) {
            return null;
        }
        Future<T> res = this.exec.submit(c);
        if (needsPreviousUpdate) {
            this.userFuture = res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillUsers() {
        Map<Integer, User> old;
        LinkedHashMap<Integer, User> mutable = new LinkedHashMap<Integer, User>();
        SQLRowValuesListFetcher fetcher = new SQLRowValuesListFetcher(new SQLRowValues(this.t).setAllToNull());
        fetcher.setOrdered(true);
        for (SQLRowValues v : fetcher.fetch()) {
            User u = new User(v);
            mutable.put(v.getID(), u);
        }
        Map immutable = Collections.unmodifiableMap(mutable);
        UserManager userManager = this;
        synchronized (userManager) {
            old = this.byID;
            this.byID = immutable;
            this.timeOfLastFill = System.currentTimeMillis();
        }
        this.supp.firePropertyChange(USERS_PROPNAME, old, immutable);
    }

    @Override
    public final SQLTable getTable() {
        return this.t;
    }

    public final synchronized Map<Integer, User> getUsers() {
        if (this.byID == null) {
            throw new IllegalStateException(this + " wasn't started successfully");
        }
        return this.byID;
    }

    public final void addUsersListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(USERS_PROPNAME, l);
    }

    public final void removeUsersListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(USERS_PROPNAME, l);
    }

    public final synchronized User getCurrentUser() {
        return this.currentUserID == null ? null : this.getUser(this.currentUserID);
    }

    public final synchronized Integer getCurrentUserID() {
        return this.currentUserID;
    }

    @Deprecated
    public void setCurrentUser(Number id) {
        this.setCurrentUserID(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUserID(Number id) {
        boolean modified;
        Integer newVal = id == null || id instanceof Integer ? (Integer)id : Integer.valueOf(id.intValue());
        UserManager userManager = this;
        synchronized (userManager) {
            boolean bl = modified = !CompareUtils.equals(this.currentUserID, newVal);
            if (modified) {
                this.currentUserID = newVal;
            }
        }
        if (modified) {
            this.supp.firePropertyChange(CURRENT_USERID_PROPNAME, null, newVal);
        }
    }

    public final void addCurrentUserIDListener(PropertyChangeListener l) {
        this.supp.addPropertyChangeListener(CURRENT_USERID_PROPNAME, l);
    }

    public final void removeCurrentUserIDListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(CURRENT_USERID_PROPNAME, l);
    }

    public List<User> getAllActiveUsers() {
        ArrayList<User> result = new ArrayList<User>();
        for (User user : this.getUsers().values()) {
            if (!user.isActive()) continue;
            result.add(user);
        }
        return result;
    }

    public User getUser(Integer v) {
        Map<Integer, User> users = this.getUsers();
        if (users.containsKey(v)) {
            return users.get(v);
        }
        throw new IllegalStateException("Bad user! " + v);
    }

    public static enum State {
        CREATED,
        VALID,
        DESTROYED;

    }
}

