/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.GestionDevise;

public class ReleveChequeSheet
extends AbstractListeSheetXml {
    private List<Map<String, Object>> listValues;
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
    private Date date;
    private long total = 0L;
    private long nb = 0L;
    private boolean apercu = false;
    private static final SQLTable tableCheque = base.getTable("CHEQUE_A_ENCAISSER");
    private List<Integer> listeIds;
    public static final String TEMPLATE_ID = "ReleveCheque";
    public static final String TEMPLATE_PROPERTY_NAME = "LocationReleveChequeCli";

    public ReleveChequeSheet(List<Integer> listeIds, Date date) {
        this(listeIds, date, false);
    }

    @Override
    protected String getStoragePathP() {
        return "Releve Cheque";
    }

    public ReleveChequeSheet(List<Integer> listeIds, Date date, boolean apercu) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.date = date;
        this.apercu = apercu;
        this.listeIds = listeIds;
    }

    @Override
    public String getName() {
        return TEMPLATE_ID + (this.date == null ? new Date().getTime() : this.date.getTime());
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected void createListeValues() {
        if (this.listeIds == null) {
            return;
        }
        this.listValues = new ArrayList<Map<String, Object>>(this.listeIds.size());
        for (Integer i : this.listeIds) {
            SQLRow rowTmp = tableCheque.getRow(i);
            SQLRow rowCliTmp = rowTmp.getForeignRow("ID_CLIENT");
            long long1 = rowTmp.getLong("MONTANT");
            HashMap<String, Object> mValues = new HashMap<String, Object>();
            if (rowTmp.getObject("DATE") != null) {
                mValues.put("DATE", this.dateFormat.format((Date)rowTmp.getObject("DATE")));
            }
            mValues.put("NB", this.nb + 1L);
            mValues.put("NUMERO", rowTmp.getObject("NUMERO"));
            mValues.put("BANQUE", rowTmp.getObject("ETS"));
            mValues.put("NOM_CLIENT", rowCliTmp.getObject("NOM"));
            SQLRow rowMvt = rowTmp.getForeignRow("ID_MOUVEMENT");
            SQLRow rowPiece = rowMvt.getForeignRow("ID_PIECE");
            String nom = rowPiece.getString("NOM");
            if (nom.startsWith("Saisie vente facture ")) {
                nom = nom.replaceAll("Saisie vente facture ", "");
            }
            mValues.put("SOURCE", nom);
            mValues.put("MONTANT", Double.valueOf(GestionDevise.currencyToString(long1, false)));
            ++this.nb;
            this.total += long1;
            this.listValues.add(mValues);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.apercu) {
            values.put("DATE_DEPOT", String.valueOf(this.dateFormat.format(this.date)) + "(APERCU)");
        } else {
            values.put("DATE_DEPOT", this.dateFormat.format(this.date));
        }
        values.put("TOTAL", Double.valueOf(GestionDevise.currencyToString(this.total, false)));
        values.put("NB_TOTAL", this.nb);
        this.listAllSheetValues.put(0, this.listValues);
        this.mapAllSheetValues.put(0, values);
    }
}

