/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTablePanel;
import org.openconcerto.sql.view.list.SQLTableElement;

public class EtatStockTable
extends RowValuesTablePanel {
    public EtatStockTable(final JTextField fieldTotal) {
        this.init();
        this.uiInit();
        this.table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                BigDecimal total = BigDecimal.ZERO;
                int i = 0;
                while (i < EtatStockTable.this.table.getRowValuesTableModel().getRowCount()) {
                    total = total.add(EtatStockTable.this.table.getRowValuesTableModel().getRowValuesAt(i).getBigDecimal("T_PA"));
                    ++i;
                }
                fieldTotal.setText(total.toString());
            }
        });
    }

    @Override
    protected void init() {
        SQLElement e = this.getSQLElement();
        ArrayList<SQLTableElement> list = new ArrayList<SQLTableElement>();
        list.add(new SQLTableElement(e.getTable().getField("ID_ARTICLE")));
        list.add(new SQLTableElement(e.getTable().getField("CODE")));
        list.add(new SQLTableElement(e.getTable().getField("NOM")));
        SQLTableElement achat = new SQLTableElement(e.getTable().getField("PA")){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        achat.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(achat);
        SQLTableElement qte = new SQLTableElement(e.getTable().getField("QTE")){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ZERO;
            }
        };
        list.add(qte);
        SQLTableElement totalHA = new SQLTableElement(e.getTable().getField("T_PA"));
        totalHA.setRenderer(new CurrencyWithSymbolRenderer());
        list.add(totalHA);
        this.defaultRowVals = new SQLRowValues(this.getSQLElement().getTable());
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("ID_ARTICLE"), false, this.defaultRowVals);
        this.table = new RowValuesTable(this.model, null);
        qte.addModificationListener(totalHA);
        achat.addModificationListener(totalHA);
        totalHA.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                return row.getBigDecimal("QTE").multiply(row.getBigDecimal("PA"));
            }
        });
    }

    @Override
    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("ETAT_STOCK_ELEMENT");
    }
}

