/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.math.BigDecimal;
import java.math.RoundingMode;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.ui.touch.ScrollableList;
import org.openconcerto.utils.QuickOrderedMap;
import org.openconcerto.utils.Tuple2;

public class TicketCellRenderer
implements ListCellRenderer<TicketItem> {
    @Override
    public Component getListCellRendererComponent(JList<? extends TicketItem> list, TicketItem item, int index, boolean isSelected, boolean cellHasFocus) {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 5, 5);
        JLabel l1 = new JLabel(item.getArticle().toString(), 4);
        p.add((Component)l1, c);
        ++c.gridx;
        c.weightx = 1.0;
        Article article = item.getArticle();
        JLabel l2 = new JLabel(article.getName().toUpperCase(), 2);
        p.add((Component)l2, c);
        ++c.gridx;
        c.weightx = 0.0;
        BigDecimal priceWithTax = article.getPriceWithTax(item.getQty());
        JLabel l3 = new JLabel(TicketCellRenderer.toString(priceWithTax), 4);
        p.add((Component)l3, c);
        l1.setOpaque(false);
        l2.setOpaque(false);
        l3.setOpaque(false);
        if (isSelected) {
            p.setOpaque(true);
            p.setBackground(new Color(232, 242, 254));
        } else {
            p.setOpaque(false);
        }
        l1.setFont(new Font("Arial", 0, 18));
        l2.setFont(new Font("Arial", 0, 18));
        l3.setFont(new Font("Arial", 0, 18));
        return p;
    }

    public void paint(Graphics g, ScrollableList list, TicketItem item, int index, boolean isSelected) {
        if (isSelected) {
            g.setColor(new Color(232, 242, 254));
            g.fillRect(0, 0, list.getWidth(), list.getCellHeight());
        }
        g.setColor(Color.BLACK);
        int inset = 5;
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setFont(new Font("Arial", 0, 16));
        int height = g.getFontMetrics().getMaxAscent() + g.getFontMetrics().getMaxDescent() + 5;
        System.err.println("TicketCellRenderer.paint()" + item);
        Article article = item.getArticle();
        BigDecimal qty = item.getQty();
        String s1 = qty.toString();
        if (article.getSalesUnit() != null) {
            s1 = String.valueOf(qty.toString()) + article.getSalesUnit();
        }
        g.drawString(s1, 5, height);
        int width1 = (int)g.getFontMetrics().getStringBounds("1999kg ", g).getWidth() + 10;
        String s2 = article.getName().toUpperCase().trim();
        int maxLength = 15;
        if (s2.length() > 15) {
            s2 = String.valueOf(s2.substring(0, 16)) + '\u2026';
        }
        QuickOrderedMap<String, Tuple2<String, BigDecimal>> decls = article.getDeclinaisons();
        String textDeclinaisons = null;
        if (decls != null && !decls.isEmpty()) {
            StringBuilder declinaisons = new StringBuilder();
            int i = 0;
            while (i < decls.size()) {
                declinaisons.append(decls.getValue(i).get0());
                declinaisons.append("  ");
                ++i;
            }
            textDeclinaisons = declinaisons.toString().trim();
        }
        g.drawString(s2, width1 + 5, height - 6);
        String s3 = String.valueOf(TicketCellRenderer.centsToString(article.getPriceWithTax(qty, true).multiply(qty).movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue())) + "\u20ac";
        int width3 = (int)g.getFontMetrics().getStringBounds(s3, g).getWidth() + 5;
        g.drawString(s3, list.getWidth() - width3, height - 4);
        g.setFont(g.getFont().deriveFont(12.0f));
        String s4 = String.valueOf(qty.toPlainString()) + " x " + TicketCellRenderer.centsToString(article.getPriceWithTax(qty).movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
        int width4 = (int)g.getFontMetrics().getStringBounds(s4, g).getWidth() + 5;
        g.drawString(s4, list.getWidth() - width4, height + 11);
        if (textDeclinaisons != null) {
            g.drawString(textDeclinaisons, width1 + 5, height + 11);
        }
        if (!article.getDiscountPct().equals(BigDecimal.ZERO)) {
            g.setFont(g.getFont().deriveFont(2));
            g.drawString("Remise: " + article.getDiscountPct().movePointRight(2).setScale(2, 4) + " %", 150, height + 12);
        }
    }

    public static String centsToString(int cents) {
        int c = Math.abs(cents) % 100;
        String sc = String.valueOf(c);
        if (c < 10) {
            sc = "0" + sc;
        }
        return String.valueOf(cents / 100) + "." + sc;
    }

    public static String toString(BigDecimal p) {
        return TicketCellRenderer.centsToString(p.movePointRight(2).setScale(0, RoundingMode.HALF_UP).intValue());
    }
}

