/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import org.openconcerto.erp.model.PrixTTC;
import org.openconcerto.utils.GestionDevise;

public class DeviseCellEditor
extends AbstractCellEditor
implements TableCellEditor,
MouseListener {
    protected final JTextField textField = new JTextField();
    private float taxe = -1.0f;
    private final List<KeyListener> keyL = new ArrayList<KeyListener>();

    public DeviseCellEditor() {
        this.textField.setBorder(new LineBorder(Color.black));
        this.textField.setHorizontalAlignment(4);
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                for (KeyListener keyListener : DeviseCellEditor.this.keyL) {
                    keyListener.keyPressed(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                for (KeyListener keyListener : DeviseCellEditor.this.keyL) {
                    keyListener.keyReleased(e);
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void keyTyped(KeyEvent keyEvent) {
                char keychar = keyEvent.getKeyChar();
                for (KeyListener keyListener : DeviseCellEditor.this.keyL) {
                    keyListener.keyTyped(keyEvent);
                }
                if (keychar == '\b') {
                    return;
                }
                int pointPosition = DeviseCellEditor.this.textField.getText().indexOf(46);
                if (Character.isDigit(keychar)) {
                    if (pointPosition <= -1) return;
                    if (DeviseCellEditor.this.textField.getSelectedText() != null) return;
                    if (DeviseCellEditor.this.textField.getCaretPosition() <= pointPosition) {
                        return;
                    }
                    if (DeviseCellEditor.this.textField.getText().substring(pointPosition).length() <= 2) {
                        return;
                    }
                }
                if (keychar == '.' && DeviseCellEditor.this.textField.getText().indexOf(46) < 0) {
                    return;
                }
                if (keychar == '-' && DeviseCellEditor.this.textField.getText().indexOf(45) < 0 && DeviseCellEditor.this.textField.getCaretPosition() == 0) {
                    return;
                }
                keyEvent.consume();
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                DeviseCellEditor.this.textField.selectAll();
            }
        });
    }

    public void addKeyListener(KeyListener l) {
        this.keyL.add(l);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return super.isCellEditable(e);
    }

    @Override
    public Object getCellEditorValue() {
        long l;
        try {
            l = GestionDevise.parseLongCurrency(this.textField.getText());
        }
        catch (Exception e) {
            l = 0L;
            System.err.println("DeviseCellEditor.getCellEditorValue() cannot parse " + this.textField.getText());
        }
        return l;
    }

    public void setConvertToTTCEnable(boolean b) {
        if (b) {
            this.textField.addMouseListener(this);
        } else {
            this.textField.removeMouseListener(this);
        }
    }

    public void setTaxe(float d) {
        this.taxe = d;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.textField.setText(GestionDevise.currencyToString(value == null ? 0L : (Long)value));
        this.textField.selectAll();
        this.textField.grabFocus();
        return this.textField;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.taxe > 0.0f && this.textField.getText().trim().length() > 0 && e.getButton() == 3) {
            JPopupMenu menuDroit = new JPopupMenu();
            menuDroit.add(new AbstractAction("Convertir en HT (TVA " + this.taxe + ")"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long l;
                    String s = DeviseCellEditor.this.textField.getText();
                    try {
                        l = GestionDevise.parseLongCurrency(s);
                    }
                    catch (Exception ex) {
                        l = 0L;
                        System.err.println("DeviseCellEditor.mousePressed() cannot parse " + s);
                    }
                    PrixTTC p = new PrixTTC(l);
                    DeviseCellEditor.this.textField.setText(GestionDevise.currencyToString(p.calculLongHT((double)DeviseCellEditor.this.taxe / 100.0)));
                }
            });
            menuDroit.pack();
            menuDroit.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
            menuDroit.setVisible(true);
        }
    }
}

