/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import org.openconcerto.utils.cc.TruncatableList;
import org.openconcerto.utils.model.IListModel;

public class DefaultIListModel<T>
extends AbstractListModel<T>
implements IListModel<T> {
    protected final List<T> objects;
    protected boolean truncated;

    public DefaultIListModel() {
        this(Collections.emptyList());
    }

    public DefaultIListModel(T[] v) {
        this(Arrays.asList(v));
    }

    public DefaultIListModel(Collection<? extends T> v) {
        this(v, false);
    }

    public DefaultIListModel(Collection<? extends T> v, boolean truncated) {
        this.objects = new ArrayList<T>(v);
        this.truncated = truncated;
    }

    @Override
    public int getSize() {
        return this.objects.size();
    }

    @Override
    public T getElementAt(int index) {
        if (index >= 0 && index < this.objects.size()) {
            return this.objects.get(index);
        }
        return null;
    }

    @Override
    public List<T> getList() {
        return Collections.unmodifiableList(this.objects);
    }

    public final boolean isTruncated() {
        return this.truncated;
    }

    public final TruncatableList<T> copyTruncatableList() {
        return new TruncatableList<T>(new ArrayList<T>(this.objects), this.isTruncated());
    }
}

