/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.concurrent;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class ThreadUtils {
    public static final Map<Thread, StackTraceElement[]> getNonDeamonThreads() {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Iterator<Thread> iter = allStackTraces.keySet().iterator();
        while (iter.hasNext()) {
            Thread thr = iter.next();
            if (!thr.isDaemon() && thr.isAlive()) continue;
            iter.remove();
        }
        return allStackTraces;
    }

    public static final void dumpThreads(Map<Thread, StackTraceElement[]> allStackTraces, Consumer<Object> println) {
        for (Map.Entry<Thread, StackTraceElement[]> e : allStackTraces.entrySet()) {
            Thread thr = e.getKey();
            if (thr.isAlive()) {
                StackTraceElement[] trace;
                println.accept(thr);
                StackTraceElement[] stackTraceElementArray = trace = e.getValue();
                int n = trace.length;
                int n2 = 0;
                while (n2 < n) {
                    StackTraceElement traceElement = stackTraceElementArray[n2];
                    println.accept("\tat " + traceElement);
                    ++n2;
                }
                continue;
            }
            println.accept("DEAD " + thr);
        }
    }

    public static final boolean onlyCurrentThread(Set<Thread> set) {
        return set.equals(Collections.singleton(Thread.currentThread()));
    }

    private ThreadUtils() {
    }
}

