/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RunnableFuture;

public final class CompletableRunnableFuture<T>
extends CompletableFuture<T>
implements RunnableFuture<T> {
    private final FutureTask<T> task;

    public static CompletableRunnableFuture<Void> create(Runnable command) {
        return CompletableRunnableFuture.create(Executors.callable(command, null));
    }

    public static <T> CompletableRunnableFuture<T> create(Callable<T> command) {
        return new CompletableRunnableFuture<T>(command);
    }

    private CompletableRunnableFuture(Callable<T> command) {
        this.task = new FutureTask<T>(command){

            @Override
            protected void set(T v) {
                CompletableRunnableFuture.super.complete(v);
                super.set(v);
            }

            @Override
            protected void setException(Throwable t) {
                CompletableRunnableFuture.super.completeExceptionally(t);
                super.setException(t);
            }

            @Override
            protected void done() {
                super.done();
                if (!$assertionsDisabled && !CompletableRunnableFuture.this.isDone()) {
                    throw new AssertionError();
                }
            }
        };
    }

    @Override
    public void run() {
        this.task.run();
    }

    public final CompletableRunnableFuture<T> runAsync(Executor exec) {
        exec.execute(this);
        return this;
    }

    @Override
    public boolean complete(T value) {
        boolean res = super.complete(value);
        if (res) {
            this.task.cancel(true);
        }
        return res;
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean res = super.completeExceptionally(ex);
        if (res) {
            this.task.cancel(true);
        }
        return res;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean res = super.cancel(mayInterruptIfRunning);
        if (res) {
            this.task.cancel(mayInterruptIfRunning);
        }
        return res;
    }
}

