/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.concurrent;

public abstract class ChainedThread
extends Thread {
    private final Thread previous;

    public ChainedThread(ThreadGroup group, Thread previous) {
        this(group, "Unnamed Thread " + System.currentTimeMillis(), previous);
    }

    public ChainedThread(ThreadGroup group, String name, Thread previous) {
        super(group, name);
        this.previous = previous;
    }

    private void append() {
        try {
            if (this.previous != null) {
                this.previous.join();
            }
            this.contribute();
        }
        catch (InterruptedException exn) {
            throw new RuntimeException("Probl\u00e8me lors de l'attente de la thread pr\u00e9c\u00e9dente.", exn);
        }
    }

    @Override
    public void run() {
        this.work();
        this.append();
    }

    protected abstract void work();

    protected abstract void contribute();
}

