/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class JCheckBoxTableCellRender
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer,
ItemListener {
    private JCheckBox checkBox;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JPanel p = new JPanel();
        p.setOpaque(true);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        this.checkBox = new JCheckBox();
        boolean bValue = (Boolean)value;
        this.checkBox.setSelected(bValue);
        this.checkBox.addItemListener(this);
        p.setBackground(table.getSelectionBackground());
        this.checkBox.setBorder(null);
        this.checkBox.setBorderPaintedFlat(false);
        this.checkBox.setMargin(new Insets(0, 0, 0, 0));
        p.add((Component)this.checkBox, c);
        return p;
    }

    @Override
    public Object getCellEditorValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JPanel p = new JPanel();
        p.setOpaque(true);
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JCheckBox cb = new JCheckBox();
        cb.setBorder(null);
        cb.setBorderPaintedFlat(false);
        cb.setMargin(new Insets(0, 0, 0, 0));
        if (value == null) {
            cb.setSelected(false);
        } else {
            cb.setSelected((Boolean)value);
        }
        c.fill = 0;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        p.add((Component)cb, c);
        TableCellRendererUtils.setColors(p, table, isSelected);
        return p;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            this.fireEditingStopped();
        }
    }
}

