/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.LightUserControl;

public class LightUIRadioButtons
extends LightUserControl {
    private final List<String> choices = new ArrayList<String>();

    public LightUIRadioButtons() {
    }

    public LightUIRadioButtons(JSONObject json) {
        super(json);
    }

    public LightUIRadioButtons(LightUIRadioButtons labelElement) {
        super(labelElement);
    }

    public LightUIRadioButtons(String id, String label, List<String> choices) {
        this(id, label, choices, -1);
    }

    public LightUIRadioButtons(String id, String label, List<String> choices, int selectedIndex) {
        super(id);
        this.setType(34);
        this.setLabel(label);
        if (selectedIndex >= choices.size()) {
            throw new IllegalArgumentException("invalid index " + selectedIndex + ", it must be between 0 and " + choices.size());
        }
        if (selectedIndex < 0) {
            this.setValue(null);
        } else {
            this.setValue(String.valueOf(selectedIndex));
        }
        this.setChoices(choices);
    }

    public void setChoices(List<String> choices) {
        this.choices.clear();
        this.choices.addAll(choices);
    }

    public List<String> getChoices() {
        return this.choices;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        JSONArray array = new JSONArray();
        for (String choice : this.choices) {
            array.add(choice);
        }
        json.put("choices", array);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        JSONArray array = (JSONArray)json.get("choices");
        this.choices.clear();
        for (Object o : array) {
            this.choices.add(o.toString());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.choices.size());
        for (String c : this.choices) {
            out.writeUTF(c);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int size = in.readInt();
        this.choices.clear();
        int i = 0;
        while (i < size) {
            this.choices.add(in.readUTF());
            ++i;
        }
    }

    @Override
    public void _setValueFromContext(Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Incorrect value " + value + "type for ui element: " + this.getId());
        }
        this.setValue(value.toString());
    }

    @Override
    public Object getValueForContext() {
        if (this.getValue() == null) {
            return null;
        }
        return Integer.parseInt(this.getValue());
    }
}

