/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.openconcerto.ui.TM;
import org.openconcerto.ui.preferences.EmailProps;
import org.openconcerto.utils.EmailClient;

public class EmailComposer {
    private static EmailComposer instance = new EmailComposer();

    public static synchronized EmailComposer getInstance() {
        return instance;
    }

    public void compose(String to, String subject, String text, File ... attachedFile) throws IOException, InterruptedException {
        String footer;
        if (to == null) {
            to = "";
        }
        if (subject == null) {
            subject = "";
        }
        if (text == null) {
            text = "";
        }
        to = to.trim().replaceAll(";", ",");
        subject = subject.trim();
        String title = EmailProps.getInstance().getTitle();
        if (title != null && title.trim().length() > 0) {
            subject = String.valueOf(title) + " " + subject;
        }
        text = text.trim();
        String header = EmailProps.getInstance().getHeader();
        if (header != null && header.trim().length() > 0) {
            text = String.valueOf(header) + "\n" + text;
        }
        if ((footer = EmailProps.getInstance().getFooter()) != null && footer.trim().length() > 0) {
            text = String.valueOf(text) + "\n" + footer;
        }
        EmailClient emailClient = null;
        int mode = EmailProps.getInstance().getMode();
        if (mode == 1) {
            String app = EmailProps.getInstance().getThunderbirdPath();
            emailClient = EmailClient.Thunderbird.createFromExe(new File(app));
        } else if (mode == 2) {
            emailClient = EmailClient.Outlook;
        }
        if (emailClient == null) {
            emailClient = EmailClient.getPreferred();
        }
        try {
            emailClient.compose(to, subject, text, attachedFile);
        }
        catch (Exception e) {
            if (emailClient == EmailClient.MailTo) {
                throw new IOException(e);
            }
            JOptionPane.showMessageDialog(null, TM.tr("email.fallback", new Object[0]));
            e.printStackTrace();
            EmailClient.MailTo.compose(to, subject, text, attachedFile);
        }
    }
}

