/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.light;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minidev.json.JSONObject;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ListSQLRequest;
import org.openconcerto.sql.ui.light.LightRowValuesTable;
import org.openconcerto.sql.ui.light.TableSearchMatcher;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.light.TableSearchParameterType;
import org.openconcerto.ui.light.UserSearch;
import org.openconcerto.ui.light.UserSearchItem;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.cc.ITransformer;

public class LightRowValuesTableOnline
extends LightRowValuesTable {
    private ITransformer<SQLSelect, SQLSelect> orginTransformer;

    public LightRowValuesTableOnline() {
    }

    public LightRowValuesTableOnline(Configuration configuration, Number userId, String id, ITableModel model) {
        super(configuration, userId, id, model);
        this.orginTransformer = ((SQLTableModelSourceOnline)model.getReq()).getReq().getSelectTransf();
    }

    public LightRowValuesTableOnline(LightRowValuesTableOnline tableElement) {
        super(tableElement);
        this.orginTransformer = tableElement.orginTransformer;
    }

    public LightRowValuesTableOnline(JSONObject json) {
        super(json);
        this.orginTransformer = null;
    }

    @Override
    public void doSearch(Configuration configuration, final UserSearch searchSpec, int offset) {
        this.getTableSpec().setSearch(searchSpec);
        this.setOffset(offset);
        SQLTableModelSource tableSource = this.getModel().getReq();
        ListSQLRequest req = tableSource.getReq();
        final ArrayList<UserSearchItem> content = new ArrayList<UserSearchItem>();
        if (searchSpec != null) {
            content.addAll(searchSpec.getContent());
            for (UserSearchItem item : content) {
                String searchType;
                String colId = item.getColumn();
                TableSearchMatcher m = this.getSearchMatcher(colId, searchType = item.getType());
                if (m == null || m.getAdditionnalFieldsToFetch() == null) continue;
                for (FieldPath p : m.getAdditionnalFieldsToFetch()) {
                    req.addToGraphToFetch(p.getPath(), Arrays.asList(p.getField().getFieldName()));
                }
            }
        }
        req.setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect sel) {
                if (LightRowValuesTableOnline.this.orginTransformer != null) {
                    LightRowValuesTableOnline.this.orginTransformer.transformChecked(sel);
                }
                if (searchSpec != null) {
                    ArrayList<Where> wheres = new ArrayList<Where>();
                    for (UserSearchItem item : content) {
                        String colId = item.getColumn();
                        String userText = item.getText();
                        String searchType = item.getType();
                        TableSearchMatcher m = LightRowValuesTableOnline.this.getSearchMatcher(colId, searchType);
                        if (m != null) {
                            if (searchType.equals("contains")) {
                                List<String> textParts = StringUtils.fastSplitTrimmed(userText, ' ');
                                for (String p : textParts) {
                                    Where where = m.getWhere(sel, new TableSearchParameterType(searchType), p);
                                    if (where == null) continue;
                                    wheres.add(where);
                                }
                                continue;
                            }
                            Where where = m.getWhere(sel, new TableSearchParameterType(searchType), userText);
                            if (where == null) continue;
                            wheres.add(where);
                            continue;
                        }
                        Log.get().warning("no TableSearchMatcher for " + item);
                    }
                    if (!wheres.isEmpty()) {
                        Where w = sel.getWhere() != null ? Where.and(sel.getWhere(), Where.and(wheres)) : Where.and(wheres);
                        sel.setWhere(w);
                    }
                }
                return sel;
            }
        });
    }
}

