/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationEcritures;

import com.ibm.icu.text.SimpleDateFormat;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.BanqueSQLElement;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.common.ui.TotalCalculator;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.generationDoc.OOXMLCache;
import org.openconcerto.erp.generationEcritures.AnalytiqueCache;
import org.openconcerto.erp.generationEcritures.provider.AnalytiqueProvider;
import org.openconcerto.erp.generationEcritures.provider.AnalytiqueProviderManager;
import org.openconcerto.erp.preferences.DefaultNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBackgroundTableCache;
import org.openconcerto.sql.model.SQLBackgroundTableCacheItem;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesCluster;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.utils.ExceptionHandler;

public class GenerationEcritures {
    protected static final SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    protected static final SQLTable compteTable = base.getTable("COMPTE_PCE");
    protected static final SQLTable journalTable = base.getTable("JOURNAL");
    protected static final SQLTable ecritureTable = base.getTable("ECRITURE");
    protected static final SQLTable pieceTable = base.getTable("PIECE");
    protected static final SQLTable mouvementTable = base.getTable("MOUVEMENT");
    protected int idMvt;
    protected int idPiece;
    protected Date date;
    protected String nom;
    private SQLRow rowAnalytiqueSource;
    protected final Map<String, Object> mEcritures = new HashMap<String, Object>();
    private Date dDebEx = null;
    private Date dCloture = null;
    private static SQLTable tableAssoc = null;
    private static SQLTable tablePoste = Configuration.getInstance().getDirectory().getElement("POSTE_ANALYTIQUE").getTable();

    public void putValue(String field, Object value) {
        this.mEcritures.put(field, value);
    }

    public void setRowAnalytiqueSource(SQLRow rowAnalytiqueSource) {
        this.rowAnalytiqueSource = rowAnalytiqueSource;
    }

    public SQLRow getRowAnalytiqueSource() {
        return this.rowAnalytiqueSource;
    }

    public synchronized SQLRow ajoutEcriture() throws IllegalArgumentException {
        String error;
        Number n2;
        long debit = (Long)this.mEcritures.get("DEBIT");
        long credit = (Long)this.mEcritures.get("CREDIT");
        Number n = (Number)this.mEcritures.get("ID_JOURNAL");
        if (n != null) {
            SQLBackgroundTableCacheItem cacheForTableJrnl = SQLBackgroundTableCache.getInstance().getCacheForTable(journalTable);
            SQLRow rowJrnl = cacheForTableJrnl.getRowFromId(n.intValue());
            if (rowJrnl == null) {
                throw new IllegalArgumentException("Le journal qui a pour ID " + n + " a \u00e9t\u00e9 archiv\u00e9.");
            }
            this.mEcritures.put("JOURNAL_NOM", rowJrnl.getString("NOM"));
            this.mEcritures.put("JOURNAL_CODE", rowJrnl.getString("CODE"));
        }
        if ((n2 = (Number)this.mEcritures.get("ID_COMPTE_PCE")) != null) {
            SQLBackgroundTableCacheItem cacheForTableCpt = SQLBackgroundTableCache.getInstance().getCacheForTable(compteTable);
            SQLRow rowCpt = cacheForTableCpt.getRowFromId(n2.intValue());
            if (rowCpt == null) {
                rowCpt = compteTable.getRow(n2.intValue());
            }
            this.mEcritures.put("COMPTE_NUMERO", rowCpt.getString("NUMERO"));
            this.mEcritures.put("COMPTE_NOM", rowCpt.getString("NOM"));
        }
        if (debit != 0L && credit != 0L) {
            throw new IllegalArgumentException("Le d\u00e9bit et le cr\u00e9dit ne peuvent pas \u00eatre tous les 2 diff\u00e9rents de 0. Debit : " + debit + " Credit : " + credit);
        }
        if (debit < 0L) {
            credit = -debit;
            debit = 0L;
        }
        if (credit < 0L) {
            debit = -credit;
            credit = 0L;
        }
        this.mEcritures.put("DEBIT", debit);
        this.mEcritures.put("CREDIT", credit);
        Date d = (Date)this.mEcritures.get("DATE");
        if (this.dDebEx == null) {
            SQLTable tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
            SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
            SQLRow rowExercice = tableExercice.getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
            this.dDebEx = (Date)rowExercice.getObject("DATE_DEB");
            this.dCloture = (Date)rowExercice.getObject("DATE_CLOTURE");
        }
        if (this.dCloture != null) {
            if (this.dCloture.after(d)) {
                error = "Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + SimpleDateFormat.getDateInstance(0).format(d) + ". Cette date est ant\u00e9rieure \u00e0 la date de cl\u00f4ture (" + SimpleDateFormat.getDateInstance(0).format(this.dCloture) + ")";
                throw new IllegalArgumentException(error);
            }
        } else if (this.dDebEx.after(d)) {
            error = "Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + SimpleDateFormat.getDateInstance(0).format(d) + ". Cette date est ant\u00e9rieure \u00e0 la date de d\u00e9but d'exercice (" + SimpleDateFormat.getDateInstance(0).format(this.dDebEx) + ")";
            throw new IllegalArgumentException(error);
        }
        SQLRowValues valEcriture = new SQLRowValues(ecritureTable, this.mEcritures);
        valEcriture.put("IDUSER_CREATE", UserManager.getInstance().getCurrentUser().getId());
        try {
            SQLRow ecritureRow = valEcriture.getGraph().store(SQLRowValuesCluster.StoreMode.INSERT, false).getStoredRow(valEcriture);
            this.addAssocAnalytiqueFromProvider(ecritureRow, this.rowAnalytiqueSource);
            return ecritureRow;
        }
        catch (SQLException e) {
            System.err.println("Error insert row in " + ecritureTable.getName() + " : " + e);
            final SQLException eFinal = e;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExceptionHandler.handle("Erreur lors de la g\u00e9n\u00e9ration des \u00e9critures.", eFinal);
                }
            });
            e.printStackTrace();
            return null;
        }
    }

    public void addAssocAnalytique(SQLRow rowEcr, int idPoste) throws SQLException {
        if (tablePoste.getUndefinedID() == idPoste) {
            return;
        }
        if (tableAssoc == null) {
            tableAssoc = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE").getTable();
        }
        SQLRowValues rowVals = new SQLRowValues(tableAssoc);
        rowVals.put("ID_POSTE_ANALYTIQUE", idPoste);
        rowVals.put("POURCENT", 100.0);
        rowVals.put("ID_ECRITURE", rowEcr.getID());
        rowVals.put("MONTANT", rowEcr.getLong("DEBIT") - rowEcr.getLong("CREDIT"));
        rowVals.commit();
    }

    public void addAssocAnalytiqueFromProvider(SQLRow rowEcr, SQLRow rowSource) throws SQLException {
        String numeroCpt = rowEcr.getString("COMPTE_NUMERO");
        if (rowSource != null && !rowSource.getTable().getName().equalsIgnoreCase("SAISIE_KM") && (numeroCpt.startsWith("6") || numeroCpt.startsWith("7"))) {
            for (SQLRow axe : AnalytiqueCache.getCache().getAxes()) {
                SQLRow poste;
                int assoc = 0;
                Collection<AnalytiqueProvider> l = AnalytiqueProviderManager.getAll();
                for (AnalytiqueProvider analytiqueProvider : l) {
                    List<SQLRow> result = analytiqueProvider.addAssociation(axe, rowEcr, rowSource);
                    if (result == null) continue;
                    assoc += result.size();
                }
                if (assoc != 0 || (poste = AnalytiqueCache.getCache().getDefaultPoste(axe.getID())) == null) continue;
                if (tableAssoc == null) {
                    tableAssoc = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE").getTable();
                }
                SQLRowValues rowVals = new SQLRowValues(tableAssoc);
                rowVals.put("ID_POSTE_ANALYTIQUE", poste.getID());
                rowVals.put("POURCENT", 100.0);
                rowVals.put("ID_ECRITURE", rowEcr.getID());
                rowVals.put("MONTANT", rowEcr.getLong("DEBIT") - rowEcr.getLong("CREDIT"));
                rowVals.put("GESTION_AUTO", Boolean.TRUE);
                rowVals.commit();
            }
        }
    }

    public void genereEcritures(List<SQLRowValues> l) {
        block6: {
            if (l == null) {
                return;
            }
            try {
                for (SQLRowValues rowVals : l) {
                    this.checkDateValide(rowVals);
                    this.checkDebitCreditValide(rowVals);
                }
                if (this.isSoldeNul(l)) {
                    for (SQLRowValues rowVals : l) {
                        rowVals.put("IDUSER_CREATE", UserManager.getInstance().getCurrentUser().getId());
                        rowVals.insert();
                    }
                    break block6;
                }
                throw new IllegalArgumentException("La partie double n'est pas respect\u00e9e. Impossible de g\u00e9n\u00e9rer les \u00e9critures comptables.");
            }
            catch (Exception e) {
                e.printStackTrace();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExceptionHandler.handle("", e);
                    }
                });
            }
        }
    }

    private void checkDateValide(SQLRowValues rowVals) throws Exception {
        Date d = (Date)rowVals.getObject("DATE");
        SQLTable tableExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
        SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
        SQLRow rowExercice = tableExercice.getRow(rowSociete.getInt("ID_EXERCICE_COMMON"));
        Date dDebEx = (Date)rowExercice.getObject("DATE_DEB");
        Date dCloture = (Date)rowExercice.getObject("DATE_CLOTURE");
        if (dCloture != null) {
            if (dCloture.after(d)) {
                System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
                throw new Exception("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            }
        } else if (dDebEx.after(d)) {
            System.err.println("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
            throw new Exception("Impossible de g\u00e9n\u00e9rer l'\u00e9criture pour la date " + d + ". Cette p\u00e9riode est clotur\u00e9e.");
        }
    }

    private void checkDebitCreditValide(SQLRowValues rowVals) throws Exception {
        long debit = rowVals.getLong("DEBIT");
        long credit = rowVals.getLong("CREDIT");
        if (debit != 0L && credit != 0L) {
            throw new Exception("Le d\u00e9bit et le cr\u00e9dit ne peuvent pas \u00eatre tous les 2 diff\u00e9rents de 0. Debit : " + debit + " Credit : " + credit);
        }
        if (debit < 0L) {
            credit = -debit;
            debit = 0L;
        }
        if (credit < 0L) {
            debit = -credit;
            credit = 0L;
        }
        rowVals.put("DEBIT", debit);
        rowVals.put("CREDIT", credit);
    }

    private boolean isSoldeNul(List<SQLRowValues> l) {
        long debit = 0L;
        long credit = 0L;
        for (SQLRowValues rowVals : l) {
            debit += rowVals.getLong("DEBIT");
            credit += rowVals.getLong("CREDIT");
        }
        return debit - credit == 0L;
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, SQLRowValues rowValsPiece) throws SQLException {
        SQLRow rowPiece = rowValsPiece.insert();
        return this.getNewMouvement(source, idSource, idPere, rowPiece.getID());
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, String nomPiece) throws SQLException {
        SQLRowValues rowValsPiece = new SQLRowValues(pieceTable);
        rowValsPiece.put("NOM", nomPiece);
        return this.getNewMouvement(source, idSource, idPere, rowValsPiece);
    }

    private int parseItemAndAddLeafLines(TotalCalculator calc, int start, List<? extends SQLRowAccessor> referentRows, Number compteSpec, int qtyMult, BigDecimal remiseCumul, boolean check) {
        int i = start;
        while (i < referentRows.size()) {
            SQLRowAccessor sqlRow = referentRows.get(i);
            if (sqlRow.getInt("NIVEAU") > 0) {
                if (i < referentRows.size() - 1) {
                    SQLRowValues asRowValues;
                    SQLRowAccessor sqlRowNextN2 = referentRows.get(i + 1);
                    int j = i + 2;
                    while (sqlRowNextN2.getInt("NIVEAU") <= 0 && j < referentRows.size() - 1) {
                        sqlRowNextN2 = referentRows.get(j);
                        ++j;
                    }
                    if (sqlRowNextN2.getInt("NIVEAU") <= 0) {
                        asRowValues = sqlRow.asRowValues(false);
                        asRowValues.put("QTE", asRowValues.getInt("QTE") * qtyMult);
                        asRowValues.put("POURCENT_REMISE", remiseCumul);
                        asRowValues.put("T_PV_HT", asRowValues.getBigDecimal("T_PV_HT").multiply(new BigDecimal(qtyMult)).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2))));
                        asRowValues.put("T_PV_TTC", asRowValues.getBigDecimal("T_PV_TTC").multiply(new BigDecimal(qtyMult).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2)))));
                        if (asRowValues.isForeignEmpty("ID_COMPTE_PCE") && compteSpec != null) {
                            asRowValues.put("ID_COMPTE_PCE", compteSpec);
                        }
                        calc.addLine(asRowValues, sqlRow.getForeign("ID_ARTICLE"), check ? 1 : i, i == referentRows.size() - 1, true);
                    } else if (sqlRowNextN2.getInt("NIVEAU") > sqlRow.getInt("NIVEAU")) {
                        int qty = qtyMult * sqlRow.getInt("QTE");
                        BigDecimal remise = sqlRow.getBigDecimal("POURCENT_REMISE") == null ? BigDecimal.ZERO : sqlRow.getBigDecimal("POURCENT_REMISE");
                        ++i;
                        i = this.parseItemAndAddLeafLines(calc, i, referentRows, sqlRow.isForeignEmpty("ID_COMPTE_PCE") ? (Number)compteSpec : (Number)sqlRow.getForeignIDNumber("ID_COMPTE_PCE"), qty, remise.add(remiseCumul), check);
                    } else {
                        if (sqlRowNextN2.getInt("NIVEAU") < sqlRow.getInt("NIVEAU")) {
                            asRowValues = sqlRow.asRowValues(false);
                            asRowValues.put("QTE", asRowValues.getInt("QTE") * qtyMult);
                            asRowValues.put("POURCENT_REMISE", remiseCumul);
                            asRowValues.put("T_PV_HT", asRowValues.getBigDecimal("T_PV_HT").multiply(new BigDecimal(qtyMult)).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2))));
                            asRowValues.put("T_PV_TTC", asRowValues.getBigDecimal("T_PV_TTC").multiply(new BigDecimal(qtyMult)).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2))));
                            if (asRowValues.isForeignEmpty("ID_COMPTE_PCE") && compteSpec != null) {
                                asRowValues.put("ID_COMPTE_PCE", compteSpec);
                            }
                            calc.addLine(asRowValues, sqlRow.getForeign("ID_ARTICLE"), check ? 1 : i, i == referentRows.size() - 1, true);
                            return i;
                        }
                        asRowValues = sqlRow.asRowValues(false);
                        if (asRowValues.isForeignEmpty("ID_COMPTE_PCE") && compteSpec != null) {
                            asRowValues.put("ID_COMPTE_PCE", compteSpec);
                        }
                        asRowValues.put("POURCENT_REMISE", remiseCumul);
                        asRowValues.put("QTE", asRowValues.getInt("QTE") * qtyMult);
                        asRowValues.put("T_PV_HT", asRowValues.getBigDecimal("T_PV_HT").multiply(new BigDecimal(qtyMult)).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2))));
                        asRowValues.put("T_PV_TTC", asRowValues.getBigDecimal("T_PV_TTC").multiply(new BigDecimal(qtyMult)).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2))));
                        calc.addLine(asRowValues, sqlRow.getForeign("ID_ARTICLE"), check ? 1 : i, i == referentRows.size() - 1, true);
                    }
                } else {
                    SQLRowValues asRowValues = sqlRow.asRowValues(false);
                    asRowValues.put("QTE", asRowValues.getInt("QTE") * qtyMult);
                    asRowValues.put("POURCENT_REMISE", remiseCumul);
                    asRowValues.put("T_PV_HT", asRowValues.getBigDecimal("T_PV_HT").multiply(new BigDecimal(qtyMult)).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2))));
                    asRowValues.put("T_PV_TTC", asRowValues.getBigDecimal("T_PV_TTC").multiply(new BigDecimal(qtyMult)).multiply(BigDecimal.ONE.subtract(remiseCumul.movePointLeft(2))));
                    if (asRowValues.isForeignEmpty("ID_COMPTE_PCE") && compteSpec != null) {
                        asRowValues.put("ID_COMPTE_PCE", compteSpec);
                    }
                    calc.addLine(asRowValues, sqlRow.getForeign("ID_ARTICLE"), check ? 1 : i, i == referentRows.size() - 1, true);
                }
            }
            ++i;
        }
        return referentRows.size();
    }

    protected TotalCalculator getValuesFromElement(SQLRow row, SQLTable foreign, BigDecimal portHT, SQLRow rowTVAPort, BigDecimal fraisDocHT, SQLRow rowTVAFraisDoc, SQLTable tableEchantillon) {
        return this.getValuesFromElement(false, false, "T_PV_HT", row, foreign, portHT, rowTVAPort, fraisDocHT, rowTVAFraisDoc, tableEchantillon, null);
    }

    protected TotalCalculator getValuesFromElement(boolean intra, boolean achat, String fieldTotalHT, SQLRow row, SQLTable foreign, BigDecimal portHT, SQLRow rowTVAPort, BigDecimal fraisDocHT, SQLRow rowTVAFraisDoc, SQLTable tableEchantillon, SQLRow defaultCompte) {
        SQLRow produitCompte;
        SQLRow serviceCompte;
        SQLRow tiers;
        boolean interfel = false;
        if (achat) {
            tiers = row.getForeign("ID_FOURNISSEUR");
        } else {
            tiers = row.getForeign("ID_CLIENT");
            if (tiers.getTable().contains("INTERFEL")) {
                interfel = tiers.getBoolean("INTERFEL");
            }
        }
        SQLRow rowCatCompta = null;
        if (tiers.getObject("ID_CATEGORIE_COMPTABLE") != null && !tiers.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
            rowCatCompta = tiers.getForeign("ID_CATEGORIE_COMPTABLE");
        }
        if (row.getTable().contains("ID_CATEGORIE_COMPTABLE") && row.getObject("ID_CATEGORIE_COMPTABLE") != null && !row.isForeignEmpty("ID_CATEGORIE_COMPTABLE")) {
            rowCatCompta = row.getForeign("ID_CATEGORIE_COMPTABLE");
        }
        TotalCalculator calc = new TotalCalculator("T_PA_HT", fieldTotalHT, null, achat, defaultCompte, rowCatCompta);
        calc.setIntraComm(intra);
        calc.setInterfel(interfel);
        String val = DefaultNXProps.getInstance().getStringProperty("ArticleService");
        Boolean bServiceActive = Boolean.valueOf(val);
        calc.setServiceActive(bServiceActive != null && bServiceActive != false);
        SQLBackgroundTableCacheItem cacheCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(compteTable);
        if (row.getTable().contains("ID_COMPTE_PCE_SERVICE") && !row.isForeignEmpty("ID_COMPTE_PCE_SERVICE") && (serviceCompte = cacheCompte.getRowFromId(row.getForeignID("ID_COMPTE_PCE_SERVICE"))) != null && !serviceCompte.isUndefined()) {
            calc.setRowDefaultCptService(serviceCompte);
        }
        if (row.getTable().contains("ID_COMPTE_PCE_VENTE") && !row.isForeignEmpty("ID_COMPTE_PCE_VENTE") && !(produitCompte = cacheCompte.getRowFromId(row.getForeignID("ID_COMPTE_PCE_VENTE"))).isUndefined()) {
            calc.setRowDefaultCptProduit(produitCompte);
        }
        long remise = 0L;
        BigDecimal totalAvtRemise = BigDecimal.ZERO;
        OOXMLCache cacheRefRows = new OOXMLCache();
        List<? extends SQLRowAccessor> referentRows = cacheRefRows.getReferentRows(Arrays.asList(row), foreign);
        Boolean leafGeneration = Boolean.valueOf(System.getProperty("org.openconcerto.accounting.leaf.generated"));
        if (row.getTable().contains("REMISE_HT") && (remise = row.getLong("REMISE_HT")) != 0L) {
            if (leafGeneration.booleanValue()) {
                this.parseItemAndAddLeafLines(calc, 0, referentRows, null, 1, BigDecimal.ZERO, true);
            } else {
                for (SQLRowAccessor sQLRowAccessor : referentRows) {
                    calc.addLine(sQLRowAccessor, sQLRowAccessor.getForeign("ID_ARTICLE"), 1, false);
                }
            }
            if (tableEchantillon != null) {
                Collection collection = row.getReferentRows(tableEchantillon);
                for (SQLRow sqlRow : collection) {
                    calc.addEchantillon((BigDecimal)sqlRow.getObject("T_PV_HT"), sqlRow.getForeign("ID_TAXE"));
                }
            }
            calc.checkResult();
            totalAvtRemise = calc.getTotalHT();
        }
        calc.initValues();
        long l = remise;
        if (row.getFields().contains("POURCENT_FACTURABLE") && row.getFields().contains("MONTANT_FACTURABLE")) {
            BigDecimal montantFact = row.getBigDecimal("MONTANT_FACTURABLE");
            BigDecimal percentFact = row.getBigDecimal("POURCENT_FACTURABLE");
            if (montantFact != null && montantFact.signum() > 0) {
                l = 0L;
            } else if (percentFact != null && percentFact.signum() > 0) {
                l = percentFact.movePointLeft(2).multiply(new BigDecimal(remise)).setScale(0, RoundingMode.HALF_UP).longValue();
            }
        }
        calc.setRemise(l, totalAvtRemise);
        if (leafGeneration.booleanValue()) {
            this.parseItemAndAddLeafLines(calc, 0, referentRows, null, 1, BigDecimal.ZERO, false);
        } else {
            int i = 0;
            while (i < referentRows.size()) {
                SQLRowAccessor sqlRow = referentRows.get(i);
                calc.addLine(sqlRow, sqlRow.getForeign("ID_ARTICLE"), i, i == referentRows.size() - 1);
                ++i;
            }
        }
        if (tableEchantillon != null) {
            Collection rowsEch = row.getReferentRows(tableEchantillon);
            for (SQLRowAccessor sqlRow : rowsEch) {
                calc.addEchantillon((BigDecimal)((SQLRow)sqlRow).getObject("T_PV_HT"), ((SQLRow)sqlRow).getForeign("ID_TAXE"));
            }
        }
        if (rowTVAPort != null && !rowTVAPort.isUndefined()) {
            SQLRow rowDefaultCptPort;
            SQLRowValues rowValsPort = new SQLRowValues(foreign);
            rowValsPort.put(achat ? "T_PA_HT" : "T_PV_HT", portHT);
            rowValsPort.put("QTE", 1);
            rowValsPort.put("ID_TAXE", rowTVAPort.getIDNumber());
            SQLTable tablePrefCompte = Configuration.getInstance().getRoot().findTable("PREFS_COMPTE");
            SQLRow rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte).getRowFromId(2);
            if (achat) {
                if (rowTVAPort.getFloat("TAUX") > 0.0f) {
                    rowDefaultCptPort = cacheCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_PORT_SOUMIS_ACHAT"));
                    if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                        try {
                            rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortAchatSoumisTVA");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    rowDefaultCptPort = cacheCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_PORT_NON_SOUMIS_ACHAT"));
                    if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                        try {
                            rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortAchatNonSoumisTVA");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else if (rowTVAPort.getFloat("TAUX") > 0.0f) {
                rowDefaultCptPort = cacheCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_PORT_SOUMIS"));
                if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                    try {
                        rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteSoumisTVA");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                rowDefaultCptPort = cacheCompte.getRowFromId(rowPrefsCompte.getForeignID("ID_COMPTE_PCE_PORT_NON_SOUMIS"));
                if (rowDefaultCptPort == null || rowDefaultCptPort.isUndefined()) {
                    try {
                        rowDefaultCptPort = ComptePCESQLElement.getRowComptePceDefault("PortVenteNonSoumisTVA");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            SQLRowValues rowValsArt = rowValsPort.putRowValues("ID_ARTICLE");
            rowValsArt.put(achat ? "ID_COMPTE_PCE_ACHAT" : "ID_COMPTE_PCE", rowDefaultCptPort.getID());
            rowValsArt.put("ID_TAXE_COMPLEMENTAIRE", null);
            rowValsArt.put("ID_FAMILLE_ARTICLE", null);
            calc.addLine(rowValsPort, rowValsPort.getForeign("ID_ARTICLE"), 1, false);
        }
        if (rowTVAFraisDoc != null && !rowTVAFraisDoc.isUndefined()) {
            SQLRowValues rowValsFraisDoc = new SQLRowValues(foreign);
            rowValsFraisDoc.put(achat ? "T_PA_HT" : "T_PV_HT", fraisDocHT);
            rowValsFraisDoc.put("QTE", 1);
            rowValsFraisDoc.put("ID_TAXE", rowTVAFraisDoc.getIDNumber());
            rowValsFraisDoc.put("SERVICE", Boolean.TRUE);
            rowValsFraisDoc.put("ID_FAMILLE_ARTICLE", null);
            calc.addLine(rowValsFraisDoc, null, 1, false);
        }
        if (row.getTable().contains("TVA_ADJUSTMENT")) {
            BigDecimal tvaFix = row.getBigDecimal("TVA_ADJUSTMENT");
            calc.addTVAAdjust(tvaFix);
        }
        calc.checkResult();
        return calc;
    }

    public synchronized int getNewMouvement(String source, int idSource, int idPere, int idPiece) throws SQLException {
        SQLTable mouvementTable = base.getTable("MOUVEMENT");
        SQLSelect selNumMvt = new SQLSelect();
        selNumMvt.addSelect(mouvementTable.getField("NUMERO"), "MAX");
        String reqNumMvt = selNumMvt.asString();
        Object obNumMvt = base.getDataSource().executeScalar(reqNumMvt);
        int numMvt = 1;
        if (obNumMvt != null) {
            numMvt = Integer.parseInt(obNumMvt.toString());
        }
        ++numMvt;
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("SOURCE", source);
        m.put("IDSOURCE", idSource);
        m.put("ID_MOUVEMENT_PERE", idPere);
        this.idPiece = idPiece;
        m.put("ID_PIECE", idPiece);
        m.put("NUMERO", numMvt);
        SQLRowValues val = new SQLRowValues(mouvementTable, m);
        if (val.getInvalid() != null) {
            throw new IllegalStateException("Error in values for insert in table " + val.getTable().getName() + " : " + val.toString());
        }
        SQLRow row = val.insert();
        this.idMvt = row.getID();
        this.mEcritures.put("ID_MOUVEMENT", this.idMvt);
        System.err.println("Numero de mouvement g\u00e9n\u00e9r\u00e9 : " + numMvt);
        return this.idMvt;
    }

    protected void displayMvtNumber() {
        if (DefaultNXProps.getInstance().getBooleanValue("ShowMouvementNumber", false)) {
            final int numero = mouvementTable.getRow(this.idMvt).getInt("NUMERO");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "N\u00b0 de mouvement associ\u00e9 : " + numero);
                }
            });
        }
    }

    protected void fillJournalBanqueFromRow(SQLRow sqlRow) {
        SQLRow rowType;
        this.mEcritures.put("ID_JOURNAL", 4);
        if (!sqlRow.isForeignEmpty("ID_" + BanqueSQLElement.TABLENAME)) {
            SQLRow rowBanque = sqlRow.getForeignRow("ID_" + BanqueSQLElement.TABLENAME);
            if (!rowBanque.isForeignEmpty("ID_JOURNAL")) {
                SQLRow rowJournal = rowBanque.getForeignRow("ID_JOURNAL");
                this.mEcritures.put("ID_JOURNAL", rowJournal.getID());
            }
        } else if (sqlRow.getTable().contains("ID_TYPE_REGLEMENT") && !sqlRow.isForeignEmpty("ID_TYPE_REGLEMENT") && (rowType = sqlRow.getForeignRow("ID_TYPE_REGLEMENT")).getTable().contains("ID_JOURNAL") && !rowType.isForeignEmpty("ID_JOURNAL")) {
            SQLRow rowJournal = rowType.getForeignRow("ID_JOURNAL");
            this.mEcritures.put("ID_JOURNAL", rowJournal.getID());
        }
    }

    protected void fillCompteBanqueFromRow(SQLRow sqlRow, String defaultProps, boolean achat) throws SQLException {
        SQLRow rowBanque;
        int idPce = -1;
        idPce = sqlRow.getTable().contains("ID_TYPE_REGLEMENT") ? sqlRow.getForeign("ID_TYPE_REGLEMENT").getInt("ID_COMPTE_PCE_" + (achat ? "FOURN" : "CLIENT")) : base.getTable("TYPE_REGLEMENT").getRow(2).getInt("ID_COMPTE_PCE_" + (achat ? "FOURN" : "CLIENT"));
        if (idPce <= 1) {
            idPce = ComptePCESQLElement.getIdComptePceDefault(defaultProps);
        }
        if (!sqlRow.isForeignEmpty("ID_" + BanqueSQLElement.TABLENAME) && !(rowBanque = sqlRow.getForeignRow("ID_" + BanqueSQLElement.TABLENAME)).isForeignEmpty("ID_COMPTE_PCE")) {
            SQLRow rowCompteBanque = rowBanque.getForeignRow("ID_COMPTE_PCE");
            idPce = rowCompteBanque.getID();
        }
        this.mEcritures.put("ID_COMPTE_PCE", idPce);
    }

    protected void lettrageAuto(List<Integer> pieceIDs, Date d) {
        SQLTable tablePrefCompte = base.getTable("PREFS_COMPTE");
        SQLRow rowPrefsCompte = SQLBackgroundTableCache.getInstance().getCacheForTable(tablePrefCompte).getRowFromId(2);
        if (rowPrefsCompte.getBoolean("AUTO_LETTRAGE").booleanValue()) {
            SQLSelect selEcr = new SQLSelect();
            SQLTable tableEcr = base.getTable("ECRITURE");
            selEcr.addSelect(tableEcr.getKey());
            selEcr.addSelect(tableEcr.getField("DEBIT"));
            selEcr.addSelect(tableEcr.getField("CREDIT"));
            selEcr.addSelect(tableEcr.getField("LETTRAGE"));
            SQLTable tableCpte = base.getTable("COMPTE_PCE");
            Where w2 = new Where(base.getTable("MOUVEMENT").getField("ID_PIECE"), pieceIDs);
            w2 = w2.and(new Where((FieldRef)tableEcr.getField("ID_MOUVEMENT"), "=", base.getTable("MOUVEMENT").getKey()));
            w2 = w2.and(new Where((FieldRef)tableEcr.getField("ID_COMPTE_PCE"), "=", tableCpte.getKey()));
            w2 = w2.and(new Where((FieldRef)tableCpte.getField("NUMERO"), "LIKE", (Object)"40%").or(new Where((FieldRef)tableCpte.getField("NUMERO"), "LIKE", (Object)"41%")));
            w2 = w2.and(new Where((FieldRef)tableEcr.getField("DATE_LETTRAGE"), "=", (Object)null));
            selEcr.setWhere(w2);
            long solde = -1L;
            List<SQLRow> ecr = SQLRowListRSH.execute(selEcr);
            if (!ecr.isEmpty()) {
                solde = 0L;
                for (SQLRow sqlRow2 : ecr) {
                    solde += sqlRow2.getLong("DEBIT");
                    solde -= sqlRow2.getLong("CREDIT");
                }
            }
            if (solde == 0L) {
                String codeLettre = NumerotationAutoSQLElement.getNextCodeLettrage();
                for (SQLRow sqlRow2 : ecr) {
                    SQLRowValues rowValsEcr = sqlRow2.asRowValues();
                    if (codeLettre.length() > 0) {
                        rowValsEcr.put("LETTRAGE", codeLettre);
                        rowValsEcr.put("DATE_LETTRAGE", d);
                        try {
                            rowValsEcr.update();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    SQLElement elt = Configuration.getInstance().getDirectory().getElement("NUMEROTATION_AUTO");
                    SQLRowValues rowVals = elt.getTable().getRow(2).createEmptyUpdateRow();
                    rowVals.put("CODE_LETTRAGE", codeLettre);
                    try {
                        rowVals.update();
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
    }
}

