/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;

public class BatchListProvider
extends UserInitialsValueProvider {
    private final String refTable;

    public BatchListProvider(String refTable) {
        this.refTable = refTable;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
        SQLRowAccessor row = context.getRow();
        Collection cols = row.asRow().getReferentRows(row.getTable().getTable(this.refTable));
        StringBuilder res = new StringBuilder();
        for (SQLRowAccessor sqlRowAccessor : cols) {
            Calendar dluo = sqlRowAccessor.getDate("DLUO");
            Calendar dlc = sqlRowAccessor.getDate("DLC");
            String lot = sqlRowAccessor.getString("NUMERO_LOT");
            String serie = sqlRowAccessor.getString("NUMERO_SERIE");
            if (res.length() > 0) {
                res.append("\n");
            }
            if (serie != null && serie.trim().length() > 0) {
                res.append("N\u00b0 S\u00e9rie : " + serie);
            }
            if (lot != null && lot.trim().length() > 0) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                res.append("N\u00b0 Lot : " + lot);
            }
            if (dlc != null) {
                if (res.length() > 0) {
                    res.append(", ");
                }
                res.append("DLC : " + format.format(dlc.getTime()));
            }
            if (dluo == null) continue;
            if (res.length() > 0) {
                res.append(", ");
            }
            res.append("DLUO : " + format.format(dluo.getTime()));
        }
        return res.toString();
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.batch.list", new BatchListProvider("LOT_LIVRAISON"));
        SpreadSheetCellValueProviderManager.put("purchase.batch.list", new BatchListProvider("LOT_RECEPTION"));
    }
}

