/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.gestcomm;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.supplychain.stock.element.DepotStockSQLElement;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.erp.preferences.PrinterNXProps;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.AliasedTable;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.Tuple2;

public class EtatVentesXmlSheet
extends AbstractListeSheetXml {
    private static final String MODE2 = "mod2";
    private static final String MODE1 = "mod1";
    public static final String TEMPLATE_ID = "EtatVentes";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private Timestamp du;
    private Timestamp au;
    public boolean ticketCaisse = false;
    public boolean facture = false;
    public boolean trieQuantiteParFamille = true;
    Date d;
    public static SQLRow rowDefaultCptService;
    public static SQLRow rowDefaultCptProduit;

    static {
        SQLTable tablePrefCompte = Configuration.getInstance().getRoot().findTable("PREFS_COMPTE");
        SQLRow rowPrefsCompte = tablePrefCompte.getRow(2);
        rowDefaultCptService = rowPrefsCompte.getForeign("ID_COMPTE_PCE_VENTE_SERVICE");
        if (rowDefaultCptService == null || rowDefaultCptService.isUndefined()) {
            try {
                rowDefaultCptService = ComptePCESQLElement.getRowComptePceDefault("VentesServices");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((rowDefaultCptProduit = rowPrefsCompte.getForeign("ID_COMPTE_PCE_VENTE_PRODUIT")) == null || rowDefaultCptProduit.isUndefined()) {
            try {
                rowDefaultCptProduit = ComptePCESQLElement.getRowComptePceDefault("VentesProduits");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public EtatVentesXmlSheet(Date du, Date au, boolean ticketCaisse, boolean facture) {
        this.printer = PrinterNXProps.getInstance().getStringProperty("BonPrinter");
        this.ticketCaisse = ticketCaisse;
        this.facture = facture;
        if (du != null) {
            Calendar c1 = Calendar.getInstance();
            c1.setTime(du);
            c1.set(11, 0);
            c1.set(12, 0);
            c1.set(13, 0);
            this.du = new Timestamp(c1.getTimeInMillis());
        }
        if (au != null) {
            Calendar c2 = Calendar.getInstance();
            c2.setTime(au);
            c2.set(11, 23);
            c2.set(12, 59);
            c2.set(13, 59);
            this.au = new Timestamp(c2.getTimeInMillis());
        }
    }

    public void setTrieParFamille(boolean trieParFamille) {
        this.trieQuantiteParFamille = trieParFamille;
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    protected String getStoragePathP() {
        return "Etat Ventes";
    }

    @Override
    public String getName() {
        if (this.d == null) {
            this.d = new Date();
        }
        return TEMPLATE_ID + this.d.getTime();
    }

    @Override
    protected void createListeValues() {
        HashMap<String, Number> vals;
        HashMap<String, Object> mValues;
        ArticleVendu a;
        Number articleID;
        HashMap<Integer, Tuple2<BigDecimal, BigDecimal>> mapTVAVT = new HashMap<Integer, Tuple2<BigDecimal, BigDecimal>>();
        HashMap<Integer, Tuple2<BigDecimal, BigDecimal>> mapTVAHA = new HashMap<Integer, Tuple2<BigDecimal, BigDecimal>>();
        SQLElementDirectory directory = Configuration.getInstance().getDirectory();
        SQLElement eltVenteFacutreElement = directory.getElement("SAISIE_VENTE_FACTURE_ELEMENT");
        SQLElement eltVenteFacture = directory.getElement("SAISIE_VENTE_FACTURE");
        SQLElement eltEncaissement = directory.getElement("ENCAISSER_MONTANT");
        SQLElement eltTicketCaisse = directory.getElement("TICKET_CAISSE");
        SQLElement eltModeReglement = directory.getElement("MODE_REGLEMENT");
        SQLTable tableModeReglement = eltModeReglement.getTable();
        SQLTable tableFactureElement = eltVenteFacutreElement.getTable();
        SQLTable tableFacture = eltVenteFacture.getTable();
        BigDecimal totalTPVTTC = BigDecimal.ZERO;
        BigDecimal totalTPA = BigDecimal.ZERO;
        ArrayList<Object> listValues = new ArrayList<Object>();
        HashMap<Integer, String> style = (HashMap<Integer, String>)this.styleAllSheetValues.get(0);
        if (style == null) {
            style = new HashMap<Integer, String>();
            this.styleAllSheetValues.put(0, style);
        }
        ArrayList<Map<Object, Object>> listValuesStock = new ArrayList<Map<Object, Object>>();
        HashMap<Integer, String> styleStock = new HashMap<Integer, String>();
        SQLTable foreignTableArticle = tableFactureElement.getForeignTable("ID_ARTICLE");
        AliasedTable tableModeReglement1 = new AliasedTable(tableModeReglement, MODE1);
        AliasedTable tableModeReglement2 = new AliasedTable(tableModeReglement, MODE2);
        AliasedTable tableTicket = new AliasedTable(eltTicketCaisse.getTable(), "ticket");
        SQLRowValues rowValsArtStock = new SQLRowValues(foreignTableArticle);
        rowValsArtStock.putNulls("ID", "CODE", "NOM");
        SQLRowValues rowValsStock = new SQLRowValues(tableFactureElement.getTable("STOCK"));
        rowValsStock.putNulls("QTE_REEL", "QTE_TH", "QTE_MIN", "QTE_RECEPT_ATTENTE", "QTE_LIV_ATTENTE").put("ID_ARTICLE", (Object)rowValsArtStock);
        rowValsStock.putRowValues("ID_DEPOT_STOCK").setAllToNull();
        SQLRowValuesListFetcher fetcherStock = SQLRowValuesListFetcher.create(rowValsArtStock);
        List<SQLRowValues> resultStock = fetcherStock.fetch();
        ListMap<Integer, SQLRowValues> listMapStock = new ListMap<Integer, SQLRowValues>();
        for (SQLRowValues sqlRowValues : resultStock) {
            Collection referentRows = sqlRowValues.getReferentRows(tableFactureElement.getTable("STOCK").getField("ID_ARTICLE"));
            for (SQLRowValues sqlRowValues2 : referentRows) {
                listMapStock.add(sqlRowValues.getID(), sqlRowValues2);
            }
        }
        SQLSelect sel = new SQLSelect();
        sel.addSelect(tableFactureElement.getField("CODE"));
        sel.addSelect(tableFactureElement.getField("NOM"));
        sel.addSelect(tableFactureElement.getField("ID_ARTICLE"));
        sel.addSelect(tableFactureElement.getField("ID_TAXE"));
        Where w = new Where((FieldRef)tableFactureElement.getField("ID_TICKET_CAISSE"), "=", tableTicket.getTable().getUndefinedID());
        sel.addJoin("LEFT", tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE")).setWhere(w);
        SQLSelectJoin joinArt = sel.addJoin("LEFT", tableFactureElement.getField("ID_ARTICLE"));
        SQLSelectJoin joinFamArt = sel.addJoin("LEFT", joinArt.getJoinedTable().getField("ID_FAMILLE_ARTICLE"));
        sel.addSelect(joinFamArt.getJoinedTable().getField("NOM"));
        Where w2 = new Where((FieldRef)tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE"), "=", 1);
        sel.addJoin("LEFT", tableFacture.getField("ID_MODE_REGLEMENT"), MODE1);
        sel.addJoin("LEFT", tableFactureElement.getField("ID_TICKET_CAISSE"), "ticket").setWhere(w2);
        sel.addBackwardJoin("LEFT", "enc", eltEncaissement.getTable().getField("ID_TICKET_CAISSE"), "ticket");
        sel.addJoin("LEFT", new AliasedField(eltEncaissement.getTable().getField("ID_MODE_REGLEMENT"), "enc"), MODE2);
        String idTypeReglement1 = tableModeReglement1.getField("ID_TYPE_REGLEMENT").getFieldRef();
        String idTypeReglement2 = tableModeReglement2.getField("ID_TYPE_REGLEMENT").getFieldRef();
        String qte = sel.getAlias(tableFactureElement.getField("QTE")).getFieldRef();
        sel.addRawSelect("SUM(CASE WHEN " + idTypeReglement1 + "=2 OR " + idTypeReglement2 + "=2 THEN " + qte + " ELSE 0 END)", "Cheque");
        sel.addRawSelect("SUM(CASE WHEN " + idTypeReglement1 + "=3 OR " + idTypeReglement2 + "=3 THEN " + qte + " ELSE 0 END)", "CB");
        sel.addRawSelect("SUM(CASE WHEN " + idTypeReglement1 + "=4 OR " + idTypeReglement2 + "=4 THEN " + qte + " ELSE 0 END)", "Especes");
        Where w3 = new Where((FieldRef)tableTicket.getField("DATE"), this.du, (Object)this.au);
        Where w4 = new Where((FieldRef)tableFacture.getField("DATE"), this.du, (Object)this.au);
        Where wN = new Where((FieldRef)tableFactureElement.getField("NIVEAU"), "=", 1);
        if (this.du != null && this.au != null) {
            sel.setWhere(w3.or(w4).and(wN));
        } else {
            sel.setWhere(wN);
        }
        sel.addGroupBy(tableFactureElement.getField("NOM"));
        sel.addGroupBy(tableFactureElement.getField("CODE"));
        sel.addGroupBy(tableFactureElement.getField("ID_ARTICLE"));
        sel.addGroupBy(tableFactureElement.getField("ID_TAXE"));
        sel.addGroupBy(joinFamArt.getJoinedTable().getField("NOM"));
        sel.addFieldOrder(joinFamArt.getJoinedTable().getField("NOM"));
        System.err.println(sel.asString());
        SQLSelect selQte = new SQLSelect();
        selQte.addSelect(tableFactureElement.getField("CODE"));
        selQte.addSelect(tableFactureElement.getField("NOM"));
        selQte.addSelect(tableFactureElement.getField("QTE"), "SUM");
        selQte.addSelect(tableFactureElement.getField("T_PA_HT"), "SUM");
        selQte.addSelect(tableFactureElement.getField("T_PV_HT"), "SUM");
        selQte.addSelect(tableFactureElement.getField("T_PV_TTC"), "SUM");
        selQte.addSelect(tableFactureElement.getField("ID_TAXE"));
        selQte.addSelect(tableFactureElement.getField("ID_ARTICLE"));
        if (this.ticketCaisse) {
            selQte.addJoin("LEFT", tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE")).setWhere(Where.FALSE);
            selQte.addJoin("LEFT", tableFactureElement.getField("ID_TICKET_CAISSE"), "ticket").setWhere(w2);
        } else if (this.facture) {
            selQte.addJoin("LEFT", tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE")).setWhere(w);
            selQte.addJoin("LEFT", tableFactureElement.getField("ID_TICKET_CAISSE"), "ticket").setWhere(Where.FALSE);
        } else {
            selQte.addJoin("LEFT", tableFactureElement.getField("ID_SAISIE_VENTE_FACTURE")).setWhere(w);
            selQte.addJoin("LEFT", tableFactureElement.getField("ID_TICKET_CAISSE"), "ticket").setWhere(w2);
        }
        SQLSelectJoin joinArt2 = selQte.addJoin("LEFT", tableFactureElement.getField("ID_ARTICLE"));
        SQLSelectJoin joinFamArt2 = selQte.addJoin("LEFT", joinArt2.getJoinedTable().getField("ID_FAMILLE_ARTICLE"));
        selQte.addSelect(joinFamArt2.getJoinedTable().getField("NOM"));
        if (this.du != null && this.au != null) {
            selQte.setWhere(w3.or(w4).and(wN));
        } else {
            selQte.setWhere(wN);
        }
        selQte.addGroupBy(tableFactureElement.getField("NOM"));
        selQte.addGroupBy(tableFactureElement.getField("CODE"));
        selQte.addGroupBy(tableFactureElement.getField("ID_TAXE"));
        selQte.addGroupBy(tableFactureElement.getField("ID_ARTICLE"));
        selQte.addGroupBy(joinFamArt2.getJoinedTable().getField("NOM"));
        List listeQte = (List)Configuration.getInstance().getBase().getDataSource().execute(selQte.asString(), new ArrayListHandler());
        HashMap<String, ArticleVendu> map = new HashMap<String, ArticleVendu>();
        for (Object[] sqlRow : listeQte) {
            String code = (String)sqlRow[0];
            String nom = (String)sqlRow[1];
            Number qteVendu = (Number)sqlRow[2];
            Number ha = (Number)sqlRow[3];
            Number ht = (Number)sqlRow[4];
            BigDecimal ttc = (BigDecimal)sqlRow[5];
            Number tvaID = (Number)sqlRow[6];
            if (!mapTVAVT.containsKey(tvaID.intValue())) {
                mapTVAVT.put(tvaID.intValue(), Tuple2.create((BigDecimal)ht, ttc));
            } else {
                Tuple2 t = (Tuple2)mapTVAVT.get(tvaID.intValue());
                mapTVAVT.put(tvaID.intValue(), Tuple2.create(((BigDecimal)t.get0()).add((BigDecimal)ht), ((BigDecimal)t.get1()).add(ttc)));
            }
            articleID = (Number)sqlRow[7];
            ArticleVendu a2 = new ArticleVendu(code, nom, qteVendu.intValue(), (BigDecimal)ht, (BigDecimal)ha, ttc, tvaID.intValue(), foreignTableArticle.getRow(articleID.intValue()));
            map.put(articleID + "##" + code + "##" + nom + "##" + tvaID, a2);
        }
        List listeIds = (List)Configuration.getInstance().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (listeIds == null) {
            return;
        }
        String famille = null;
        HashMap<Number, Map<String, String>> articleStockAdded = new HashMap<Number, Map<String, String>>();
        for (Object[] obj : listeIds) {
            Map<String, String> mValuesStock;
            Iterator mValues2;
            Object valueFam = obj[4];
            if (this.trieQuantiteParFamille) {
                if (valueFam == null && famille == null || famille != null && !famille.equalsIgnoreCase("Non class\u00e9s") && (valueFam == null || valueFam.toString().trim().length() == 0)) {
                    famille = "Non class\u00e9s";
                    mValues2 = new HashMap();
                    mValues2.put("NOM", famille);
                    style.put(listValues.size(), "Titre 1");
                    listValues.add(mValues2);
                    styleStock.put(listValuesStock.size(), "Titre 1");
                    listValuesStock.add((Map<Object, Object>)((Object)mValues2));
                } else if (valueFam != null && !valueFam.toString().equalsIgnoreCase(famille)) {
                    famille = valueFam.toString();
                    mValues2 = new HashMap();
                    mValues2.put("NOM", famille);
                    style.put(listValues.size(), "Titre 1");
                    listValues.add(mValues2);
                    styleStock.put(listValuesStock.size(), "Titre 1");
                    listValuesStock.add((Map<Object, Object>)((Object)mValues2));
                }
            }
            mValues2 = new HashMap<String, Object>();
            String code = (String)obj[0];
            String nom = (String)obj[1];
            articleID = (Number)obj[2];
            Number taxeID = (Number)obj[3];
            ArticleVendu a3 = (ArticleVendu)map.get(articleID + "##" + code + "##" + nom + "##" + taxeID);
            if (a3 == null) {
                System.err.println("Aucune correspondance pour l'article " + articleID + "##" + code + "##" + nom + "##" + taxeID);
            }
            if (a3 == null || a3.ttc == null || a3.ttc.signum() == 0 && (articleID == null || articleID.intValue() <= 1)) continue;
            mValues2.put("CODE", code);
            mValues2.put("NOM", nom);
            mValues2.put("QTE", a3.qte);
            mValues2.put("T_PA", a3.ha);
            mValues2.put("T_PV_HT", a3.ht);
            mValues2.put("TVA_TAUX", a3.tva);
            mValues2.put("NUMERO_COMPTE", a3.numeroCompte);
            mValues2.put("T_PV_TTC", a3.ttc);
            mValues2.put("NB_CHEQUE", obj[5]);
            mValues2.put("NB_CB", obj[6]);
            mValues2.put("NB_ESPECES", obj[7]);
            mValues2.put("FAMILLE", valueFam);
            totalTPA = totalTPA.add(a3.ha);
            totalTPVTTC = totalTPVTTC.add(a3.ttc);
            style.put(listValues.size(), "Normal");
            listValues.add(mValues2);
            if (!listMapStock.containsKey(articleID)) continue;
            if (!articleStockAdded.keySet().contains(articleID)) {
                mValuesStock = new HashMap();
                List rowValsArt = (List)listMapStock.get(articleID);
                articleStockAdded.put(articleID, mValuesStock);
                mValuesStock.put("CODE", code);
                mValuesStock.put("NOM", nom);
                mValuesStock.put("QTE", (String)((Object)Integer.valueOf(a3.qte)));
                BigDecimal totalTh = BigDecimal.ZERO;
                BigDecimal totalReel = BigDecimal.ZERO;
                BigDecimal min = BigDecimal.ZERO;
                BigDecimal attentR = BigDecimal.ZERO;
                BigDecimal attenteL = BigDecimal.ZERO;
                for (SQLRowValues rowStock : rowValsArt) {
                    SQLRowAccessor foreignArticle = rowStock.getForeign("ID_ARTICLE");
                    mValuesStock.put("CODE", foreignArticle.getString("CODE"));
                    mValuesStock.put("NOM", foreignArticle.getString("NOM"));
                    BigDecimal qteThCurrentStock = new BigDecimal(rowStock.getFloat("QTE_TH"));
                    totalTh = totalTh.add(qteThCurrentStock);
                    BigDecimal qteReelCurrentStock = new BigDecimal(rowStock.getFloat("QTE_REEL"));
                    totalReel = totalReel.add(qteReelCurrentStock);
                    BigDecimal qteMinCurrentStock = new BigDecimal(rowStock.getFloat("QTE_MIN"));
                    min = min.add(qteMinCurrentStock);
                    BigDecimal qteRecptionCurrentStock = new BigDecimal(rowStock.getFloat("QTE_RECEPT_ATTENTE"));
                    attentR = attentR.add(qteRecptionCurrentStock);
                    BigDecimal qteLivraisonhCurrentStock = new BigDecimal(rowStock.getFloat("QTE_LIV_ATTENTE"));
                    attenteL = attenteL.add(qteLivraisonhCurrentStock);
                    SQLRowAccessor depot = rowStock.getNonEmptyForeign("ID_DEPOT_STOCK");
                    if (depot == null || depot.getID() != DepotStockSQLElement.DEFAULT_ID) continue;
                    mValuesStock.put("QTE_TH_PRINCIPAL", (String)((Object)qteThCurrentStock));
                    mValuesStock.put("QTE_REEL_PRINCIPAL", (String)((Object)qteReelCurrentStock));
                    mValuesStock.put("QTE_MIN_PRINCIPAL", (String)((Object)qteMinCurrentStock));
                    mValuesStock.put("QTE_RECEPT_ATTENTE_PRINCIPAL", (String)((Object)qteRecptionCurrentStock));
                    mValuesStock.put("QTE_LIV_ATTENTE_PRINCIPAL", (String)((Object)qteLivraisonhCurrentStock));
                }
                mValuesStock.put("QTE_TH", (String)((Object)totalTh));
                mValuesStock.put("QTE_REEL", (String)((Object)totalReel));
                mValuesStock.put("QTE_MIN", (String)((Object)min));
                mValuesStock.put("QTE_RECEPT_ATTENTE", (String)((Object)attentR));
                mValuesStock.put("QTE_LIV_ATTENTE", (String)((Object)attenteL));
                styleStock.put(listValuesStock.size(), "Normal");
                listValuesStock.add(mValuesStock);
                continue;
            }
            mValuesStock = (Map)articleStockAdded.get(articleID);
            mValuesStock.put("QTE", (String)((Object)Integer.valueOf((Integer)mValuesStock.get("QTE") + a3.qte)));
        }
        if (!this.trieQuantiteParFamille) {
            Collections.sort(listValuesStock, new Comparator<Map<String, Object>>(){

                @Override
                public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                    return o1.get("CODE").toString().compareTo(o2.get("CODE").toString());
                }
            });
        }
        SQLTable venteComptoirT = directory.getElement("SAISIE_VENTE_COMPTOIR").getTable();
        SQLSelect selVC = new SQLSelect();
        selVC.addSelect(venteComptoirT.getField("NOM"));
        selVC.addSelect(venteComptoirT.getField("MONTANT_HT"), "SUM");
        selVC.addSelect(venteComptoirT.getField("MONTANT_TTC"), "SUM");
        selVC.addSelect(venteComptoirT.getField("NOM"), "COUNT");
        selVC.addSelect(venteComptoirT.getField("ID_TAXE"));
        if (this.du != null && this.au != null) {
            Where wVC = new Where((FieldRef)venteComptoirT.getField("DATE"), this.du, (Object)this.au);
            wVC = wVC.and(new Where((FieldRef)venteComptoirT.getField("ID_ARTICLE"), "=", venteComptoirT.getForeignTable("ID_ARTICLE").getKey()));
            selVC.setWhere(wVC);
        } else {
            selVC.setWhere(new Where((FieldRef)venteComptoirT.getField("ID_ARTICLE"), "=", venteComptoirT.getForeignTable("ID_ARTICLE").getKey()));
        }
        selVC.addGroupBy(venteComptoirT.getField("NOM"));
        selVC.addGroupBy(venteComptoirT.getField("ID_TAXE"));
        List listVC = (List)venteComptoirT.getDBSystemRoot().getDataSource().execute(selVC.asString(), new ArrayListHandler());
        long totalVCInCents = 0L;
        if (listVC.size() > 0) {
            HashMap<String, String> mValues3 = new HashMap<String, String>();
            mValues3.put("NOM", " ");
            listValues.add(mValues3);
            HashMap mValues2 = new HashMap();
            if (listVC.size() > 1) {
                mValues2.put("NOM", "VENTES COMPTOIR");
            } else {
                mValues2.put("NOM", "VENTE COMPTOIR");
            }
            style.put(listValues.size(), "Titre 1");
            listValues.add(mValues2);
        }
        for (Object[] rowVenteComptoir : listVC) {
            HashMap<String, Object> mValues4 = new HashMap<String, Object>();
            mValues4.put("NOM", rowVenteComptoir[0]);
            long ht = ((Number)rowVenteComptoir[1]).longValue();
            mValues4.put("T_PV_HT", (double)ht / 100.0);
            long ttcInCents = ((Number)rowVenteComptoir[2]).longValue();
            mValues4.put("T_PV_TTC", (double)ttcInCents / 100.0);
            totalVCInCents += ttcInCents;
            Integer idTaxe = ((Number)rowVenteComptoir[4]).intValue();
            mValues4.put("ID_TAXE", idTaxe);
            if (!mapTVAVT.containsKey(idTaxe)) {
                mapTVAVT.put(idTaxe, Tuple2.create(new BigDecimal(ht).movePointLeft(2), new BigDecimal(ttcInCents).movePointLeft(2)));
            } else {
                Tuple2 t = (Tuple2)mapTVAVT.get(idTaxe);
                mapTVAVT.put(idTaxe, Tuple2.create(((BigDecimal)t.get0()).add(new BigDecimal(ht).movePointLeft(2)), ((BigDecimal)t.get1()).add(new BigDecimal(ttcInCents).movePointLeft(2))));
            }
            mValues4.put("QTE", rowVenteComptoir[3]);
            listValues.add(mValues4);
        }
        SQLTable tableAvoirElement = directory.getElement("AVOIR_CLIENT_ELEMENT").getTable();
        SQLSelect sel2 = new SQLSelect();
        sel2.addSelect(tableAvoirElement.getField("CODE"));
        sel2.addSelect(tableAvoirElement.getField("NOM"));
        sel2.addSelect(tableAvoirElement.getField("ID_ARTICLE"));
        sel2.addSelect(tableAvoirElement.getField("ID_TAXE"));
        sel2.addJoin("LEFT", tableAvoirElement.getField("ID_AVOIR_CLIENT"));
        SQLSelectJoin joinArt3 = sel2.addJoin("LEFT", tableAvoirElement.getField("ID_ARTICLE"));
        SQLSelectJoin joinFamArt3 = sel2.addJoin("LEFT", joinArt3.getJoinedTable().getField("ID_FAMILLE_ARTICLE"));
        sel2.addSelect(joinFamArt3.getJoinedTable().getField("NOM"));
        Where w42 = new Where((FieldRef)tableAvoirElement.getTable("AVOIR_CLIENT").getField("DATE"), this.du, (Object)this.au);
        Where wN2 = new Where((FieldRef)tableAvoirElement.getField("NIVEAU"), "=", 1);
        if (this.du != null && this.au != null) {
            sel2.setWhere(w42.and(wN2));
        } else {
            sel2.setWhere(wN2);
        }
        sel2.addGroupBy(tableAvoirElement.getField("NOM"));
        sel2.addGroupBy(tableAvoirElement.getField("CODE"));
        sel2.addGroupBy(tableAvoirElement.getField("ID_ARTICLE"));
        sel2.addGroupBy(tableAvoirElement.getField("ID_TAXE"));
        sel2.addGroupBy(joinFamArt3.getJoinedTable().getField("NOM"));
        sel2.addFieldOrder(joinFamArt3.getJoinedTable().getField("NOM"));
        System.err.println(sel2.asString());
        SQLSelect selQte2 = new SQLSelect();
        selQte2.addSelect(tableAvoirElement.getField("CODE"));
        selQte2.addSelect(tableAvoirElement.getField("NOM"));
        selQte2.addSelect(tableAvoirElement.getField("QTE"), "SUM");
        selQte2.addSelect(tableAvoirElement.getField("T_PA_HT"), "SUM");
        selQte2.addSelect(tableAvoirElement.getField("T_PV_HT"), "SUM");
        selQte2.addSelect(tableAvoirElement.getField("T_PV_TTC"), "SUM");
        selQte2.addSelect(tableAvoirElement.getField("ID_TAXE"));
        selQte2.addSelect(tableAvoirElement.getField("ID_ARTICLE"));
        selQte2.addJoin("LEFT", tableAvoirElement.getField("ID_AVOIR_CLIENT"));
        SQLSelectJoin joinArt22 = selQte2.addJoin("LEFT", tableAvoirElement.getField("ID_ARTICLE"));
        SQLSelectJoin joinFamArt22 = selQte2.addJoin("LEFT", joinArt22.getJoinedTable().getField("ID_FAMILLE_ARTICLE"));
        selQte2.addSelect(joinFamArt22.getJoinedTable().getField("NOM"));
        if (this.du != null && this.au != null) {
            selQte2.setWhere(w42.and(wN2));
        } else {
            selQte2.setWhere(wN2);
        }
        selQte2.addGroupBy(tableAvoirElement.getField("NOM"));
        selQte2.addGroupBy(tableAvoirElement.getField("CODE"));
        selQte2.addGroupBy(tableAvoirElement.getField("ID_TAXE"));
        selQte2.addGroupBy(tableAvoirElement.getField("ID_ARTICLE"));
        selQte2.addGroupBy(joinFamArt22.getJoinedTable().getField("NOM"));
        List listeQte2 = (List)Configuration.getInstance().getBase().getDataSource().execute(selQte2.asString(), new ArrayListHandler());
        HashMap<String, ArticleVendu> map2 = new HashMap<String, ArticleVendu>();
        for (Object[] sqlRow : listeQte2) {
            String code = (String)sqlRow[0];
            String nom = (String)sqlRow[1];
            Number qteVendu = (Number)sqlRow[2];
            Number ha = (Number)sqlRow[3];
            Number ht = (Number)sqlRow[4];
            BigDecimal ttc = (BigDecimal)sqlRow[5];
            Number tvaID = (Number)sqlRow[6];
            if (!mapTVAVT.containsKey(tvaID.intValue())) {
                mapTVAVT.put(tvaID.intValue(), Tuple2.create(((BigDecimal)ht).negate(), ttc.negate()));
            } else {
                Tuple2 t = (Tuple2)mapTVAVT.get(tvaID.intValue());
                mapTVAVT.put(tvaID.intValue(), Tuple2.create(((BigDecimal)t.get0()).subtract((BigDecimal)ht), ((BigDecimal)t.get1()).subtract(ttc)));
            }
            Number articleID2 = (Number)sqlRow[7];
            a = new ArticleVendu(code, nom, -qteVendu.intValue(), ((BigDecimal)ht).negate(), ((BigDecimal)ha).negate(), ttc.negate(), tvaID.intValue(), foreignTableArticle.getRow(articleID2.intValue()));
            map2.put(articleID2 + "##" + code + "##" + (String)nom + "##" + tvaID, a);
        }
        List listeIds2 = (List)Configuration.getInstance().getBase().getDataSource().execute(sel2.asString(), new ArrayListHandler());
        if (listeIds2 == null) {
            return;
        }
        HashMap<String, String> mValuesA = new HashMap<String, String>();
        mValuesA.put("NOM", "AVOIRS");
        style.put(listValues.size(), "Titre 1");
        listValues.add(mValuesA);
        for (Object[] obj : listeIds2) {
            Object valueFam = obj[4];
            mValues = new HashMap<String, Object>();
            String code = (String)obj[0];
            String nom = (String)obj[1];
            Number articleID3 = (Number)obj[2];
            Number taxeID = (Number)obj[3];
            a = (ArticleVendu)map2.get(articleID3 + "##" + code + "##" + nom + "##" + taxeID);
            if (a.ttc == null || a.ttc.signum() == 0) continue;
            mValues.put("CODE", code);
            mValues.put("NOM", nom);
            mValues.put("QTE", a.qte);
            mValues.put("T_PA", a.ha);
            mValues.put("T_PV_HT", a.ht);
            mValues.put("TVA_TAUX", a.tva);
            mValues.put("NUMERO_COMPTE", a.numeroCompte);
            mValues.put("T_PV_TTC", a.ttc);
            mValues.put("FAMILLE", valueFam);
            totalTPA = totalTPA.add(a.ha);
            totalTPVTTC = totalTPVTTC.add(a.ttc);
            style.put(listValues.size(), "Normal");
            listValues.add(mValues);
        }
        totalTPVTTC = totalTPVTTC.add(new BigDecimal(totalVCInCents).movePointLeft(2));
        ArrayList listValuesAchat = new ArrayList();
        HashMap<String, Object> valuesAchat = (HashMap<String, Object>)this.mapAllSheetValues.get(1);
        if (valuesAchat == null) {
            valuesAchat = new HashMap<String, Object>();
        }
        long totalAchatInCents = 0L;
        SQLElement eltAchat = directory.getElement("SAISIE_ACHAT");
        SQLTable tableAchat = eltAchat.getTable();
        SQLSelect selAchat = new SQLSelect();
        selAchat.addSelect(tableAchat.getField("NOM"));
        selAchat.addSelect(tableAchat.getField("MONTANT_HT"), "SUM");
        selAchat.addSelect(tableAchat.getField("MONTANT_TTC"), "SUM");
        selAchat.addSelect(tableAchat.getField("ID_TAXE"));
        Where wHA = new Where((FieldRef)tableAchat.getField("DATE"), this.du, (Object)this.au);
        selAchat.setWhere(wHA);
        selAchat.addGroupBy(tableAchat.getField("NOM"));
        selAchat.addGroupBy(tableAchat.getField("ID_TAXE"));
        List listAchat = (List)Configuration.getInstance().getBase().getDataSource().execute(selAchat.asString(), new ArrayListHandler());
        for (Object[] row : listAchat) {
            HashMap<String, Object> mValues5 = new HashMap<String, Object>();
            mValues5.put("NOM", row[0]);
            Integer tvaID = ((Number)row[3]).intValue();
            mValues5.put("TAXE", tvaID);
            long ht = ((Number)row[1]).longValue();
            long pA = ((Number)row[2]).longValue();
            if (!mapTVAHA.containsKey((int)tvaID)) {
                mapTVAHA.put(tvaID, Tuple2.create(new BigDecimal(ht).movePointLeft(2), new BigDecimal(pA).movePointLeft(2)));
            } else {
                Tuple2 t = (Tuple2)mapTVAHA.get((int)tvaID);
                mapTVAHA.put(tvaID, Tuple2.create(((BigDecimal)t.get0()).add(new BigDecimal(ht).movePointLeft(2)), ((BigDecimal)t.get1()).add(new BigDecimal(pA).movePointLeft(2))));
            }
            mValues5.put("T_PV_HT", (double)(-ht) / 100.0);
            mValues5.put("T_PV_TTC", (double)(-pA) / 100.0);
            totalAchatInCents -= pA;
            listValuesAchat.add(mValues5);
        }
        SQLElement eltFactElt = directory.getElement("FACTURE_FOURNISSEUR_ELEMENT");
        SQLTable tableFactElt = eltFactElt.getTable();
        SQLTable tableFactF = eltFactElt.getTable().getForeignTable("ID_FACTURE_FOURNISSEUR");
        SQLSelect selAchat2 = new SQLSelect();
        selAchat2.addSelect(tableFactElt.getField("ID_ARTICLE"));
        selAchat2.addSelect(tableFactElt.getField("CODE"));
        selAchat2.addSelect(tableFactElt.getField("NOM"));
        selAchat2.addSelect(tableFactElt.getField("T_PA_HT"), "SUM");
        selAchat2.addSelect(tableFactElt.getField("T_PA_TTC"), "SUM");
        selAchat2.addSelect(tableFactElt.getField("ID_TAXE"));
        selAchat2.addSelect(tableFactElt.getField("QTE"), "SUM");
        selAchat2.addJoin("LEFT", tableFactElt.getField("ID_FACTURE_FOURNISSEUR"));
        selAchat2.addGroupBy(tableFactElt.getField("ID_ARTICLE"));
        selAchat2.addGroupBy(tableFactElt.getField("CODE"));
        selAchat2.addGroupBy(tableFactElt.getField("NOM"));
        selAchat2.addGroupBy(tableFactElt.getField("ID_TAXE"));
        Where wFactF = new Where((FieldRef)tableFactF.getField("DATE"), this.du, (Object)this.au);
        selAchat2.setWhere(wFactF.and(new Where((FieldRef)tableFactElt.getField("NIVEAU"), "=", 1)));
        List listAchat2 = (List)Configuration.getInstance().getBase().getDataSource().execute(selAchat2.asString(), new ArrayListHandler());
        for (Object[] row : listAchat2) {
            HashMap<String, Object> mValues6 = new HashMap<String, Object>();
            mValues6.put("NOM", row[2]);
            Integer tvaID = ((Number)row[5]).intValue();
            mValues6.put("TAXE", tvaID);
            BigDecimal ht = (BigDecimal)row[3];
            BigDecimal pA = (BigDecimal)row[4];
            if (!mapTVAHA.containsKey((int)tvaID)) {
                mapTVAHA.put(tvaID, Tuple2.create(ht, pA));
            } else {
                Tuple2 t = (Tuple2)mapTVAHA.get((int)tvaID);
                mapTVAHA.put(tvaID, Tuple2.create(((BigDecimal)t.get0()).add(ht), ((BigDecimal)t.get1()).add(pA)));
            }
            mValues6.put("T_PV_HT", ht.negate());
            mValues6.put("T_PV_TTC", pA.negate());
            mValues6.put("QTE", row[6]);
            totalAchatInCents -= pA.movePointRight(2).setScale(0, RoundingMode.HALF_UP).longValue();
            listValuesAchat.add(mValues6);
        }
        HashMap<String, Object> valuesE = (HashMap<String, Object>)this.mapAllSheetValues.get(2);
        if (valuesE == null) {
            valuesE = new HashMap<String, Object>();
        }
        SQLElement eltE = directory.getElement("ENCAISSER_MONTANT");
        SQLElement eltM = directory.getElement("MODE_REGLEMENT");
        SQLElement eltT = directory.getElement("TYPE_REGLEMENT");
        SQLSelect selE = new SQLSelect();
        selE.addSelect(eltT.getTable().getField("NOM"));
        selE.addSelect(eltT.getTable().getField("NOM"), "COUNT");
        selE.addSelect(eltE.getTable().getField("MONTANT"), "SUM");
        Where wE = new Where((FieldRef)eltE.getTable().getField("DATE"), this.du, (Object)this.au);
        wE = wE.and(new Where((FieldRef)eltE.getTable().getField("ID_MODE_REGLEMENT"), "=", eltM.getTable().getKey()));
        wE = wE.and(new Where((FieldRef)eltM.getTable().getField("ID_TYPE_REGLEMENT"), "=", eltT.getTable().getKey()));
        selE.setWhere(wE);
        selE.addGroupBy(eltT.getTable().getField("NOM"));
        selE.addFieldOrder(eltT.getTable().getField("NOM"));
        List listE = (List)Configuration.getInstance().getBase().getDataSource().execute(selE.asString(), new ArrayListHandler());
        ArrayList<HashMap<String, Object>> listValuesE = new ArrayList<HashMap<String, Object>>();
        long totalEInCents = 0L;
        for (Object[] o : listE) {
            mValues = new HashMap();
            mValues.put("NOM", o[0]);
            long pA = ((Number)o[2]).longValue();
            mValues.put("QTE", o[1]);
            mValues.put("TOTAL", (double)pA / 100.0);
            totalEInCents += pA;
            listValuesE.add(mValues);
        }
        HashMap<String, Object> values = (HashMap<String, Object>)this.mapAllSheetValues.get(0);
        if (values == null) {
            values = new HashMap<String, Object>();
        }
        valuesAchat.put("TOTAL", Float.valueOf((float)totalAchatInCents / 100.0f));
        valuesE.put("TOTAL_HA", Float.valueOf((float)totalAchatInCents / 100.0f));
        valuesE.put("TOTAL", Float.valueOf((float)totalEInCents / 100.0f));
        valuesE.put("TOTAL_VT", totalTPVTTC);
        values.put("TOTAL", Float.valueOf((float)totalVCInCents / 100.0f));
        values.put("TOTAL_MARGE", totalTPVTTC.subtract(totalTPA));
        valuesE.put("TOTAL_GLOBAL", totalTPVTTC.add(new BigDecimal(totalAchatInCents).movePointLeft(2)));
        values.put("TOTAL_PA", totalTPA);
        values.put("TOTAL_PV_TTC", totalTPVTTC);
        String periode = "";
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yy");
        if (this.du != null && this.au != null) {
            periode = "P\u00e9riode du " + dateFormat.format(this.du) + " au " + dateFormat.format(this.au);
        } else if (this.du == null && this.au != null) {
            periode = "P\u00e9riode jusqu'au " + dateFormat.format(this.au);
        } else if (this.du != null && this.au == null) {
            periode = "P\u00e9riode depuis le " + dateFormat.format(this.du);
        }
        values.put("DATE", periode);
        valuesAchat.put("DATE", periode);
        valuesE.put("DATE", periode);
        HashMap<String, Object> valuesTotalVT = new HashMap<String, Object>();
        valuesTotalVT.put("T_MARGE", "Total");
        valuesTotalVT.put("T_PV_TTC", totalTPVTTC);
        style.put(listValues.size(), "Titre 2");
        listValues.add(valuesTotalVT);
        System.err.println(this.du);
        System.err.println(this.au);
        this.listAllSheetValues.put(0, listValues);
        this.mapAllSheetValues.put(0, values);
        this.listAllSheetValues.put(1, listValuesAchat);
        this.mapAllSheetValues.put(1, valuesAchat);
        this.listAllSheetValues.put(2, listValuesE);
        this.mapAllSheetValues.put(2, valuesE);
        HashMap<Integer, String> styleTVA = (HashMap<Integer, String>)this.styleAllSheetValues.get(3);
        if (styleTVA == null) {
            styleTVA = new HashMap<Integer, String>();
            this.styleAllSheetValues.put(3, styleTVA);
        }
        ArrayList listValuesTVA = new ArrayList();
        BigDecimal totalHT = BigDecimal.ZERO;
        BigDecimal totalTTC = BigDecimal.ZERO;
        BigDecimal totalHTHA = BigDecimal.ZERO;
        BigDecimal totalTTCHA = BigDecimal.ZERO;
        for (Integer idTaxe : mapTVAVT.keySet()) {
            vals = new HashMap<String, Number>();
            vals.put("VT_TAUX_TVA", TaxeCache.getCache().getTauxFromId(idTaxe));
            BigDecimal ht = (BigDecimal)((Tuple2)mapTVAVT.get(idTaxe)).get0();
            BigDecimal ttc = (BigDecimal)((Tuple2)mapTVAVT.get(idTaxe)).get1();
            totalHT = totalHT.add(ht);
            totalTTC = totalTTC.add(ttc);
            vals.put("VT_HT", ht);
            vals.put("VT_TVA", ttc.subtract(ht));
            vals.put("VT_TTC", ttc);
            if (mapTVAHA.containsKey(idTaxe)) {
                BigDecimal haht = (BigDecimal)((Tuple2)mapTVAHA.get(idTaxe)).get0();
                BigDecimal hattc = (BigDecimal)((Tuple2)mapTVAHA.get(idTaxe)).get1();
                vals.put("HA_HT", haht);
                vals.put("HA_TVA", hattc.subtract(haht));
                vals.put("HA_TTC", hattc);
                totalHTHA = totalHTHA.add(haht);
                totalTTCHA = totalTTCHA.add(hattc);
                mapTVAHA.remove(idTaxe);
            }
            styleTVA.put(listValuesTVA.size(), "Normal");
            listValuesTVA.add(vals);
        }
        for (Integer idTaxe : mapTVAHA.keySet()) {
            vals = new HashMap();
            BigDecimal haht = (BigDecimal)((Tuple2)mapTVAHA.get(idTaxe)).get0();
            BigDecimal hattc = (BigDecimal)((Tuple2)mapTVAHA.get(idTaxe)).get1();
            vals.put("VT_TAUX_TVA", TaxeCache.getCache().getTauxFromId(idTaxe));
            vals.put("HA_HT", haht);
            vals.put("HA_TVA", hattc.subtract(haht));
            vals.put("HA_TTC", hattc);
            totalHTHA = totalHTHA.add(haht);
            totalTTCHA = totalTTCHA.add(hattc);
            styleTVA.put(listValuesTVA.size(), "Normal");
            listValuesTVA.add(vals);
        }
        HashMap<String, Object> vals2 = new HashMap<String, Object>();
        vals2.put("VT_TAUX_TVA", "Total");
        vals2.put("VT_HT", totalHT);
        vals2.put("VT_TVA", totalTTC.subtract(totalHT));
        vals2.put("VT_TTC", totalTTC);
        vals2.put("HA_HT", totalHTHA);
        vals2.put("HA_TVA", totalTTCHA.subtract(totalHTHA));
        vals2.put("HA_TTC", totalTTCHA);
        styleTVA.put(listValuesTVA.size(), "Titre 1");
        listValuesTVA.add(vals2);
        HashMap<String, Object> valuesTVA = new HashMap<String, Object>();
        valuesTVA.put("TOTAL_TVA", totalTTC.subtract(totalHT).subtract(totalTTCHA.subtract(totalHTHA)));
        this.listAllSheetValues.put(3, listValuesTVA);
        valuesTVA.put("DATE", periode);
        this.mapAllSheetValues.put(3, valuesTVA);
        this.listAllSheetValues.put(4, listValuesStock);
        this.styleAllSheetValues.put(4, styleStock);
        this.mapAllSheetValues.put(4, values);
    }

    class ArticleVendu {
        public String code;
        public String nom;
        public int qte;
        public int tvaID;
        public BigDecimal ht;
        public BigDecimal ha;
        public BigDecimal ttc;
        public BigDecimal tva;
        public String numeroCompte;

        public ArticleVendu(String code, String nom, int qte, BigDecimal ht, BigDecimal ha, BigDecimal ttc, int tvaID, SQLRow rowArticle) {
            SQLRowAccessor rowCpt;
            this.code = code;
            this.nom = nom;
            this.qte = qte;
            this.ht = ht;
            this.ha = ha;
            this.ttc = ttc;
            this.tvaID = tvaID;
            this.tva = new BigDecimal(TaxeCache.getCache().getTauxFromId(tvaID).floatValue());
            SQLRowAccessor rowTVA = TaxeCache.getCache().getRowFromId(tvaID);
            boolean service = rowArticle.getBoolean("SERVICE");
            if (service) {
                rowCpt = rowDefaultCptService;
                if (rowTVA != null && !rowTVA.isForeignEmpty("ID_COMPTE_PCE_VENTE_SERVICE")) {
                    rowCpt = rowTVA.getForeign("ID_COMPTE_PCE_VENTE_SERVICE");
                }
            } else {
                rowCpt = rowDefaultCptProduit;
                if (rowTVA != null && !rowTVA.isForeignEmpty("ID_COMPTE_PCE_VENTE")) {
                    rowCpt = rowTVA.getForeign("ID_COMPTE_PCE_VENTE");
                }
            }
            if (rowArticle != null && !rowArticle.isUndefined()) {
                SQLRow compteArticle = rowArticle.getForeign("ID_COMPTE_PCE");
                if (compteArticle != null && !compteArticle.isUndefined()) {
                    rowCpt = compteArticle;
                } else {
                    SQLRowAccessor familleArticle = rowArticle.getForeign("ID_FAMILLE_ARTICLE");
                    HashSet<SQLRow> unique = new HashSet<SQLRow>();
                    while (familleArticle != null && !familleArticle.isUndefined() && !unique.contains(familleArticle)) {
                        unique.add((SQLRow)familleArticle);
                        SQLRowAccessor compteFamilleArticle = ((SQLRowAccessor)familleArticle).getForeign("ID_COMPTE_PCE");
                        if (compteFamilleArticle != null && !compteFamilleArticle.isUndefined()) {
                            rowCpt = compteFamilleArticle;
                            break;
                        }
                        familleArticle = ((SQLRowAccessor)familleArticle).getForeign("ID_FAMILLE_ARTICLE_PERE");
                    }
                }
            }
            if (rowCpt != null) {
                this.numeroCompte = rowCpt.getString("NUMERO");
            }
        }
    }
}

