/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openconcerto.erp.core.sales.product.element.LotSQLElement;
import org.openconcerto.erp.core.supplychain.stock.element.BatchNode;
import org.openconcerto.erp.core.supplychain.stock.element.StockNode;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;

public class StockRootNode {
    private final List<StockNode> children = new ArrayList<StockNode>();
    private final List<SQLRowValues> listRowValsStock = new ArrayList<SQLRowValues>();
    private final List<FieldPath> cols = new ArrayList<FieldPath>();
    private final SQLElement eltStock;
    private boolean hasBatch = false;

    public StockRootNode(SQLElement e) {
        this.eltStock = e;
        SQLTable tableStock = this.eltStock.getTable();
        Path pStock = new Path(tableStock);
        Path pDepotStock = (Path)pStock.add(tableStock.getField("ID_DEPOT_STOCK"));
        this.cols.add(new FieldPath(pDepotStock, "NOM"));
        this.cols.add(new FieldPath(pStock, "QTE_TH"));
        this.cols.add(new FieldPath(pStock, "QTE_RECEPT_ATTENTE"));
        this.cols.add(new FieldPath(pStock, "QTE_LIV_ATTENTE"));
        this.cols.add(new FieldPath(pStock, "QTE_REEL"));
    }

    public void load(SQLRowAccessor article) {
        this.children.clear();
        SQLTable tableStock = this.eltStock.getTable();
        SQLRowValues rowValsStock = new SQLRowValues(tableStock);
        rowValsStock.putNulls("QTE_TH", "QTE_RECEPT_ATTENTE", "QTE_LIV_ATTENTE", "QTE_REEL");
        rowValsStock.putRowValues("ID_DEPOT_STOCK").putNulls("NOM");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsStock);
        List<SQLRowValues> fetch = fetcher.fetch(new Where((FieldRef)tableStock.getField("ID_ARTICLE"), "=", article.getID()).and(new Where((FieldRef)tableStock.getField("QTE_REEL"), "!=", 0).or(new Where((FieldRef)tableStock.getField("QTE_TH"), "!=", 0))));
        this.listRowValsStock.clear();
        this.listRowValsStock.addAll(fetch);
        ArrayList<Integer> idsStock = new ArrayList<Integer>();
        for (SQLRowValues r : this.listRowValsStock) {
            idsStock.add(r.getID());
        }
        SQLTable tableLot = this.eltStock.getDirectory().getElement(LotSQLElement.class).getTable();
        SQLRowValues rLot = new SQLRowValues(tableLot);
        rLot.putNulls("ID_STOCK", "QUANTITE", "NUMERO_LOT", "NUMERO_SERIE", "DLC", "DLUO");
        List<SQLRowValues> fetchLots = SQLRowValuesListFetcher.create(rLot).fetch(Where.inValues(tableLot.getField("ID_STOCK"), idsStock));
        this.hasBatch = !fetchLots.isEmpty();
        HashMap<Integer, ArrayList<BatchNode>> stockLots = new HashMap<Integer, ArrayList<BatchNode>>();
        for (SQLRowValues lot : fetchLots) {
            int idStock = lot.getInt("ID_STOCK");
            ArrayList<BatchNode> lots = (ArrayList<BatchNode>)stockLots.get(idStock);
            if (lots == null) {
                lots = new ArrayList<BatchNode>();
                stockLots.put(idStock, lots);
            }
            lots.add(new BatchNode(lot));
        }
        for (SQLRowValues r : this.listRowValsStock) {
            this.children.add(new StockNode(r, (List)stockLots.get(r.getID())));
        }
    }

    public boolean hasBatch() {
        return this.hasBatch;
    }

    public StockNode getChild(int i) {
        return this.children.get(i);
    }

    public int getSize() {
        return this.children.size();
    }

    public String getLabelFor(int column) {
        return this.eltStock.getDirectory().getTranslator().getLabelFor(this.cols.get(column).getField()).replace("Quantit\u00e9", "Quantit\u00e9\n");
    }

    public FieldPath getFieldPath(int columnIndex) {
        FieldPath fieldPath = this.cols.get(columnIndex);
        return fieldPath;
    }
}

