/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.TarifQuantite;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.QuickOrderedMap;
import org.openconcerto.utils.Tuple2;

public class Article {
    private Categorie s;
    private String name;
    private boolean additionalCopyRequested = false;
    private BigDecimal priceTTC;
    private int idTaxe;
    private BigDecimal priceHT;
    private String barCode = "empty barcode";
    private String code = "";
    private BigDecimal discount_pct = BigDecimal.ZERO;
    private BigDecimal ecotaxe = BigDecimal.ZERO;
    private final int id;
    private String salesUnit;
    private static Map<String, List<Article>> codes = new HashMap<String, List<Article>>();
    private QuickOrderedMap<String, Tuple2<String, BigDecimal>> declinaisons;
    List<TarifQuantite> tarifs;
    private String declinaison;
    private String articlePereNom = null;

    public Article(Categorie s1, String string, int id) {
        this.s = s1;
        this.id = id;
        this.name = string;
        s1.addArticle(this);
    }

    public Article(Article a) {
        this.s = a.s;
        this.code = a.code;
        this.name = a.name;
        this.priceTTC = a.priceTTC;
        this.idTaxe = a.idTaxe;
        this.priceHT = a.priceHT;
        this.barCode = a.barCode;
        this.id = a.id;
        this.salesUnit = a.salesUnit;
        this.discount_pct = a.discount_pct;
        this.ecotaxe = a.ecotaxe;
        this.s.addArticle(this);
        QuickOrderedMap<String, Tuple2<String, BigDecimal>> decl = a.getDeclinaisons();
        if (decl != null) {
            int size = decl.size();
            this.declinaisons = new QuickOrderedMap(size);
            int i = 0;
            while (i < size) {
                this.declinaisons.put(decl.getKey(i), decl.getValue(i));
                ++i;
            }
        }
    }

    public void setTarifsPromotion(List<TarifQuantite> list) {
        this.tarifs = new ArrayList<TarifQuantite>();
        for (TarifQuantite t : list) {
            if (t.getIdArticle() != this.id) continue;
            this.tarifs.add(t);
        }
        Collections.sort(this.tarifs, new Comparator<TarifQuantite>(){

            @Override
            public int compare(TarifQuantite o1, TarifQuantite o2) {
                return o1.getQuantite() - o2.getQuantite();
            }
        });
    }

    public TarifQuantite getTarifPromotionForQuantity(int qty) {
        if (this.tarifs == null || this.tarifs.isEmpty()) {
            return null;
        }
        TarifQuantite result = null;
        for (TarifQuantite t : this.tarifs) {
            if (t.getQuantite() > qty) break;
            result = t;
        }
        return result;
    }

    public void addDeclinaison(String key, String value, BigDecimal ordreDeclinaison) {
        if (this.declinaisons == null) {
            this.declinaisons = new QuickOrderedMap(5);
        }
        this.declinaisons.put(key, Tuple2.create(value, ordreDeclinaison));
    }

    public QuickOrderedMap<String, Tuple2<String, BigDecimal>> getDeclinaisons() {
        return this.declinaisons;
    }

    public void setArticlePereNom(String articlePereNom) {
        this.articlePereNom = articlePereNom;
    }

    public String getArticlePereNom() {
        return this.articlePereNom;
    }

    public boolean isPromotion() {
        return this.tarifs != null && !this.tarifs.isEmpty();
    }

    public boolean isAdditionalCopyRequested() {
        return this.additionalCopyRequested;
    }

    public void setAdditionalCopyRequested(boolean additionalCopyRequested) {
        this.additionalCopyRequested = additionalCopyRequested;
    }

    public int getId() {
        return this.id;
    }

    public BigDecimal getPriceWithoutTax() {
        return this.getPriceWithoutTax(false);
    }

    public BigDecimal getPriceWithoutTax(boolean with_discount) {
        if (with_discount) {
            return this.priceHT.multiply(BigDecimal.ONE.subtract(this.getDiscountPct()));
        }
        return this.priceHT;
    }

    public BigDecimal getPriceWithoutTax(BigDecimal qty) {
        return this.getPriceWithoutTax(qty, false);
    }

    public BigDecimal getPriceWithoutTax(BigDecimal qty, boolean withDiscount) {
        TarifQuantite tarifPromotionForQuantity;
        BigDecimal price = this.priceHT;
        if (this.getSalesUnit() == null && (tarifPromotionForQuantity = this.getTarifPromotionForQuantity(qty.intValue())) != null) {
            price = tarifPromotionForQuantity.getPrixHT();
        }
        if (withDiscount) {
            price = price.multiply(BigDecimal.ONE.subtract(this.getDiscountPct()));
        }
        return price;
    }

    public void setPriceWithoutTax(BigDecimal priceHTInCents) {
        this.priceHT = priceHTInCents;
    }

    public int getIdTaxe() {
        return this.idTaxe;
    }

    public void setIdTaxe(int idTaxe) {
        this.idTaxe = idTaxe;
    }

    public void setBarCode(String bar) {
        this.barCode = bar;
        List<Article> list = codes.get(bar);
        if (list == null) {
            list = new ArrayList<Article>();
            codes.put(bar, list);
        }
        list.add(this);
    }

    public void setPriceWithTax(BigDecimal priceInCents) {
        this.priceTTC = priceInCents;
    }

    public BigDecimal getPriceWithTax(BigDecimal quantity) {
        return this.getPriceWithTax(quantity, false);
    }

    public BigDecimal getPriceWithTax(BigDecimal qty, boolean withDiscount) {
        TarifQuantite tarifPromotionForQuantity;
        BigDecimal price = this.priceTTC;
        if (this.getSalesUnit() == null && (tarifPromotionForQuantity = this.getTarifPromotionForQuantity(qty.intValue())) != null) {
            price = tarifPromotionForQuantity.getPrixTTC();
        }
        if (withDiscount) {
            price = price.multiply(BigDecimal.ONE.subtract(this.getDiscountPct()));
        }
        return price;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public Categorie getCategorie() {
        return this.s;
    }

    public String toString() {
        if (this.declinaisons != null) {
            return "Article:" + this.code + " | " + this.name + " " + this.priceTTC + " cents" + "(HT:" + this.priceHT + ") " + this.getSalesUnit() + " discount:" + this.getDiscountPct();
        }
        return "Article:" + this.code + " | " + this.name + "  [" + this.declinaisons + "] : " + this.priceTTC + " cents" + "(HT:" + this.priceHT + ") " + this.getSalesUnit() + " discount:" + this.getDiscountPct();
    }

    public static List<Article> getArticleFromBarcode(String code) {
        return codes.get(code);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return this.id == ((Article)obj).id;
    }

    public int hashCode() {
        return this.id;
    }

    public void updatePriceWithoutTax(BigDecimal ht) {
        this.priceHT = ht;
        this.priceTTC = Article.computePriceWithTax(ht, this.getIdTaxe());
    }

    public static BigDecimal computePriceWithTax(BigDecimal ht, int idTaxe) {
        BigDecimal tax = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(idTaxe).floatValue()).movePointLeft(2).add(BigDecimal.ONE);
        return ht.multiply(tax).setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal computePriceWithoutTax(BigDecimal ttc, int idTaxe) {
        BigDecimal tax = BigDecimal.valueOf(TaxeCache.getCache().getTauxFromId(idTaxe).floatValue()).movePointLeft(2).add(BigDecimal.ONE);
        return ttc.divide(tax, DecimalUtils.HIGH_PRECISION).setScale(6, RoundingMode.HALF_UP);
    }

    public void setSalesUnit(String name) {
        this.salesUnit = name;
    }

    public String getSalesUnit() {
        return this.salesUnit;
    }

    public void setDiscountPct(BigDecimal dsct) {
        this.discount_pct = dsct;
    }

    public BigDecimal getEcoTaxe() {
        return this.ecotaxe;
    }

    public BigDecimal getDiscountPct() {
        return this.discount_pct;
    }

    public void setEcoTaxe(BigDecimal ecotaxe) {
        this.ecotaxe = ecotaxe;
    }

    public void setDeclinaison(String declinaison) {
        this.declinaison = declinaison;
    }

    public String getDeclinaison() {
        if (this.declinaison == null && this.declinaisons != null && !this.declinaisons.isEmpty()) {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < this.declinaisons.size()) {
                Tuple2<String, BigDecimal> value = this.declinaisons.getValue(i);
                if (value != null) {
                    b.append(value.get0());
                    b.append("  ");
                }
                ++i;
            }
            return b.toString().trim();
        }
        return this.declinaison;
    }
}

