/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.model;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.erp.model.PrixHT;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;

public class BalanceModel
extends AbstractTableModel {
    private String[] titres;
    private Vector<Compte> vecteurCompte = new Vector();
    private long totalDebitBalance;
    private long totalCreditBalance;

    public BalanceModel() {
        this.titres = new String[5];
        this.titres[0] = "N\u00b0 compte";
        this.titres[1] = "Libell\u00e9 compte";
        this.titres[2] = "D\u00e9bit";
        this.titres[3] = "Cr\u00e9dit";
        this.titres[4] = "Solde";
    }

    @Override
    public Class<?> getColumnClass(int c) {
        if (c == 2) {
            return Long.class;
        }
        if (c == 3) {
            return Long.class;
        }
        if (c == 4) {
            return Long.class;
        }
        return String.class;
    }

    @Override
    public String getColumnName(int col) {
        return this.titres[col];
    }

    @Override
    public int getRowCount() {
        return this.vecteurCompte.size();
    }

    @Override
    public int getColumnCount() {
        return this.titres.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Compte cptTmp = this.vecteurCompte.get(rowIndex);
        if (columnIndex == 0) {
            return cptTmp.getNumero();
        }
        if (columnIndex == 1) {
            return cptTmp.getNom();
        }
        if (columnIndex == 2) {
            return new Long(new PrixHT(cptTmp.getTotalDebit()).getLongValue());
        }
        if (columnIndex == 3) {
            return new Long(new PrixHT(cptTmp.getTotalCredit()).getLongValue());
        }
        if (columnIndex == 4) {
            return new Long(new PrixHT(cptTmp.getTotalDebit() - cptTmp.getTotalCredit()).getLongValue());
        }
        return null;
    }

    public long getTotalDebit() {
        return this.totalDebitBalance;
    }

    public long getTotalCredit() {
        return this.totalCreditBalance;
    }

    public void getBalance() {
        HashMap<Number, Long> mapCompteDebit = new HashMap<Number, Long>();
        HashMap<Number, Long> mapCompteCredit = new HashMap<Number, Long>();
        Vector<Compte> comptes = new Vector<Compte>();
        this.totalDebitBalance = 0L;
        this.totalCreditBalance = 0L;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable compteTable = base.getTable("COMPTE_PCE");
        SQLTable ecritureTable = base.getTable("ECRITURE");
        SQLSelect sel = new SQLSelect(base);
        sel.addSelect(compteTable.getField("ID"));
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        sel.addSelect(compteTable.getField("NUMERO"));
        sel.setDistinct(true);
        sel.setWhere(new Where((FieldRef)compteTable.getField("ID"), "=", ecritureTable.getField("ID_COMPTE_PCE")));
        sel.setWaitPreviousWriteTX(false);
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\",\"COMPTE_PCE\".\"NUMERO\"  ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        System.out.println(req);
        Object ob = base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        if (myList.size() != 0) {
            int i = 0;
            while (i < myList.size()) {
                Object[] tmp = (Object[])myList.get(i);
                mapCompteDebit.put((Number)tmp[0], Long.parseLong(tmp[1].toString()));
                mapCompteCredit.put((Number)tmp[0], Long.parseLong(tmp[2].toString()));
                ++i;
            }
        }
        sel = new SQLSelect(base);
        sel.addSelect(compteTable.getKey());
        sel.addSelect(compteTable.getField("NUMERO"));
        sel.addSelect(compteTable.getField("NOM"));
        sel.addRawOrder("\"COMPTE_PCE\".\"NUMERO\"");
        String reqCompte = sel.asString();
        System.out.println(req);
        Object obCompte = base.getDataSource().execute(reqCompte, new ArrayListHandler());
        List myListCompte = (List)obCompte;
        if (myListCompte.size() != 0) {
            int i = 0;
            while (i < myListCompte.size()) {
                Object[] tmp = (Object[])myListCompte.get(i);
                System.err.println("Compte " + tmp[1].toString().trim());
                long totalDebit = 0L;
                long totalCredit = 0L;
                if (mapCompteDebit.get(tmp[0]) != null) {
                    totalDebit = Long.parseLong(((Long)mapCompteDebit.get(tmp[0])).toString());
                }
                if (mapCompteCredit.get(tmp[0]) != null) {
                    totalCredit = Long.parseLong(((Long)mapCompteCredit.get(tmp[0])).toString());
                }
                this.totalDebitBalance += totalDebit;
                this.totalCreditBalance += totalCredit;
                int j = i + 1;
                while (j < myListCompte.size() - 1) {
                    Object[] tmpNext = (Object[])myListCompte.get(j);
                    if (!tmpNext[1].toString().trim().startsWith(tmp[1].toString().trim())) break;
                    System.err.println("Sous Compte " + tmpNext[1].toString().trim());
                    if (mapCompteDebit.get(tmpNext[0]) != null) {
                        totalDebit += Long.parseLong(((Long)mapCompteDebit.get(tmpNext[0])).toString());
                    }
                    if (mapCompteCredit.get(tmpNext[0]) != null) {
                        totalCredit += Long.parseLong(((Long)mapCompteCredit.get(tmpNext[0])).toString());
                    }
                    ++j;
                }
                if ((double)totalDebit != 0.0 || (double)totalCredit != 0.0) {
                    Compte cpt = new Compte(((Number)tmp[0]).intValue(), tmp[1].toString(), tmp[2].toString(), "", totalDebit, totalCredit);
                    comptes.add(cpt);
                }
                ++i;
            }
        }
        this.vecteurCompte = comptes;
        this.fireTableDataChanged();
    }
}

