/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.jdom2.Element;
import org.jdom2.filter.ElementFilter;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.xml.persistence.PersistenceIO;
import org.openconcerto.xml.persistence.Persistent;
import org.openconcerto.xml.persistence.SingleXMLIO;
import org.openconcerto.xml.persistence.XMLFactory;

public class PersistenceManager {
    private static final boolean SAVE_REFS = false;
    private static final String NULL = "null";
    private static final Set<Persistent> saving = new HashSet<Persistent>();
    private static File wd;
    private static PersistenceIO io;
    private static final BidiMap idMap;
    private static final Map<String, Persistent> stubs;
    private static final Stack<String> idsStack;
    private static final Random r;

    static {
        PersistenceManager.setDir(new File(System.getProperty("user.dir")));
        idMap = new DualHashBidiMap();
        stubs = new HashMap<String, Persistent>();
        idsStack = new Stack();
        r = new Random();
    }

    public static Element getRef(Persistent object) {
        return PersistenceManager.getRef(object, null);
    }

    public static Element getRef(Persistent object, String name) {
        Element elem;
        if (object == null) {
            if (name == null) {
                throw new IllegalArgumentException("persistent object and name cannot be both null");
            }
            elem = new Element(NULL);
        } else {
            elem = XMLFactory.getElement(object.getClass());
            elem.setAttribute("id", PersistenceManager.getID(object));
            if (!io.exists(object.getClass(), PersistenceManager.getID(object))) {
                PersistenceManager.save(object);
            }
        }
        if (name != null) {
            elem.setAttribute("name", name);
        }
        return elem;
    }

    public static List<Element> getRefs(Collection<? extends Persistent> perss) {
        ArrayList<Element> res = new ArrayList<Element>(perss.size());
        for (Persistent persistent : perss) {
            res.add(PersistenceManager.getRef(persistent));
        }
        return res;
    }

    public static Persistent resolveRef(Element elem) {
        if (elem.getName().equals(NULL)) {
            return null;
        }
        String id = elem.getAttributeValue("id");
        if (id == null) {
            throw new IllegalArgumentException("Element not obtained from getRef (no id attribute).");
        }
        Persistent res = PersistenceManager.get(id);
        if (res == null) {
            Class<?> elemClass = XMLFactory.getNonNullClass(elem.getName());
            res = PersistenceManager.loadFromID(elemClass, id);
        }
        return res;
    }

    public static Persistent resolveChildRef(Element parent, Class<?> clazz) {
        return PersistenceManager.resolveRef(parent.getChild(XMLFactory.getElementName(clazz)));
    }

    public static Persistent resolveChildRef(Element parent, final String name) {
        List<Element> children = parent.getContent(new ElementFilter(){

            @Override
            public Element filter(Object obj) {
                Element elem = super.filter(obj);
                return elem != null && name.equals(elem.getAttributeValue("name")) ? elem : null;
            }
        });
        if (children.size() == 0) {
            throw new IllegalStateException("no element with name " + name + " found.");
        }
        if (children.size() > 1) {
            throw new IllegalStateException("more than one element with name " + name + " found.");
        }
        return PersistenceManager.resolveRef(children.get(0));
    }

    public static List<Persistent> resolveChildrenRef(Element parent, Class<?> clazz) {
        List<Element> children = parent.getChildren(XMLFactory.getElementName(clazz));
        ArrayList<Persistent> res = new ArrayList<Persistent>(children.size());
        for (Element element : children) {
            res.add(PersistenceManager.resolveRef(element));
        }
        return res;
    }

    public static void setDir(File dir) {
        wd = dir;
        io = new SingleXMLIO(wd);
    }

    public static File getDir(String name) {
        return new File(wd, name);
    }

    public static synchronized void save(Persistent pers) {
        if (saving.contains(pers)) {
            return;
        }
        saving.add(pers);
        Element elem = pers.toXML();
        String expected = XMLFactory.getElementName(pers.getClass());
        if (!elem.getName().equals(expected)) {
            throw new IllegalStateException("object does not produce XML as it said to XMLFactory (expected name: " + expected + " was: " + elem.getName() + ")");
        }
        try {
            io.save(elem, pers, PersistenceManager.getID(pers));
        }
        catch (IOException e) {
            ExceptionHandler.die("probl\u00e9me sauvegarde de " + pers, e);
        }
        saving.remove(pers);
    }

    public static void save(List<? extends Persistent> pers) throws IOException {
        io.setAutoCommit(false);
        for (Persistent persistent : pers) {
            PersistenceManager.save(persistent);
        }
        io.setAutoCommit(true);
    }

    public static void delete(Persistent p) throws IOException {
        io.delete(p.getClass(), PersistenceManager.getID(p));
    }

    public static void delete(Collection<? extends Persistent> c) throws IOException {
        for (Persistent persistent : c) {
            PersistenceManager.delete(persistent);
        }
    }

    public static void deleteAll() throws IOException {
        io.deleteAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Persistent loadFromID(Class<?> clazz, String id) {
        Persistent obj = PersistenceManager.get(id);
        if (obj != null) return obj;
        Class<PersistenceManager> clazz2 = PersistenceManager.class;
        synchronized (PersistenceManager.class) {
            if (stubs.get(id) != null) return stubs.get(id);
            idsStack.push(id);
            try {
                Element elem = (Element)io.load(clazz, id);
                if (elem == null) {
                    throw new IllegalArgumentException("persistent id " + id + " of class " + clazz + " not found.");
                }
                obj = (Persistent)XMLFactory.fromXML(elem);
                idMap.put(id, obj);
            }
            catch (IOException e) {
                throw ExceptionHandler.die("probl\u00e8me lecture", e);
            }
            idsStack.pop();
            stubs.remove(id);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return obj;
        }
    }

    public static List<Persistent> load(Class<?> clazz) {
        Set<String> ids;
        try {
            ids = io.getIDs(clazz);
        }
        catch (IOException e) {
            throw ExceptionHandler.die("probl\u00e8me lecture", e);
        }
        return PersistenceManager.load(clazz, ids);
    }

    private static List<Persistent> load(Class<?> clazz, Collection<String> ids) {
        ArrayList<Persistent> result = new ArrayList<Persistent>(ids.size());
        for (String id : ids) {
            Persistent pers = PersistenceManager.get(id) == null ? PersistenceManager.loadFromID(clazz, id) : PersistenceManager.get(id);
            result.add(pers);
        }
        return result;
    }

    public static Map<Class<?>, List<Persistent>> loadAll(File rootDir) {
        Map<Class<?>, Set<String>> mm;
        SingleXMLIO pio = new SingleXMLIO(rootDir);
        try {
            mm = pio.getIDs();
        }
        catch (IOException e) {
            throw ExceptionHandler.die("probl\u00e8me lecture", e);
        }
        HashMap res = new HashMap();
        for (Map.Entry<Class<?>, Set<String>> e : mm.entrySet()) {
            Class<?> clazz = e.getKey();
            res.put(clazz, PersistenceManager.load(clazz, (Collection<String>)e.getValue()));
        }
        return res;
    }

    public static synchronized void unload() {
        io.unload();
    }

    private static synchronized String getID(Persistent obj) {
        String id = (String)idMap.getKey(obj);
        if (id == null) {
            id = String.valueOf(System.currentTimeMillis()) + "." + r.nextLong();
            idMap.put(id, obj);
        }
        return id;
    }

    private static synchronized Persistent get(String id) {
        return (Persistent)idMap.get(id);
    }

    public static synchronized void putStub(Persistent pers) {
        String id = idsStack.peek();
        stubs.put(id, pers);
    }
}

