/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import org.openconcerto.utils.cc.ITransformerExn;

public class ConcurrentUtils {
    private static final Runnable NOOP_RUNNABLE = () -> {};
    private static final Callable<Object> NOOP_CALLABLE = () -> null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean runLocked(Object first, Object second, Runnable run) {
        Object o2;
        Object o1;
        int oHash;
        if (second == first) {
            return false;
        }
        int thisHash = System.identityHashCode(first);
        if (thisHash < (oHash = System.identityHashCode(second))) {
            o1 = first;
            o2 = second;
        } else if (thisHash > oHash) {
            o1 = second;
            o2 = first;
        } else {
            throw new IllegalStateException("Hash equal");
        }
        Object object = o1;
        synchronized (object) {
            Object object2 = o2;
            synchronized (object2) {
                run.run();
            }
        }
        return true;
    }

    public static final Runnable getNoOpRunnable() {
        return NOOP_RUNNABLE;
    }

    public static final <T> Callable<T> getNoOpCallable() {
        return NOOP_CALLABLE;
    }

    public static <A, U> CompletableFuture<U> thenApply(CompletableFuture<A> cs, ITransformerExn<? super A, ? extends U, ?> func) {
        return cs.thenCompose(ConcurrentUtils.composable(func));
    }

    public static <A, U> Function<A, CompletionStage<U>> composable(ITransformerExn<? super A, ? extends U, ?> func) {
        return a -> {
            CompletableFuture res = new CompletableFuture();
            try {
                res.complete(func.transformChecked((Object)a));
            }
            catch (Throwable ex) {
                res.completeExceptionally(ex);
            }
            return res;
        };
    }

    public static Executor executor(Supplier<? extends CompletionStage<?>> supplier) {
        return r -> {
            CompletionStage<Void> completionStage = ((CompletionStage)supplier.get()).thenRun(r);
        };
    }

    private ConcurrentUtils() {
    }
}

