/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int subminor;

    public static final Version parse(String version) {
        int subminorVers;
        int minorVers;
        int firstDot = version.indexOf(46);
        if (firstDot < 0) {
            return new Version(Integer.parseInt(version), 0, 0);
        }
        int majorVers = Integer.parseInt(version.substring(0, firstDot));
        int secondDot = version.indexOf(46, firstDot + 1);
        if (secondDot < 0) {
            minorVers = Integer.parseInt(version.substring(firstDot + 1));
            subminorVers = 0;
        } else {
            minorVers = Integer.parseInt(version.substring(firstDot + 1, secondDot));
            subminorVers = Integer.parseInt(version.substring(secondDot + 1));
        }
        return new Version(majorVers, minorVers, subminorVers);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int subminor) {
        this.major = major;
        this.minor = minor;
        this.subminor = subminor;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getSubminor() {
        return this.subminor;
    }

    public final boolean meetsMinimum(int major, int minor, int subminor) {
        return this.compareTo(major, minor, subminor) >= 0;
    }

    @Override
    public final int compareTo(Version o) {
        return this.compareTo(o.getMajor(), o.getMinor(), o.getSubminor());
    }

    public final int compareTo(int major, int minor, int subminor) {
        int res = Integer.compare(this.getMajor(), major);
        if (res != 0) {
            return res;
        }
        res = Integer.compare(this.getMinor(), minor);
        if (res != 0) {
            return res;
        }
        return Integer.compare(this.getSubminor(), subminor);
    }

    public final String format() {
        return String.valueOf(String.valueOf(this.getMajor())) + '.' + this.getMinor() + '.' + this.getSubminor();
    }

    public String toString() {
        return "v" + this.format();
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.subminor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return this.major == other.major && this.minor == other.minor && this.subminor == other.subminor;
    }
}

