/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

public class TypeToken<T> {
    private final Type type;
    private final int hashCode;

    protected TypeToken() {
        this.type = this.getTypeTokenTypeArgument();
        this.hashCode = this.type.hashCode();
    }

    private TypeToken(Type type) {
        this.type = Objects.requireNonNull(type);
        this.hashCode = this.type.hashCode();
    }

    private Type getTypeTokenTypeArgument() {
        return TypeToken.getTypeTokenTypeArgument(this.getClass(), TypeToken.class);
    }

    public static final Type getTypeTokenTypeArgument(Class<?> cl, Class<?> rawSuperClass) {
        Type superclass = cl.getGenericSuperclass();
        if (superclass instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)superclass;
            if (parameterized.getRawType() == rawSuperClass) {
                return parameterized.getActualTypeArguments()[0];
            }
        } else if (superclass == rawSuperClass) {
            throw new IllegalStateException("Must be created with a type argument: new " + rawSuperClass.getSimpleName() + "<...>() {};" + " When using code shrinkers (ProGuard, R8, ...) make sure that generic signatures are preserved.");
        }
        throw new IllegalStateException("Must only create direct subclasses of " + rawSuperClass.getSimpleName());
    }

    public final Type getType() {
        return this.type;
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object o) {
        return o instanceof TypeToken && this.type.equals(((TypeToken)o).type);
    }

    public final String toString() {
        return "TypeToken for " + this.type.toString();
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken(type);
    }

    public static <T> TypeToken<T> get(Class<T> type) {
        return new TypeToken<T>(type);
    }
}

