/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.panel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.erp.panel.SelectableSQLRowValues;

public abstract class SelectableSQLRowValuesTableModel
extends AbstractTableModel {
    protected final List<SelectableSQLRowValues> rows = new ArrayList<SelectableSQLRowValues>();

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SelectableSQLRowValues row = this.rows.get(rowIndex);
        if (columnIndex == 0) {
            return row.isSelected();
        }
        return this.getValueAtColumn(columnIndex, row);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        SelectableSQLRowValues row = this.rows.get(rowIndex);
        if (columnIndex == 0) {
            row.setSelected(Boolean.TRUE.equals(aValue));
        } else {
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return true;
        }
        return super.isCellEditable(rowIndex, columnIndex);
    }

    protected abstract Object getValueAtColumn(int var1, SelectableSQLRowValues var2);

    public void reload(final Map<String, Object> parameters) {
        SwingWorker<List<SelectableSQLRowValues>, Object> worker = new SwingWorker<List<SelectableSQLRowValues>, Object>(){

            @Override
            protected List<SelectableSQLRowValues> doInBackground() throws Exception {
                return SelectableSQLRowValuesTableModel.this.fetchRows(parameters);
            }

            @Override
            protected void done() {
                try {
                    List result = (List)this.get();
                    SelectableSQLRowValuesTableModel.this.rows.clear();
                    SelectableSQLRowValuesTableModel.this.rows.addAll(result);
                    SelectableSQLRowValuesTableModel.this.fireTableDataChanged();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    public abstract List<SelectableSQLRowValues> fetchRows(Map<String, Object> var1);

    public List<SelectableSQLRowValues> getRows() {
        return Collections.unmodifiableList(this.rows);
    }

    public List<Integer> getSelectedIndexes() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int size = this.rows.size();
        int i = 0;
        while (i < size) {
            SelectableSQLRowValues r = this.rows.get(i);
            if (r.isSelected()) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public List<SelectableSQLRowValues> getSelectedRows() {
        ArrayList<SelectableSQLRowValues> result = new ArrayList<SelectableSQLRowValues>();
        int size = this.rows.size();
        int i = 0;
        while (i < size) {
            SelectableSQLRowValues r = this.rows.get(i);
            if (r.isSelected()) {
                result.add(r);
            }
            ++i;
        }
        return result;
    }

    public void clearSelection() {
        for (SelectableSQLRowValues selectableSQLRowValues : this.rows) {
            selectableSQLRowValues.setSelected(false);
        }
        this.fireTableDataChanged();
    }

    public SelectableSQLRowValues getRowAt(int i) {
        return this.rows.get(i);
    }
}

