/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class TotalAcompteProvider
implements SpreadSheetCellValueProvider {
    private final TypeTotalAcompteProvider type;
    private final boolean old;
    private final boolean remain;

    public TotalAcompteProvider(TypeTotalAcompteProvider t, boolean old) {
        this(t, old, false);
    }

    public TotalAcompteProvider(TypeTotalAcompteProvider t, boolean old, boolean remain) {
        this.type = t;
        this.old = old;
        this.remain = remain;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        Calendar c = row.getDate("DATE");
        Collection<? extends SQLRowAccessor> rows = row.getReferentRows(row.getTable().getTable("TR_COMMANDE_CLIENT"));
        long total = 0L;
        HashSet<SQLRowAccessor> facture = new HashSet<SQLRowAccessor>();
        long totalCommande = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            SQLRowAccessor foreign = sQLRowAccessor.getForeign("ID_COMMANDE_CLIENT");
            if (foreign != null && !foreign.isUndefined()) {
                totalCommande = this.type == TypeTotalAcompteProvider.TTC ? (totalCommande += foreign.getLong("T_TTC")) : (totalCommande += foreign.getLong("T_HT"));
            }
            total += this.getPreviousAcompte(foreign, facture, c, row);
        }
        if (this.remain) {
            return new BigDecimal(totalCommande - total).movePointLeft(2);
        }
        return new BigDecimal(total).movePointLeft(2);
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.remains.cumul", new TotalAcompteProvider(TypeTotalAcompteProvider.HT, true, true));
        SpreadSheetCellValueProviderManager.put("sales.account.remains.cumul.ttc", new TotalAcompteProvider(TypeTotalAcompteProvider.TTC, true, true));
        SpreadSheetCellValueProviderManager.put("sales.account.remains", new TotalAcompteProvider(TypeTotalAcompteProvider.HT, false, true));
        SpreadSheetCellValueProviderManager.put("sales.account.remains.ttc", new TotalAcompteProvider(TypeTotalAcompteProvider.TTC, false, true));
        SpreadSheetCellValueProviderManager.put("sales.account.total.cumul", new TotalAcompteProvider(TypeTotalAcompteProvider.HT, true, false));
        SpreadSheetCellValueProviderManager.put("sales.account.total.cumul.ttc", new TotalAcompteProvider(TypeTotalAcompteProvider.TTC, true, false));
        SpreadSheetCellValueProviderManager.put("sales.account.total", new TotalAcompteProvider(TypeTotalAcompteProvider.HT, false, false));
        SpreadSheetCellValueProviderManager.put("sales.account.total.ttc", new TotalAcompteProvider(TypeTotalAcompteProvider.TTC, false, false));
    }

    public long getPreviousAcompte(SQLRowAccessor sqlRowAccessor, Set<SQLRowAccessor> alreadyAdded, Calendar c, SQLRowAccessor origin) {
        if (sqlRowAccessor == null || sqlRowAccessor.isUndefined()) {
            return 0L;
        }
        Collection<? extends SQLRowAccessor> rows = sqlRowAccessor.getReferentRows(sqlRowAccessor.getTable().getTable("TR_COMMANDE_CLIENT"));
        long l = 0L;
        for (SQLRowAccessor sQLRowAccessor : rows) {
            boolean oldFact;
            SQLRowAccessor rowFact = sQLRowAccessor.getForeign("ID_SAISIE_VENTE_FACTURE");
            boolean sameFact = rowFact.getDate("DATE").equals(c) && rowFact.getID() < origin.getID();
            boolean bl = oldFact = rowFact.getID() == origin.getID() && this.old;
            if (rowFact == null || rowFact.isUndefined() || alreadyAdded.contains(rowFact) || !rowFact.getDate("DATE").before(c) && !sameFact && !oldFact) continue;
            alreadyAdded.add(rowFact);
            l += this.type == TypeTotalAcompteProvider.HT ? rowFact.getLong("T_HT") : rowFact.getLong("T_TTC");
        }
        return l;
    }

    public static enum TypeTotalAcompteProvider {
        HT,
        TTC;

    }
}

