/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.List;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.DecimalUtils;

public class RecapLigneFactureProvider
implements SpreadSheetCellValueProvider {
    private final TypeLineRecapFactureProvider type;
    private final boolean old;
    private final boolean withAvoir;

    public RecapLigneFactureProvider(TypeLineRecapFactureProvider t, boolean old) {
        this(t, old, false);
    }

    public RecapLigneFactureProvider(TypeLineRecapFactureProvider t, boolean old, boolean withAvoir) {
        this.type = t;
        this.old = old;
        this.withAvoir = withAvoir;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        SQLRowAccessor factureOrigin = row.getNonEmptyForeign("ID_SAISIE_VENTE_FACTURE");
        Calendar date = factureOrigin.getDate("DATE");
        SQLRowAccessor foreignCmdItem = row.getNonEmptyForeign("ID_COMMANDE_CLIENT_ELEMENT");
        if (foreignCmdItem != null && foreignCmdItem.getBigDecimal("T_PV_HT").signum() != 0) {
            SQLRowValues rowValsFactItem2Fetch = new SQLRowValues(row.getTable());
            rowValsFactItem2Fetch.putNulls("T_PV_HT", "T_PV_TTC");
            rowValsFactItem2Fetch.putRowValues("ID_SAISIE_VENTE_FACTURE").putNulls("DATE", "ID_AVOIR_CLIENT");
            List<SQLRowValues> fetch = SQLRowValuesListFetcher.create(rowValsFactItem2Fetch).fetch(new Where((FieldRef)row.getTable().getField("ID_COMMANDE_CLIENT_ELEMENT"), "=", foreignCmdItem.getID()));
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal totalTTC = BigDecimal.ZERO;
            for (SQLRowAccessor sQLRowAccessor : fetch) {
                boolean same;
                SQLRowAccessor nonEmptyForeign = sQLRowAccessor.getNonEmptyForeign("ID_SAISIE_VENTE_FACTURE");
                if (nonEmptyForeign == null || this.withAvoir && (!this.withAvoir || !sQLRowAccessor.isForeignEmpty("ID_AVOIR_CLIENT"))) continue;
                Calendar date2 = nonEmptyForeign.getDate("DATE");
                boolean bl = same = this.old && factureOrigin.getID() == nonEmptyForeign.getID();
                if (!same && !date2.before(date) && (!date2.equals(date) || nonEmptyForeign.getID() >= factureOrigin.getID())) continue;
                total = total.add(sQLRowAccessor.getBigDecimal("T_PV_HT"));
                totalTTC = totalTTC.add(sQLRowAccessor.getBigDecimal("T_PV_TTC"));
            }
            if (this.type == TypeLineRecapFactureProvider.HT) {
                return total;
            }
            if (this.type == TypeLineRecapFactureProvider.TTC) {
                return totalTTC;
            }
            if (foreignCmdItem.getBigDecimal("T_PV_HT").signum() != 0) {
                return total.divide(foreignCmdItem.getBigDecimal("T_PV_HT"), DecimalUtils.HIGH_PRECISION).movePointRight(2).setScale(2, RoundingMode.HALF_UP) + "%";
            }
            return "";
        }
        return "";
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("sales.account.line.history", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.HT, false));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.ttc", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.TTC, false));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.percent", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.PERCENT, false));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.total", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.HT, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.total.ttc", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.TTC, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.total.percent", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.PERCENT, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.with.credit", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.HT, false, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.with.credit.ttc", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.TTC, false, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.with.credit.percent", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.PERCENT, false, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.with.credit.total", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.HT, true, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.with.credit.total.ttc", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.TTC, true, true));
        SpreadSheetCellValueProviderManager.put("sales.account.line.history.with.credit.total.percent", new RecapLigneFactureProvider(TypeLineRecapFactureProvider.PERCENT, true, true));
    }

    private static enum TypeLineRecapFactureProvider {
        HT,
        TTC,
        PERCENT;

    }
}

