/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc;

import java.awt.GraphicsEnvironment;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JOptionPane;
import org.jopendocument.link.Component;
import org.jopendocument.model.OpenDocument;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.PreviewFrame;
import org.openconcerto.erp.core.customerrelationship.mail.EmailTemplate;
import org.openconcerto.erp.core.customerrelationship.mail.ValueListener;
import org.openconcerto.erp.generationDoc.AbstractSheetXml;
import org.openconcerto.erp.generationDoc.DefaultNXDocumentPrinter;
import org.openconcerto.erp.generationDoc.MetaDataSheet;
import org.openconcerto.erp.generationDoc.SheetUtils;
import org.openconcerto.erp.generationDoc.element.TypeModeleSQLElement;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.storage.CloudStorageEngine;
import org.openconcerto.erp.storage.StorageEngine;
import org.openconcerto.erp.storage.StorageEngines;
import org.openconcerto.openoffice.OOUtils;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.EditPanel;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.Action;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.Grammar;
import org.openconcerto.utils.i18n.TranslationManager;

public abstract class SheetXml {
    private ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>> postProcess = null;
    private boolean refreshFormulasRequired = false;
    private static StorageDirs STORAGE_DIRS;
    public static final String DEFAULT_PROPERTY_NAME = "Default";
    protected SQLElement elt;
    protected String printer;
    protected SQLRow row;
    protected SQLRow rowLanguage;
    protected static final SQLBase base;
    protected static final ExecutorService runnableQueue;
    protected static Thread.UncaughtExceptionHandler DEFAULT_HANDLER;
    MetaDataSheet meta;

    static {
        base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        runnableQueue = new ThreadPoolExecutor(0, 1, 3L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread res = new Thread(r);
                res.setUncaughtExceptionHandler(DEFAULT_HANDLER);
                return res;
            }
        });
        DEFAULT_HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ExceptionHandler.handle("Erreur de generation", e);
            }
        };
    }

    public ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>> getPostProcess() {
        return this.postProcess;
    }

    public void setPostProcess(ITransformer<List<SQLRowAccessor>, List<SQLRowAccessor>> postProcess) {
        this.postProcess = postProcess;
    }

    public static void setStorageDirs(StorageDirs d) {
        STORAGE_DIRS = d;
    }

    public final SQLElement getElement() {
        return this.elt;
    }

    public Future<SheetXml> showPrintAndExportAsynchronous(boolean showDocument, boolean printDocument, boolean exportToPDF) {
        return this.showPrintAndExportAsynchronous(showDocument, printDocument, exportToPDF, Collections.emptyList());
    }

    public Future<SheetXml> showPrintAndExportAsynchronous(final boolean showDocument, final boolean printDocument, final boolean exportToPDF, final List<Action> actions) {
        Callable<SheetXml> c = new Callable<SheetXml>(){

            @Override
            public SheetXml call() throws Exception {
                SheetXml.this.showPrintAndExport(showDocument, printDocument, exportToPDF, actions);
                return SheetXml.this;
            }
        };
        return runnableQueue.submit(c);
    }

    public Future<SheetXml> showPrintAndExportAsynchronous(final boolean showDocument, final boolean printDocument, final boolean exportToPDF, final SQLElement element, final SQLRow row) {
        Callable<SheetXml> c = new Callable<SheetXml>(){

            @Override
            public SheetXml call() throws Exception {
                ArrayList<Action> actions = new ArrayList<Action>();
                if (SheetXml.this instanceof AbstractSheetXml) {
                    final SQLTable table = element.getTable();
                    Action emailAction = new Action(TranslationManager.getInstance().getTranslationForAction("document.pdf.send.email")){

                        @Override
                        public void run(Object source) {
                            EmailTemplate.askTemplate((java.awt.Component)source, table.getDBRoot(), table.getName(), new ValueListener(){

                                @Override
                                public void valueSelected(Object value) {
                                    MouseSheetXmlListeListener l = new MouseSheetXmlListeListener(element, ((AbstractSheetXml)SheetXml.this).getClass());
                                    l.sendMail((EmailTemplate)value, (AbstractSheetXml)SheetXml.this, true);
                                }
                            });
                        }
                    };
                    actions.add(emailAction);
                }
                Action modifyAction = new Action(String.valueOf(TranslationManager.getInstance().getTranslationForAction("modify")) + " " + element.getName().getVariant(Grammar.DEFINITE_ARTICLE_SINGULAR)){

                    @Override
                    public void run(Object source) {
                        if (source instanceof PreviewFrame) {
                            ((PreviewFrame)source).dispose();
                        }
                        SQLComponent component = element.createDefaultComponent();
                        EditFrame f = new EditFrame(component, EditPanel.EditMode.MODIFICATION);
                        f.selectionId(row.getID());
                        FrameUtil.show(f);
                    }
                };
                actions.add(modifyAction);
                if (element != null && element instanceof ComptaSQLConfElement) {
                    List<Tuple2<String, BiConsumer<SQLRowAccessor, Object>>> previewPanelActions = ((ComptaSQLConfElement)element).getPreviewPanelActions();
                    for (final Tuple2<String, BiConsumer<SQLRowAccessor, Object>> action : previewPanelActions) {
                        actions.add(new Action(action.get0()){

                            @Override
                            public void run(Object source) {
                                ((BiConsumer)action.get1()).accept(row, source);
                            }
                        });
                    }
                }
                SheetXml.this.showPrintAndExport(showDocument, printDocument, exportToPDF, actions);
                return SheetXml.this;
            }
        };
        return runnableQueue.submit(c);
    }

    public static Future<?> submitInQueue(Runnable r) {
        return runnableQueue.submit(r);
    }

    public void showPrintAndExport(boolean showDocument, boolean printDocument, boolean exportToPDF) {
        this.showPrintAndExport(showDocument, printDocument, exportToPDF, Boolean.getBoolean("org.openconcerto.oo.useODSViewer"), false, Collections.emptyList());
    }

    public void showPrintAndExport(boolean showDocument, boolean printDocument, boolean exportToPDF, List<Action> actions) {
        this.showPrintAndExport(showDocument, printDocument, exportToPDF, Boolean.getBoolean("org.openconcerto.oo.useODSViewer"), false, actions);
    }

    public void showPrintAndExport(boolean showDocument, boolean printDocument, boolean exportToPDF, boolean useODSViewer, boolean exportPDFSynch) {
        this.showPrintAndExport(showDocument, printDocument, exportToPDF, useODSViewer, exportPDFSynch, Collections.emptyList());
    }

    public void showPrintAndExport(boolean showDocument, boolean printDocument, boolean exportToPDF, boolean useODSViewer, boolean exportPDFSynch, List<Action> actions) {
        final File generatedFile = this.getGeneratedFile();
        final File pdfFile = this.getGeneratedPDFFile();
        if (generatedFile == null || !generatedFile.exists()) {
            JOptionPane.showMessageDialog(null, "Fichier g\u00e9n\u00e9r\u00e9 manquant : " + generatedFile);
            return;
        }
        try {
            if (!useODSViewer) {
                if (exportToPDF || printDocument) {
                    Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(generatedFile, !showDocument);
                    if (printDocument) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("Name", this.printer);
                        doc.printDocument(map);
                    }
                    if (exportToPDF) {
                        doc.saveToPDF(pdfFile).get();
                    }
                    if (!showDocument) {
                        doc.close();
                    }
                } else {
                    this.openDocument(false);
                }
            } else {
                final OpenDocument doc = new OpenDocument(generatedFile);
                if (showDocument) {
                    this.showPreviewDocument(actions);
                }
                if (printDocument) {
                    DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                    printer.print(Arrays.asList(doc));
                }
                if (exportToPDF) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            SheetXml.this.createPDF(generatedFile, pdfFile, doc, SheetXml.this.getStoragePath());
                        }
                    }, "convert and upload to pdf");
                    t.setDaemon(true);
                    t.start();
                    if (exportPDFSynch) {
                        t.join();
                    }
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de charger le document OpenOffice " + pdfFile.getAbsolutePath() + "(viewer : " + useODSViewer + ")", e);
        }
    }

    public void setMetaGeneration(MetaDataSheet meta) {
        this.meta = meta;
    }

    public MetaDataSheet getMetaGeneration() {
        return this.meta;
    }

    public void createPDF(File generatedFile, File pdfFile, OpenDocument doc, String storagePath) {
        if (pdfFile == null) {
            throw new IllegalArgumentException("null PDF file");
        }
        try {
            SheetUtils.convert2PDF(doc, pdfFile);
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible de cr\u00e9er le PDF " + pdfFile.getAbsolutePath(), e);
        }
        if (!pdfFile.canRead()) {
            ExceptionHandler.handle("Le fichier PDF " + pdfFile.getAbsolutePath() + " ne peut \u00eatre lu.");
        }
        this.storeWithStorageEngines(generatedFile, pdfFile, storagePath);
    }

    protected void storeWithStorageEngines(File generatedFile, File pdfFile, String storagePath) {
        List<StorageEngine> engines = StorageEngines.getInstance().getActiveEngines();
        for (StorageEngine storageEngine : engines) {
            BufferedInputStream inStream;
            if (!storageEngine.isConfigured() || !storageEngine.allowAutoStorage()) continue;
            String path = storagePath;
            try {
                storageEngine.connect();
                inStream = new BufferedInputStream(new FileInputStream(pdfFile));
                storageEngine.store(inStream, path, pdfFile.getName(), true);
                inStream.close();
                storageEngine.disconnect();
            }
            catch (IOException e) {
                ExceptionHandler.handle("Impossible de sauvegarder le PDF " + pdfFile.getAbsolutePath() + " vers " + path + "(" + storageEngine + ")", e);
            }
            if (!(storageEngine instanceof CloudStorageEngine)) continue;
            try {
                File odsp;
                storageEngine.connect();
                inStream = new BufferedInputStream(new FileInputStream(generatedFile));
                storageEngine.store(inStream, path, generatedFile.getName(), true);
                inStream.close();
                if (generatedFile.getName().endsWith(".ods") && (odsp = new File(generatedFile.getParent(), String.valueOf(generatedFile.getName()) + "p")).exists()) {
                    BufferedInputStream inStreamODSP = new BufferedInputStream(new FileInputStream(odsp));
                    storageEngine.store(inStreamODSP, path, odsp.getName(), true);
                    inStreamODSP.close();
                }
                storageEngine.disconnect();
            }
            catch (IOException e) {
                ExceptionHandler.handle("Impossible de sauvegarder le fichier g\u00e9n\u00e9r\u00e9 " + generatedFile.getAbsolutePath() + " vers " + path + "(" + storageEngine + ")", e);
            }
        }
    }

    public abstract String getDefaultTemplateId();

    public final String getStoragePath() {
        String res;
        String string = res = STORAGE_DIRS == null ? null : STORAGE_DIRS.getStoragePath(this);
        if (res != null) {
            return res;
        }
        return this.getStoragePathP();
    }

    public final File getDocumentOutputDirectory() {
        File res;
        File file = res = STORAGE_DIRS == null ? null : STORAGE_DIRS.getDocumentOutputDirectory(this);
        if (res != null) {
            return res;
        }
        return this.getDocumentOutputDirectoryP();
    }

    public final File getPDFOutputDirectory() {
        File res;
        File file = res = STORAGE_DIRS == null ? null : STORAGE_DIRS.getPDFOutputDirectory(this);
        if (res != null) {
            return res;
        }
        return this.getPDFOutputDirectoryP();
    }

    protected abstract String getStoragePathP();

    protected abstract File getDocumentOutputDirectoryP();

    protected abstract File getPDFOutputDirectoryP();

    public abstract String getName();

    public String getTemplateId() {
        if (this.row != null && this.row.getTable().getFieldsName().contains("ID_MODELE")) {
            if (this.row.getObject("ID_MODELE") == null || this.row.isForeignEmpty("ID_MODELE")) {
                TypeModeleSQLElement typeModele = Configuration.getInstance().getDirectory().getElement(TypeModeleSQLElement.class);
                String modele = typeModele.getTemplateMapping().get(this.row.getTable().getName());
                if (modele == null) {
                    System.err.println("No default modele in table TYPE_MODELE for table " + this.row.getTable().getName());
                    Thread.dumpStack();
                    return this.getDefaultTemplateId();
                }
                return modele;
            }
            SQLRow rowModele = this.row.getForeignRow("ID_MODELE");
            return rowModele.getString("NOM");
        }
        return this.getDefaultTemplateId();
    }

    public abstract Future<SheetXml> createDocumentAsynchronous();

    public void createDocument() throws InterruptedException, ExecutionException {
        this.createDocumentAsynchronous().get();
    }

    public abstract File getGeneratedFile();

    public File getGeneratedPDFFile() {
        return SheetUtils.getFileWithExtension(this.getGeneratedFile(), ".pdf");
    }

    public SQLRow getRowLanguage() {
        return this.rowLanguage;
    }

    public String getReference() {
        return "";
    }

    public File getOrCreateDocumentFile() throws Exception {
        File f = this.getGeneratedFile();
        if (!f.exists()) {
            return this.createDocumentAsynchronous().get().getGeneratedFile();
        }
        return f;
    }

    public File getOrCreatePDFDocumentFile(boolean createRecent) throws Exception {
        return this.getOrCreatePDFDocumentFile(createRecent, Boolean.getBoolean("org.openconcerto.oo.useODSViewer"));
    }

    public File getOrCreatePDFDocumentFile(boolean createRecent, boolean useODSViewer) throws Exception {
        File f = this.getGeneratedPDFFile();
        if (!f.exists()) {
            this.getOrCreateDocumentFile();
            this.showPrintAndExport(false, false, true, useODSViewer, true, Collections.emptyList());
            return f;
        }
        File fODS = this.getOrCreateDocumentFile();
        if (fODS.lastModified() > f.lastModified()) {
            this.showPrintAndExport(false, false, true, useODSViewer, true, Collections.emptyList());
        }
        return f;
    }

    public void openDocument(boolean synchronous) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        File f = SheetXml.this.getOrCreateDocumentFile();
                        if (f != null && f.exists()) {
                            OOUtils.open((File)f);
                            break block7;
                        }
                        if (!GraphicsEnvironment.isHeadless()) {
                            if (f != null) {
                                JOptionPane.showMessageDialog(null, "Le fichier " + f.getAbsolutePath() + " est manquant");
                            } else {
                                JOptionPane.showMessageDialog(null, "Fichier manquant");
                            }
                            break block7;
                        }
                        if (f != null) {
                            throw new FileNotFoundException(String.valueOf(f.getAbsolutePath()) + " missing");
                        }
                        throw new NullPointerException("null document");
                    }
                    catch (Exception e) {
                        ExceptionHandler.handle("Impossible d'ouvrir le document.", e);
                    }
                }
            }
        };
        if (synchronous) {
            r.run();
        } else {
            Thread thread = new Thread(r, "openDocument: " + this.getGeneratedFile().getAbsolutePath());
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void showPreviewDocument() throws Exception {
        this.showPreviewDocument(Collections.emptyList());
    }

    public void showPreviewDocument(List<Action> actions) throws Exception {
        File f = null;
        f = this.getOrCreateDocumentFile();
        PreviewFrame.show(f, actions);
    }

    public void printDocument() {
        this.printDocument(null, null);
    }

    public void printDocument(PrinterJob job, HashPrintRequestAttributeSet attributes) {
        try {
            File f = this.getOrCreateDocumentFile();
            if (!Boolean.getBoolean("org.openconcerto.oo.useODSViewer")) {
                Component doc = ComptaPropsConfiguration.getOOConnexion().loadDocument(f, true);
                doc.printDocument(job);
                doc.close();
            } else {
                OpenDocument doc = new OpenDocument(f);
                DefaultNXDocumentPrinter prt = new DefaultNXDocumentPrinter();
                prt.print(Arrays.asList(doc), job, attributes);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle("Impossible d'imprimer le document OpenOffice", e);
            e.printStackTrace();
        }
    }

    public SQLRow getSQLRow() {
        return this.row;
    }

    public static String getValidFileName(String fileName) {
        StringBuffer result = new StringBuffer(fileName.length());
        int i = 0;
        while (i < fileName.length()) {
            char ch = fileName.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_' || ch == ' ') {
                result.append(ch);
            } else {
                result.append('-');
            }
            ++i;
        }
        return result.toString();
    }

    public String getPrinter() {
        return this.printer;
    }

    public void setRefreshFormulasRequired(boolean refreshFormulasRequired) {
        this.refreshFormulasRequired = refreshFormulasRequired;
    }

    public boolean isRefreshFormulasRequired() {
        return this.refreshFormulasRequired;
    }

    public static interface StorageDirs {
        public File getDocumentOutputDirectory(SheetXml var1);

        public File getPDFOutputDirectory(SheetXml var1);

        public String getStoragePath(SheetXml var1);
    }
}

