/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openconcerto.erp.core.sales.pos.io.Printable;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.ArticleCache;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.model.RegisterFiles;
import org.openconcerto.erp.core.sales.pos.model.TarifQuantite;
import org.openconcerto.erp.core.sales.pos.model.Ticket;
import org.openconcerto.erp.core.sales.pos.model.TicketItem;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSearchPanel;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelectorPanel;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseFrame;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.PaiementPanel;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.erp.core.sales.pos.ui.TicketPanel;
import org.openconcerto.erp.core.supplychain.stock.element.StockSQLElement;
import org.openconcerto.erp.preferences.TemplateNXProps;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.FileUtils;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class CaissePanel
extends JPanel
implements CaisseListener {
    public static final Color LIGHT_BLUE = new Color(83, 129, 172);
    public static final Color DARK_BLUE = new Color(0, 98, 159);
    private CaisseControler controler;
    private StatusBar st;
    private ArticleSelectorPanel articleSelectorPanel;
    private ArticleSearchPanel articleSearchPanel;
    private JPanel selector;
    final SQLElementDirectory dir;

    public CaissePanel(CaisseFrame caisseFrame) throws Exception {
        this.dir = caisseFrame.getConf().getDirectory();
        this.loadArticles(this.dir);
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.WHITE);
        this.setOpaque(this.isOpaque());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.controler = new CaisseControler(caisseFrame);
        c.fill = 2;
        this.st = this.createStatusBar(caisseFrame);
        this.add((Component)this.st, c);
        TicketPanel t = new TicketPanel(this.controler);
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.anchor = 16;
        c.fill = 0;
        this.add((Component)t, c);
        c.fill = 1;
        ++c.gridx;
        c.gridy = 0;
        c.weightx = 1.0;
        c.gridheight = 2;
        this.articleSelectorPanel = new ArticleSelectorPanel(this.controler);
        this.articleSearchPanel = new ArticleSearchPanel(this.controler);
        this.selector = this.articleSelectorPanel;
        this.add((Component)this.selector, c);
        ++c.gridx;
        c.weightx = 0.0;
        this.add((Component)new PaiementPanel(this), c);
        this.controler.addCaisseListener(this);
    }

    private StatusBar createStatusBar(final CaisseFrame caisseFrame) {
        StatusBar s = new StatusBar();
        s.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = this.controler.getPOSConf().getScreenWidth() < 1280 ? new Insets(0, 2, 0, 2) : new Insets(0, 10, 0, 10);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 0.0;
        POSButton bValidate = new POSButton("Valider");
        bValidate.setForeground(Color.WHITE);
        bValidate.setBackground(DARK_BLUE);
        s.add((Component)bValidate, c);
        c.weightx = 1.0;
        ++c.gridx;
        POSButton bClients = new POSButton("Clients");
        bClients.setForeground(Color.WHITE);
        bClients.setBackground(DARK_BLUE);
        s.add((Component)bClients, c);
        ++c.gridx;
        POSButton bMenu = new POSButton("Menu");
        bMenu.setForeground(Color.WHITE);
        bMenu.setBackground(DARK_BLUE);
        s.add((Component)bMenu, c);
        bValidate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CaissePanel.this.checkStock(CaissePanel.this.getControler().getPOSConf().getDepotID(), new Runnable(){

                    @Override
                    public void run() {
                        if (caisseFrame.getPOSConf().askPostalCode()) {
                            caisseFrame.showPostalCodeFrame(CaissePanel.this);
                        } else {
                            CaissePanel.this.validateTicket(caisseFrame);
                        }
                    }
                });
            }
        });
        bClients.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    caisseFrame.showClients();
                }
                catch (Throwable ex) {
                    ExceptionHandler.handle("Erreur d'affichage du menu", ex);
                }
            }
        });
        bMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    caisseFrame.showMenu();
                }
                catch (Throwable ex) {
                    ExceptionHandler.handle("Erreur d'affichage du menu", ex);
                }
            }
        });
        return s;
    }

    protected void checkStock(int idDepot, Runnable runnable) {
        List<TicketItem> items = this.controler.getItems();
        ArrayList<Integer> articleIds = new ArrayList<Integer>();
        HashMap<Integer, TicketItem> mapTicketItem = new HashMap<Integer, TicketItem>();
        for (TicketItem item : items) {
            articleIds.add(item.getArticle().getId());
            mapTicketItem.put(item.getArticle().getId(), item);
        }
        SQLTable stockTable = this.dir.getElement(StockSQLElement.class).getTable();
        SQLSelect selStock = new SQLSelect();
        selStock.addSelect(stockTable.getField("ID"));
        selStock.addSelect(stockTable.getField("ID_DEPOT_STOCK"));
        selStock.addSelect(stockTable.getField("QTE_REEL"));
        selStock.addSelect(stockTable.getField("ID_ARTICLE"));
        selStock.setWhere(Where.inValues(stockTable.getField("ID_ARTICLE"), articleIds).and(new Where((FieldRef)stockTable.getField("ID_DEPOT_STOCK"), "=", idDepot)));
        HashMap<TicketItem, Integer> missingQty = new HashMap<TicketItem, Integer>();
        for (SQLRow row : SQLRowListRSH.execute(selStock)) {
            int idArticle = row.getInt("ID_ARTICLE");
            int qte = Math.max(0, Math.round(row.getFloat("QTE_REEL")));
            TicketItem item = (TicketItem)mapTicketItem.get(idArticle);
            if (item == null) {
                System.err.println("Pas d'entr\u00e9e dans STOCK pour l'article " + idArticle);
                continue;
            }
            if (qte >= item.getQty().intValue()) continue;
            int delta = item.getQty().intValue() - qte;
            missingQty.put(item, delta);
        }
        if (missingQty.isEmpty()) {
            runnable.run();
        } else {
            this.getControler().openStockErrorPanel(missingQty, runnable);
        }
    }

    public Set<Integer> loadFavoriteProductsIds() {
        TemplateNXProps nxprops = (TemplateNXProps)TemplateNXProps.getInstance();
        File f = new File(nxprops.getDefaultStringValue(), "favorites.txt");
        System.out.println("CaisseControler.saveFavoriteProductsIds() loading favorites from " + f.getAbsolutePath());
        HashSet<Integer> result = new HashSet<Integer>();
        if (f.exists()) {
            try {
                String s = FileUtils.read(f);
                List<String> sIds = StringUtils.fastSplit(s, ',');
                for (String string : sIds) {
                    if (string.isEmpty()) continue;
                    result.add(Integer.parseInt(string));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void saveFavoriteProductsIds(List<Article> products) {
        TemplateNXProps nxprops = (TemplateNXProps)TemplateNXProps.getInstance();
        File f = new File(nxprops.getDefaultStringValue(), "favorites.txt");
        System.out.println("CaisseControler.saveFavoriteProductsIds() saving favorites to " + f.getAbsolutePath());
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream fOut = new FileOutputStream(f);){
                for (Article product : products) {
                    fOut.write(String.valueOf(product.getId()).getBytes());
                    fOut.write(44);
                }
                fOut.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private List<Article> loadArticles(SQLElementDirectory dir) {
        long t1 = System.currentTimeMillis();
        SQLSelect selUniteVente = new SQLSelect();
        SQLTable tableUniteVente = dir.getElement("UNITE_VENTE").getTable();
        selUniteVente.addSelect(tableUniteVente.getKey());
        selUniteVente.addSelect(tableUniteVente.getField("CODE"));
        HashMap<Integer, String> mapUniteVenteName = new HashMap<Integer, String>();
        for (SQLRow row : SQLRowListRSH.execute(selUniteVente)) {
            mapUniteVenteName.put(row.getID(), row.getString("CODE"));
        }
        Set<Integer> favoriteProductsIds = this.loadFavoriteProductsIds();
        ArrayList<Article> favoriteProducts = new ArrayList<Article>();
        HashMap<Integer, Categorie> categoriesMap = new HashMap<Integer, Categorie>();
        SQLElement eltFam = dir.getElement("FAMILLE_ARTICLE");
        SQLElement eltArticle = dir.getElement("ARTICLE");
        SQLSelect selFamille = new SQLSelect();
        selFamille.addSelectStar(eltFam.getTable());
        selFamille.addFieldOrder(eltFam.getTable().getField("CODE"));
        for (SQLRow row : SQLRowListRSH.execute(selFamille)) {
            Categorie c;
            Categorie cP = (Categorie)categoriesMap.get(row.getInt("ID_FAMILLE_ARTICLE_PERE"));
            if (cP != null) {
                c = new Categorie(row.getString("NOM"));
                cP.add(c);
            } else {
                c = new Categorie(row.getString("NOM"), true);
            }
            categoriesMap.put(row.getID(), c);
        }
        SQLSelect selArticle = new SQLSelect();
        SQLTable tableArticle = eltArticle.getTable();
        selArticle.addAllSelect(tableArticle.getFields(SQLTable.VirtualFields.PRIMARY_KEY.union(SQLTable.VirtualFields.ARCHIVE)));
        selArticle.addAllSelect(tableArticle, Arrays.asList("ID_ARTICLE_VIRTUEL_PERE", "ID_FAMILLE_ARTICLE", "NOM", "CODE", "CODE_BARRE", "ID_TAXE", "PV_HT", "PV_TTC", "ADDITIONAL_TICKET_COPY", "ID_UNITE_VENTE", "ID_ECO_CONTRIBUTION"));
        selArticle.setWhere(new Where((FieldRef)tableArticle.getField("OBSOLETE"), "=", (Object)Boolean.FALSE).and(new Where((FieldRef)tableArticle.getField("MASQUE_CAISSE"), "=", (Object)Boolean.FALSE)));
        selArticle.andWhere(new Where((FieldRef)tableArticle.getField("VIRTUEL"), "=", (Object)Boolean.FALSE));
        ArrayList<String> tablesDeclinaisons = new ArrayList<String>();
        ArrayList<String> declinaisonsFieldNames = new ArrayList<String>();
        for (SQLField f : tableArticle.getFields()) {
            if (!f.getName().startsWith("ID_ARTICLE_DECLINAISON_")) continue;
            selArticle.addSelect(f);
            declinaisonsFieldNames.add(f.getName());
            tablesDeclinaisons.add(f.getName().substring("ID_".length()));
        }
        SQLSelect selArtVirt = new SQLSelect();
        selArtVirt.addSelect(tableArticle.getKey());
        selArtVirt.addSelect(tableArticle.getField("NOM"));
        HashMap<Integer, String> mapVirtuel = new HashMap<Integer, String>();
        for (SQLRow row : SQLRowListRSH.execute(selArtVirt)) {
            mapVirtuel.put(row.getID(), row.getString("NOM"));
        }
        Categorie cUnclassified = new Categorie("Non class\u00e9s", true);
        cUnclassified.setUnknown();
        HashMap mapDeclinaisons = new HashMap();
        for (String table : tablesDeclinaisons) {
            SQLTable t = eltArticle.getTable().getTable(table);
            SQLSelect selDecl = new SQLSelect();
            selDecl.addSelect(t.getKey());
            selDecl.addSelect(t.getField("NOM"));
            selDecl.addSelect(t.getField("ORDRE"));
            HashMap<Integer, Tuple2<String, BigDecimal>> m = new HashMap<Integer, Tuple2<String, BigDecimal>>();
            mapDeclinaisons.put("ID_" + table, m);
            for (SQLRow row : SQLRowListRSH.execute(selDecl)) {
                m.put(row.getID(), Tuple2.create(row.getString("NOM"), row.getBigDecimal("ORDRE")));
            }
        }
        List<SQLRow> rArticles = SQLRowListRSH.execute(selArticle);
        ArrayList<Integer> idsArticles = new ArrayList<Integer>(rArticles.size());
        for (SQLRow r : rArticles) {
            idsArticles.add(r.getID());
        }
        SQLTable tableArticleTairdPromotion = tableArticle.getTable("ARTICLE_TARIF_PROMOTION");
        final SQLTable tableTarifPromotion = tableArticle.getTable("TARIF_PROMOTION");
        SQLRowValues rTarifPromotion = new SQLRowValues(tableArticleTairdPromotion);
        rTarifPromotion.putNulls(tableArticleTairdPromotion.getFieldsName());
        rTarifPromotion.putRowValues("ID_TARIF_PROMOTION").putNulls("START", "END");
        rTarifPromotion.putRowValues("ID_ARTICLE").putNulls("ID_TAXE");
        Where where = new Where(tableArticleTairdPromotion.getField("ID_ARTICLE"), idsArticles);
        final Calendar today = Calendar.getInstance();
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rTarifPromotion);
        fetcher.appendSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.andWhere(new Where(input.getAlias(tableTarifPromotion.getField("START")), "<", (Object)today));
                input.andWhere(new Where(input.getAlias(tableTarifPromotion.getField("END")), ">", (Object)today));
                return input;
            }
        });
        List<SQLRowValues> rPromotions = fetcher.fetch(where);
        long t1p = System.currentTimeMillis();
        HashMap mapTarif = new HashMap();
        System.err.println("CaissePanel.loadArticles()" + rPromotions.size() + " promotions");
        for (SQLRowValues r : rPromotions) {
            Integer foreignID = r.getForeignID("ID_ARTICLE");
            ArrayList<TarifQuantite> list = (ArrayList<TarifQuantite>)mapTarif.get(foreignID);
            if (list == null) {
                list = new ArrayList<TarifQuantite>();
                mapTarif.put(foreignID, list);
            }
            TarifQuantite t = new TarifQuantite(foreignID, r.getInt("QTE"), r.getBigDecimal("PV_HT"), r.getBigDecimal("PV_TTC"), r.getForeign("ID_ARTICLE").getInt("ID_TAXE"));
            list.add(t);
        }
        ArrayList<Article> res = new ArrayList<Article>(rArticles.size());
        for (SQLRow row : rArticles) {
            List promotions;
            Integer idProduct;
            Integer idUniteVente;
            String name;
            Integer idFamilleArticle = (Integer)row.getObjectNoCheck("ID_FAMILLE_ARTICLE");
            Categorie s1 = (Categorie)categoriesMap.get(idFamilleArticle);
            if (s1 == null) {
                s1 = cUnclassified;
                categoriesMap.put(idFamilleArticle, cUnclassified);
            }
            if ((name = ((String)row.getObjectNoCheck("NOM")).trim()).length() <= 0) continue;
            Article a = new Article(s1, name, row.getID());
            String barcode = (String)row.getObjectNoCheck("CODE_BARRE");
            String code = (String)row.getObjectNoCheck("CODE");
            a.setBarCode(StringUtils.isEmpty(barcode, true) ? code : barcode);
            a.setCode(code);
            a.setIdTaxe((Integer)row.getObjectNoCheck("ID_TAXE"));
            a.setPriceWithoutTax((BigDecimal)row.getObjectNoCheck("PV_HT"));
            a.setPriceWithTax((BigDecimal)row.getObjectNoCheck("PV_TTC"));
            a.setAdditionalCopyRequested((Boolean)row.getObjectNoCheck("ADDITIONAL_TICKET_COPY"));
            Integer idEcoContribution = (Integer)row.getObjectNoCheck("ID_ECO_CONTRIBUTION");
            if (idEcoContribution > 1) {
                a.setEcoTaxe((BigDecimal)row.getForeign("ID_ECO_CONTRIBUTION").getObjectNoCheck("TAUX"));
            }
            if ((idUniteVente = (Integer)row.getObjectNoCheck("ID_UNITE_VENTE")) != 2) {
                a.setSalesUnit((String)mapUniteVenteName.get(idUniteVente));
            }
            if (favoriteProductsIds.contains(idProduct = Integer.valueOf(a.getId()))) {
                favoriteProducts.add(a);
            }
            if ((promotions = (List)mapTarif.get(row.getID())) != null) {
                a.setTarifsPromotion(promotions);
                for (TarifQuantite t : promotions) {
                    if (t.getQuantite() != 1) continue;
                    a.setIdTaxe(t.getIdTaxe());
                    a.setPriceWithoutTax(t.getPrixHT());
                    a.setPriceWithTax(t.getPrixTTC());
                    break;
                }
            }
            for (String f : declinaisonsFieldNames) {
                Map mm;
                Integer idArtDeclinaison = (Integer)row.getObjectNoCheck(f);
                if (idArtDeclinaison == null || idArtDeclinaison <= 1 || (mm = (Map)mapDeclinaisons.get(f)) == null) continue;
                Tuple2 v = (Tuple2)mm.get(idArtDeclinaison);
                a.addDeclinaison(f.substring("ID_ARTICLE_DECLINAISON_".length()), (String)v.get0(), (BigDecimal)v.get1());
            }
            res.add(a);
        }
        long t2p = System.currentTimeMillis();
        Categorie.setFavoriteProducts(favoriteProducts);
        ArticleCache.initCache(dir);
        ArticleCache.getInstance().preloadCacheArticleMap(new ArrayList<Integer>(favoriteProductsIds));
        long t2 = System.currentTimeMillis();
        System.err.println("CaissePanel.loadArticles() " + res.size() + " in " + (t2 - t1) + " ms : process: " + (t2p - t1p) + " ms");
        return res;
    }

    @Override
    public void paint(Graphics g) {
        boolean minimalHeight;
        System.err.println("CaissePanel.paint()" + this.getWidth() + " x " + this.getHeight());
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(new Font("Arial", 0, 32));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.controler.isClientDefined()) {
            g.setColor(DARK_BLUE);
            g.setFont(new Font("Arial", 0, 28));
            g.drawString(this.controler.getClient().getFullName(), 20, 75);
            g.setColor(Color.GRAY);
            g.setFont(g.getFont().deriveFont(18.0f));
            g.drawString("Solde : " + new DecimalFormat("#0.00").format(this.controler.getClient().getSolde()), 20, 120);
        }
        int xPos = 300;
        if (this.controler.getPOSConf().getScreenWidth() < 1280) {
            xPos = 270;
        }
        int x = xPos;
        int y = 110;
        g.setColor(Color.BLACK);
        if (this.controler.isClientDefined()) {
            g.setFont(g.getFont().deriveFont(46.0f));
            y += 10;
        } else {
            g.setFont(g.getFont().deriveFont(66.0f));
        }
        int total = this.controler.getTotal();
        String euros = String.valueOf(CaisseControler.getEuros(total)) + ".";
        String cents = CaisseControler.getCents(total);
        Rectangle2D r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x -= (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(40.0f));
        g.drawString(cents, x + (int)r.getWidth(), y);
        y += 40;
        x = xPos;
        int paye = this.controler.getPaidTotal();
        euros = String.valueOf(CaisseControler.getEuros(paye)) + ".";
        cents = CaisseControler.getCents(paye);
        g.setFont(g.getFont().deriveFont(18.0f));
        Rectangle2D r2 = g.getFontMetrics().getStringBounds("Pay\u00e9", g);
        if (paye >= total) {
            g.setColor(Color.DARK_GRAY);
        } else {
            g.setColor(Color.ORANGE);
        }
        g.setFont(g.getFont().deriveFont(32.0f));
        r = g.getFontMetrics().getStringBounds(euros, g);
        g.drawString(euros, x - (int)r.getWidth(), y);
        g.setFont(g.getFont().deriveFont(24.0f));
        g.drawString(cents, x, y);
        g.setFont(g.getFont().deriveFont(18.0f));
        g.setColor(Color.GRAY);
        g.drawString("Pay\u00e9", x - (int)r2.getWidth() - (int)r.getWidth() - 10, y);
        boolean bl = minimalHeight = this.getHeight() < 750;
        if (!minimalHeight) {
            y += 40;
            x = xPos;
        } else {
            x = 140;
        }
        int aRendre = paye - total;
        if (aRendre != 0) {
            String label;
            if (aRendre > 0) {
                label = "Rendu";
            } else {
                label = !minimalHeight ? "Reste \u00e0 payer" : "Doit";
                aRendre = -aRendre;
            }
            euros = String.valueOf(CaisseControler.getEuros(aRendre)) + ".";
            cents = CaisseControler.getCents(aRendre);
            g.setFont(g.getFont().deriveFont(18.0f));
            Rectangle2D r3 = g.getFontMetrics().getStringBounds(label, g);
            g.setColor(Color.DARK_GRAY);
            g.setFont(g.getFont().deriveFont(32.0f));
            r = g.getFontMetrics().getStringBounds(euros, g);
            g.drawString(euros, x - (int)r.getWidth(), y);
            g.setFont(g.getFont().deriveFont(24.0f));
            g.drawString(cents, x, y);
            g.setFont(g.getFont().deriveFont(18.0f));
            g.setColor(Color.GRAY);
            g.drawString(label, x - (int)r3.getWidth() - (int)r.getWidth() - 10, y);
        }
    }

    @Override
    public void caisseStateChanged() {
        this.repaint();
    }

    public void switchListMode() {
        GridBagConstraints c = ((GridBagLayout)this.getLayout()).getConstraints(this.selector);
        this.remove(this.selector);
        this.selector = this.selector == this.articleSearchPanel ? this.articleSelectorPanel : this.articleSearchPanel;
        System.err.println("CaissePanel.switchListMode()" + this.selector.getMinimumSize() + " " + this.selector.getPreferredSize() + " " + this.selector.getMaximumSize());
        this.add((Component)this.selector, c);
        this.validate();
        this.repaint();
    }

    public boolean isModeSearch() {
        return this.selector == this.articleSearchPanel;
    }

    public CaisseControler getControler() {
        return this.controler;
    }

    public void validateTicket(CaisseFrame caisseFrame) {
        Ticket savedReceipt;
        try {
            savedReceipt = this.controler.saveAndClearTicket(caisseFrame.getFiles(), caisseFrame.getConf().getDirectory());
        }
        catch (RegisterFiles.DifferentDayException ex) {
            JOptionPane.showMessageDialog(this, "Impossible de laisser la caisse ouverte plusieurs jours. Veuillez la cl\u00c3\u00b4turer pour pouvoir faire de nouveaux tickets.", "Erreur", 0);
            return;
        }
        catch (Throwable ex) {
            ExceptionHandler.handle(this, "Erreur de sauvegarde des informations du ticket", ex);
            return;
        }
        if (savedReceipt != null) {
            this.controler.setLCD("Impression de", "votre ticket...", 0);
            try {
                caisseFrame.getPOSConf().print((Printable)savedReceipt, savedReceipt.isAdditionnalCopyRequested() ? 1 : 0);
            }
            catch (UnsatisfiedLinkError ex) {
                JOptionPane.showMessageDialog(this, "Erreur de configuration de la liaison \u00e0 l'imprimante");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(this, "Erreur d'impression du ticket");
            }
            this.controler.setLCDDefaultDisplay(2);
        } else {
            System.err.println("CaissePanel.validateTicket() ticket non sauv\u00e9");
        }
    }
}

