/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openconcerto.erp.core.finance.accounting.model.Currency;
import org.openconcerto.erp.core.finance.accounting.model.CurrencyConverter;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.sql.view.list.ListSQLLine;
import org.openconcerto.sql.view.list.SQLTableModelColumn;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.TableSorter;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Tuple3;

public class IListTotalPanel
extends JPanel {
    CurrencyConverter cc = new CurrencyConverter();
    DecimalFormat decimalFormat = new DecimalFormat("##,##0.00");
    EventListenerList loadingListener = new EventListenerList();
    private final IListe list;
    private final Map<SQLTableModelColumn, JLabel> map = new HashMap<SQLTableModelColumn, JLabel>();
    private final boolean onSelection;
    final GridBagConstraints c = new DefaultGridBagConstraints();
    private SQLTableModelColumn fieldDebit;
    private SQLTableModelColumn fieldCredit;
    private SQLTableModelColumn soldeEcrColumn;

    public IListTotalPanel(IListe l, List<SQLField> listField) {
        this(l, IListTotalPanel.initListe(l, listField), null, null);
    }

    public IListTotalPanel(IListe l, List<SQLField> listField, String title) {
        this(l, IListTotalPanel.initListe(l, listField), null, title);
    }

    public static List<Tuple2<? extends SQLTableModelColumn, Type>> initListe(IListe iL, List<SQLField> l) {
        ArrayList<Tuple2<? extends SQLTableModelColumn, Type>> lFinal = new ArrayList<Tuple2<? extends SQLTableModelColumn, Type>>();
        for (SQLField field : l) {
            SQLTableModelColumn col = iL.getSource().getColumn(field);
            if (col == null) {
                throw new IllegalArgumentException("No column with just " + field + " : " + iL.getSource().getColumns());
            }
            lFinal.add(Tuple2.create(col, Type.SOMME));
        }
        return lFinal;
    }

    public IListTotalPanel(IListe l, List<Tuple2<? extends SQLTableModelColumn, Type>> listField, List<Tuple2<SQLField, ?>> filters, String title) {
        this(l, listField, filters, null, title, false);
    }

    public IListTotalPanel(IListe l, List<Tuple2<? extends SQLTableModelColumn, Type>> listField, List<Tuple2<SQLField, ?>> filters, List<Tuple2<SQLField, ?>> filtersNot, String title) {
        this(l, listField, filters, filtersNot, title, false);
    }

    public IListTotalPanel(IListe l, final List<Tuple2<? extends SQLTableModelColumn, Type>> listField, final List<Tuple2<SQLField, ?>> filters, final List<Tuple2<SQLField, ?>> filtersNot, String title, boolean onSelection) {
        super(new GridBagLayout());
        this.list = l;
        this.setOpaque(false);
        this.onSelection = onSelection;
        this.c.gridx = -1;
        this.c.weightx = 0.0;
        if (title != null && title.trim().length() > 0) {
            JLabel sep = new JLabel(title);
            this.c.weightx = 1.0;
            this.c.gridwidth = 0;
            this.add((Component)sep, this.c);
            ++this.c.gridy;
            this.c.gridwidth = 1;
        }
        for (Tuple2<? extends SQLTableModelColumn, Type> field2 : listField) {
            this.c.weightx = 0.0;
            SQLTableModelColumn col = field2.get0();
            if (col == null) {
                throw new IllegalStateException("null SQLTableModelColumn in " + listField);
            }
            JLabelBold comp = new JLabelBold(col.getName());
            comp.setHorizontalAlignment(4);
            this.add((Component)comp, this.c);
            JLabelBold textField = new JLabelBold("0");
            textField.setHorizontalAlignment(4);
            this.map.put(field2.get0(), textField);
            this.c.weightx = 1.0;
            this.add((Component)textField, this.c);
            this.c.weightx = 0.0;
            if (field2.get1() == Type.SOMME || field2.get1() == Type.MOYENNE_DEVISE || field2.get1() == Type.AVANCEMENT_TTC) {
                this.add((Component)new JLabelBold(Currency.getSymbol(this.cc.getCompanyCurrencyCode())), this.c);
            } else if (field2.get1() == Type.MOYENNE_POURCENT || field2.get1() == Type.MOYENNE_MARGE) {
                this.add((Component)new JLabelBold("%"), this.c);
            }
            ++this.c.gridy;
        }
        if (this.onSelection) {
            this.list.getJTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    List<ListSQLLine> listLines = IListTotalPanel.this.list.getSelectedLines();
                    for (Tuple2 field : listField) {
                        if (field.get1() != Type.COUNT) continue;
                        ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(String.valueOf(listLines.size()));
                    }
                    IListTotalPanel.this.computeValues(listField, filters, filtersNot, listLines);
                }
            });
        } else {
            this.list.addListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    TableModel model = (TableModel)e.getSource();
                    ITableModel sqlModel = model instanceof ITableModel ? (ITableModel)model : (ITableModel)((TableSorter)model).getTableModel();
                    ArrayList<ListSQLLine> listLines = new ArrayList<ListSQLLine>();
                    int i = 0;
                    while (i < sqlModel.getRowCount()) {
                        listLines.add(sqlModel.getRow(i));
                        ++i;
                    }
                    for (Tuple2 field : listField) {
                        if (field.get1() != Type.COUNT) continue;
                        ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(String.valueOf(model.getRowCount()));
                    }
                    IListTotalPanel.this.computeValues(listField, filters, filtersNot, listLines);
                }
            });
        }
    }

    public void addSubtract(SQLTableModelColumn fieldDebit, SQLTableModelColumn fieldCredit) {
        this.c.weightx = 0.0;
        this.fieldCredit = fieldCredit;
        this.fieldDebit = fieldDebit;
        JLabelBold comp = new JLabelBold("Solde");
        comp.setHorizontalAlignment(4);
        this.add((Component)comp, this.c);
        JLabelBold textField = new JLabelBold("0");
        textField.setHorizontalAlignment(4);
        this.soldeEcrColumn = new BaseSQLTableModelColumn("SoldeEcr", BigDecimal.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                return null;
            }

            @Override
            public Set<FieldPath> getPaths() {
                return null;
            }
        };
        this.map.put(this.soldeEcrColumn, textField);
        this.c.weightx = 1.0;
        this.add((Component)textField, this.c);
        this.c.weightx = 0.0;
        this.add((Component)new JLabelBold(Currency.getSymbol(this.cc.getCompanyCurrencyCode())), this.c);
        ++this.c.gridy;
    }

    public void fireUpdated() {
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])this.loadingListener.getListeners(PropertyChangeListener.class);
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            l.propertyChange(null);
            ++n2;
        }
    }

    public void addListener(PropertyChangeListener l) {
        this.loadingListener.add(PropertyChangeListener.class, l);
    }

    private Object getValueAt(ListSQLLine line, SQLTableModelColumn col, List<SQLTableModelColumn> columns) {
        int indexOf = columns.indexOf(col);
        Object res = line.getValueAt(indexOf);
        if (res == null) {
            throw new IllegalStateException("Null value for " + col + " in " + line);
        }
        return res;
    }

    private void computeValues(final List<Tuple2<? extends SQLTableModelColumn, Type>> listField, final List<Tuple2<SQLField, ?>> filters, final List<Tuple2<SQLField, ?>> filtersNot, final List<ListSQLLine> listLines) {
        SwingWorker<Tuple3<Map<SQLTableModelColumn, BigDecimal>, Map<SQLTableModelColumn, Double>, Map<SQLTableModelColumn, Integer>>, Object> worker = new SwingWorker<Tuple3<Map<SQLTableModelColumn, BigDecimal>, Map<SQLTableModelColumn, Double>, Map<SQLTableModelColumn, Integer>>, Object>(){

            @Override
            protected Tuple3<Map<SQLTableModelColumn, BigDecimal>, Map<SQLTableModelColumn, Double>, Map<SQLTableModelColumn, Integer>> doInBackground() throws Exception {
                HashMap<SQLTableModelColumn, BigDecimal> mapTotal = new HashMap<SQLTableModelColumn, BigDecimal>();
                HashMap<SQLTableModelColumn, Double> mapPourcent = new HashMap<SQLTableModelColumn, Double>();
                HashMap<SQLTableModelColumn, Integer> mapPourcentSize = new HashMap<SQLTableModelColumn, Integer>();
                for (ListSQLLine line : listLines) {
                    SQLRowAccessor rowAt = line.getRowAccessor();
                    List<SQLTableModelColumn> columns = line.getColumns().getColumns();
                    for (Tuple2 field : listField) {
                        BigDecimal n;
                        Type type = (Type)((Object)field.get1());
                        if (type == Type.MOYENNE_POURCENT) {
                            Double n2 = (Double)IListTotalPanel.this.getValueAt(line, (SQLTableModelColumn)field.get0(), columns);
                            boolean in = true;
                            if (filters != null) {
                                for (Tuple2 tuple2 : filters) {
                                    boolean bl = in = in && rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (filtersNot != null) {
                                for (Tuple2 tuple2 : filtersNot) {
                                    boolean bl = in = in && !rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (!in) continue;
                            if (mapPourcent.get(field.get0()) == null) {
                                mapPourcent.put((SQLTableModelColumn)field.get0(), n2);
                            } else {
                                mapPourcent.put((SQLTableModelColumn)field.get0(), n2 + (Double)mapPourcent.get(field.get0()));
                            }
                            if (mapPourcentSize.get(field.get0()) == null) {
                                mapPourcentSize.put((SQLTableModelColumn)field.get0(), 1);
                                continue;
                            }
                            mapPourcentSize.put((SQLTableModelColumn)field.get0(), (Integer)mapPourcentSize.get(field.get0()) + 1);
                            continue;
                        }
                        if (type == Type.AVANCEMENT_TTC) {
                            n = (BigDecimal)mapTotal.get(field.get0());
                            Number objectAs = line.getRow().getObjectAs("T_TTC", Number.class);
                            BigDecimal ttc = objectAs instanceof Long ? BigDecimal.valueOf(objectAs.doubleValue() / 100.0) : BigDecimal.valueOf(objectAs.doubleValue());
                            BigDecimal av = BigDecimal.valueOf(((Number)IListTotalPanel.this.getValueAt(line, (SQLTableModelColumn)field.get0(), columns)).doubleValue());
                            boolean in = true;
                            if (filters != null) {
                                for (Tuple2 tuple2 : filters) {
                                    boolean bl = in = in && rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (filtersNot != null) {
                                for (Tuple2 tuple2 : filtersNot) {
                                    boolean bl = in = in && !rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                                }
                            }
                            if (!in) continue;
                            if (n == null) {
                                mapTotal.put((SQLTableModelColumn)field.get0(), ttc.multiply(av).movePointLeft(2));
                                continue;
                            }
                            mapTotal.put((SQLTableModelColumn)field.get0(), n.add(ttc.multiply(av).movePointLeft(2)));
                            continue;
                        }
                        if (type == Type.MOYENNE_MARGE || type == Type.COUNT || columns.indexOf(field.get0()) == -1) continue;
                        n = (BigDecimal)mapTotal.get(field.get0());
                        Object value = IListTotalPanel.this.getValueAt(line, (SQLTableModelColumn)field.get0(), columns);
                        BigDecimal n2 = BigDecimal.valueOf(((Number)value).doubleValue());
                        boolean in = true;
                        if (filters != null) {
                            for (Tuple2 tuple2 : filters) {
                                boolean bl = in = in && rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                            }
                        }
                        if (filtersNot != null) {
                            for (Tuple2 tuple2 : filtersNot) {
                                boolean bl = in = in && !rowAt.getObject(((SQLField)tuple2.get0()).getName()).equals(tuple2.get1());
                            }
                        }
                        if (!in) continue;
                        if (n == null) {
                            mapTotal.put((SQLTableModelColumn)field.get0(), n2);
                            continue;
                        }
                        mapTotal.put((SQLTableModelColumn)field.get0(), n.add(n2));
                    }
                }
                return Tuple3.create(mapTotal, mapPourcent, mapPourcentSize);
            }

            @Override
            protected void done() {
                try {
                    Tuple3 tuple3 = (Tuple3)this.get();
                    Map mapTotal = (Map)tuple3.get0();
                    Map mapPourcent = (Map)tuple3.get1();
                    Map mapPourcentSize = (Map)tuple3.get2();
                    for (Tuple2 field : listField) {
                        Number l;
                        if (field.get1() == Type.MOYENNE_MARGE) {
                            BigDecimal totalVT = (BigDecimal)mapTotal.get(((Tuple2)listField.get(0)).get0());
                            BigDecimal totalHA = (BigDecimal)mapTotal.get(((Tuple2)listField.get(1)).get0());
                            if (totalHA != null && totalVT != null && totalVT.longValue() != 0L) {
                                ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(totalVT.subtract(totalHA).divide(totalVT, MathContext.DECIMAL32).doubleValue() * 100.0));
                                continue;
                            }
                            ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(0L));
                            continue;
                        }
                        if (field.get1() == Type.MOYENNE_POURCENT) {
                            l = (Double)mapPourcent.get(field.get0());
                            Integer d = (Integer)mapPourcentSize.get(field.get0());
                            if (l != null && d != null && d != 0) {
                                ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format((Double)l / (double)d.intValue()));
                                continue;
                            }
                            ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(0L));
                            continue;
                        }
                        if (field.get1() == Type.COUNT) continue;
                        l = (BigDecimal)mapTotal.get(field.get0());
                        if (l != null) {
                            ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(((BigDecimal)l).doubleValue()));
                            continue;
                        }
                        ((JLabel)IListTotalPanel.this.map.get(field.get0())).setText(IListTotalPanel.this.decimalFormat.format(0L));
                    }
                    if (IListTotalPanel.this.map.containsKey(IListTotalPanel.this.soldeEcrColumn)) {
                        BigDecimal d = (BigDecimal)mapTotal.get(IListTotalPanel.this.fieldDebit);
                        BigDecimal c = (BigDecimal)mapTotal.get(IListTotalPanel.this.fieldCredit);
                        if (d != null && c != null) {
                            ((JLabel)IListTotalPanel.this.map.get(IListTotalPanel.this.soldeEcrColumn)).setText(IListTotalPanel.this.decimalFormat.format(d.doubleValue() - c.doubleValue()));
                        } else {
                            ((JLabel)IListTotalPanel.this.map.get(IListTotalPanel.this.soldeEcrColumn)).setText(IListTotalPanel.this.decimalFormat.format(0L));
                        }
                    }
                    IListTotalPanel.this.fireUpdated();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
        };
        worker.execute();
    }

    public static enum Type {
        MOYENNE_POURCENT,
        MOYENNE_DEVISE,
        SOMME,
        SOMME_QTE,
        MOYENNE_MARGE,
        AVANCEMENT_TTC,
        COUNT,
        DIFF;

    }
}

