/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml.persistence;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.utils.SetMap;
import org.openconcerto.xml.persistence.PersistenceIO;
import org.openconcerto.xml.persistence.XMLFactory;

public abstract class BaseXMLIO
implements PersistenceIO {
    protected static final XMLOutputter writer = new XMLOutputter(Format.getPrettyFormat());
    protected static final String ext = ".xml";
    protected static final Namespace NS = Namespace.getNamespace("persistent", "http://ilm-informatique.fr/PersistenceManager");
    private final File root;
    private boolean autoCommit;

    public BaseXMLIO(File dir) {
        this.root = dir;
        this.autoCommit = true;
    }

    protected final File getRoot() {
        return this.root;
    }

    protected final File getDir(Class<?> clazz) {
        File dir = new File(this.root, XMLFactory.getNonNullElementName(clazz));
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public final SetMap<Class<?>, String> getIDs() throws IOException {
        File[] dirs = this.root.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        SetMap res = new SetMap();
        int i = 0;
        while (i < dirs.length) {
            File dir = dirs[i];
            Class<?> clazz = XMLFactory.getClass(dir.getName());
            if (clazz != null) {
                res.addAll(clazz, (Collection<String>)this.getIDs(clazz));
            }
            ++i;
        }
        return res;
    }

    @Override
    public synchronized void deleteAll() throws IOException {
        File[] dirs = this.getRoot().listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }
        });
        int i = 0;
        while (i < dirs.length) {
            File dir = dirs[i];
            Class<?> clazz = XMLFactory.getClass(dir.getName());
            if (clazz != null) {
                this.delete(clazz);
            }
            ++i;
        }
    }

    public final synchronized boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public synchronized void setAutoCommit(boolean b) throws IOException {
        if (b != this.autoCommit) {
            this.autoCommit = b;
            if (this.autoCommit) {
                this.beginAutoCommit();
            }
        }
    }

    protected abstract void beginAutoCommit() throws IOException;
}

