/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.xml;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.AbstractFilter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;
import org.openconcerto.utils.cc.IPredicate;
import org.xml.sax.InputSource;

public final class JDOM2Utils {
    public static final XMLOutputter OUTPUTTER;
    private static final SAXBuilder BUILDER;

    static {
        Format rawFormat = Format.getRawFormat();
        rawFormat.setLineSeparator(LineSeparator.NL);
        OUTPUTTER = new XMLOutputter(rawFormat);
        BUILDER = JDOM2Utils.createBuilder();
    }

    public static final SAXBuilder createBuilder() {
        SAXBuilder res = new SAXBuilder();
        res.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        res.setXMLReaderFactory(XMLReaders.NONVALIDATING);
        return res;
    }

    public static final InputSource createEmptySourcce() {
        return new InputSource(new StringReader(""));
    }

    public static void forcePlatformDefaultSchemaFactory() throws ClassNotFoundException {
        String platformClassName = "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory";
        if (Class.forName("com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory") != null) {
            System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema", "com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory");
        }
    }

    public static Element parseElementString(String xml, Namespace[] namespaces) throws JDOMException {
        return (Element)JDOM2Utils.parseString(xml.trim(), namespaces).get(0);
    }

    public static List<Content> parseString(String xml, Namespace[] namespaces) throws JDOMException {
        String dummy = "<dummy";
        int i = 0;
        while (i < namespaces.length) {
            Namespace ns = namespaces[i];
            dummy = String.valueOf(dummy) + " xmlns:" + ns.getPrefix() + "=\"" + ns.getURI() + "\"";
            ++i;
        }
        xml = String.valueOf(dummy) + ">" + xml + "</dummy>";
        return JDOM2Utils.parseStringDocument(xml).getRootElement().removeContent();
    }

    public static Element parseString(String xml) throws JDOMException {
        return JDOM2Utils.parseElementString(xml, new Namespace[0]);
    }

    public static synchronized Document parseStringDocument(String xml) throws JDOMException {
        return JDOM2Utils.parseStringDocument(xml, BUILDER);
    }

    public static Document parseStringDocument(String xml, SAXBuilder builder) throws JDOMException {
        Document doc = null;
        try {
            doc = builder.build(new StringReader(xml));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static String output(Element xml) {
        return OUTPUTTER.outputString(xml);
    }

    public static String output(Document xml) {
        return OUTPUTTER.outputString(xml);
    }

    public static boolean equals(Element elem1, Element elem2) {
        if (elem1 == elem2 || elem1 == null && elem2 == null) {
            return true;
        }
        if (elem1 == null || elem2 == null) {
            return false;
        }
        return elem1.getName().equals(elem2.getName()) && elem1.getNamespace().equals(elem2.getNamespace());
    }

    public static boolean equalsDeep(Element elem1, Element elem2) {
        return JDOM2Utils.equalsDeep(elem1, elem2, true);
    }

    public static boolean equalsDeep(Element elem1, Element elem2, boolean normalizeText) {
        return JDOM2Utils.getDiff(elem1, elem2, normalizeText) == null;
    }

    static String getDiff(Element elem1, Element elem2, boolean normalizeText) {
        if (elem1 == elem2) {
            return null;
        }
        if (!JDOM2Utils.equals(elem1, elem2)) {
            return "element name or namespace";
        }
        List<Attribute> attr1 = elem1.getAttributes();
        List<Attribute> attr2 = elem2.getAttributes();
        if (attr1.size() != attr2.size()) {
            return "attributes count";
        }
        for (Attribute attr : attr1) {
            if (attr.getValue().equals(elem2.getAttributeValue(attr.getName(), attr.getNamespace()))) continue;
            return "attribute value";
        }
        IPredicate<Content> filter = new IPredicate<Content>(){

            @Override
            public boolean evaluateChecked(Content input) {
                return input instanceof Text || input instanceof Element;
            }
        };
        Iterator<Content> contents1 = JDOM2Utils.getContent(elem1, (IPredicate<? super Content>)filter, true);
        Iterator<Content> contents2 = JDOM2Utils.getContent(elem2, (IPredicate<? super Content>)filter, true);
        while (contents1.hasNext() && contents2.hasNext()) {
            Content content1 = contents1.next();
            Content content2 = contents2.next();
            if (content1.getClass() != content2.getClass()) {
                return "content";
            }
            if (content1 instanceof Text) {
                String s2;
                String s1 = normalizeText ? ((Text)content1).getTextNormalize() : content1.getValue();
                String string = s2 = normalizeText ? ((Text)content2).getTextNormalize() : content2.getValue();
                if (s1.equals(s2)) continue;
                return "text";
            }
            String rec = JDOM2Utils.getDiff((Element)content1, (Element)content2, normalizeText);
            if (rec == null) continue;
            return rec;
        }
        if (contents1.hasNext() || contents2.hasNext()) {
            return "content size";
        }
        return null;
    }

    public static Iterator<Content> getContent(Element elem, final IPredicate<? super Content> pred, boolean mergeText) {
        final Iterator<Content> iter = elem.getContent(new AbstractFilter<Content>(){

            @Override
            public Content filter(Object obj) {
                Content c = (Content)obj;
                return pred.evaluateChecked(c) ? c : null;
            }
        }).iterator();
        if (!mergeText) {
            return iter;
        }
        return new Iterator<Content>(){
            private Content next = null;

            @Override
            public boolean hasNext() {
                return this.next != null || iter.hasNext();
            }

            @Override
            public Content next() {
                if (this.next != null) {
                    Content res = this.next;
                    this.next = null;
                    return res;
                }
                Content res = (Content)iter.next();
                if (!$assertionsDisabled && res == null) {
                    throw new AssertionError();
                }
                if (res instanceof Text && iter.hasNext()) {
                    this.next = (Content)iter.next();
                    Text concatText = null;
                    while (this.next instanceof Text) {
                        if (concatText == null) {
                            concatText = new Text(res.getValue());
                        }
                        concatText.append((Text)this.next);
                        Content content = this.next = iter.hasNext() ? (Content)iter.next() : null;
                    }
                    if (!$assertionsDisabled && this.next == null) {
                        throw new AssertionError();
                    }
                    if (concatText != null) {
                        res = concatText;
                    }
                }
                return res;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

