/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.cc.ITransformer;
import org.openconcerto.utils.i18n.TM;

public final class SystemInfo {
    public static final String CLASS_PROTOCOL = "class";
    public static final String PROPS_PROTOCOL = "props";
    public static final String ENV_PROTOCOL = "env";
    private static final DateTimeFormatter DATETIME_FMT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG);

    public static NavigableMap<Info, String> get(boolean html, Locale locale) {
        TM tm = TM.getInstance(locale);
        TreeMap<Info, String> res = new TreeMap<Info, String>();
        String lineBreak = SystemInfo.getLineBreak(html);
        String version = System.getProperty("java.runtime.version") != null ? System.getProperty("java.runtime.version") : System.getProperty("java.version");
        URI vendorURI = null;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        URI lafURI = null;
        try {
            vendorURI = new URI(System.getProperty("java.vendor.url"));
            lafURI = new URI(CLASS_PROTOCOL, lookAndFeel.getClass().getName(), null);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        Runtime rt = Runtime.getRuntime();
        long totalMemory = rt.totalMemory();
        RuntimeMXBean rtBean = ManagementFactory.getRuntimeMXBean();
        Instant startTime = Instant.ofEpochMilli(rtBean.getStartTime());
        String startTimeDesc = DATETIME_FMT.withLocale(locale).format(ZonedDateTime.ofInstant(startTime, ZoneId.systemDefault()));
        String rtDesc = "<i>" + tm.translate("startTime", new Object[0]) + " :</i> " + startTimeDesc + lineBreak + "<i>" + tm.translate("vm.params", new Object[0]) + " :</i> " + rtBean.getInputArguments();
        String stats = "<i>" + tm.translate("memory.used", new Object[0]) + " :</i> " + SystemInfo.formatBytes(tm, totalMemory - rt.freeMemory()) + " / " + SystemInfo.formatBytes(tm, totalMemory) + " ; " + tm.translate("processors", rt.availableProcessors()) + lineBreak + rtDesc;
        String lafDesc = lookAndFeel == null ? tm.translate("no.laf", new Object[0]) : String.valueOf(SystemInfo.getLink(lookAndFeel.getName(), lafURI, html)) + ", " + lookAndFeel.getDescription();
        URI propsURI = null;
        URI envURI = null;
        try {
            propsURI = new URI(PROPS_PROTOCOL, "/", null);
            envURI = new URI(ENV_PROTOCOL, "/", null);
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        String propsDesc = envURI == null ? "" : String.valueOf(lineBreak) + SystemInfo.getLink(tm.translate("properties.all", new Object[0]), propsURI, html) + ", " + SystemInfo.getLink(tm.translate("env.all", new Object[0]), envURI, html);
        String p = String.valueOf(tm.translate("javaVersion", version, SystemInfo.getLink(System.getProperty("java.vendor"), vendorURI, html))) + " ; " + SystemInfo.getLink(tm.translate("javaHome", new Object[0]), new File(System.getProperty("java.home")).toURI(), html) + lineBreak + stats + lineBreak + lafDesc + propsDesc;
        res.put(Info.JAVA, p);
        res.put(Info.OS, "<b>" + System.getProperty("os.name") + "</b> " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")");
        res.put(Info.USER, String.valueOf(System.getProperty("user.name")) + " ; " + SystemInfo.getLink(tm.translate("home.dir", new Object[0]), new File(System.getProperty("user.home")).toURI(), html) + " ; " + SystemInfo.getLink(tm.translate("cwd", new Object[0]), new File(System.getProperty("user.dir")).toURI(), html));
        ArrayList<String> ifs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                if (ni.getHardwareAddress() == null || ni.isLoopback() || ni.getDisplayName().toLowerCase().contains("vmware") || ni.getName().toLowerCase().contains("vmnet")) continue;
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(ni.getName()) + " " + CollectionUtils.join(ni.getInterfaceAddresses(), ", ", new ITransformer<InterfaceAddress, String>(){

                    @Override
                    public String transformChecked(InterfaceAddress input) {
                        return "<b>" + input.getAddress().getHostAddress() + "</b>" + "/" + input.getNetworkPrefixLength();
                    }
                }));
                sb.append(" ; <i>" + tm.translate("interfaceState", new Object[0]) + " :</i> " + tm.translate(ni.isUp() ? "interfaceStateUp" : "interfaceStateDown", new Object[0]));
                sb.append(lineBreak);
                sb.append(" <i>" + tm.translate("interfaceFullName", new Object[0]) + " :</i> " + ni.getDisplayName());
                sb.append(lineBreak);
                sb.append(" <i>" + tm.translate("hardwareAddress", new Object[0]) + " :</i> ");
                Formatter fmt = new Formatter(sb);
                byte[] mac = ni.getHardwareAddress();
                int i = 0;
                while (i < mac.length) {
                    fmt.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : "");
                    ++i;
                }
                ifs.add(sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ifs.add(e.getLocalizedMessage());
        }
        res.put(Info.NETWORK, CollectionUtils.join(ifs, lineBreak));
        return res;
    }

    public static final String getLineBreak(boolean html) {
        return html ? "<br>" : "\n";
    }

    public static final String getLink(String name, URI uri, boolean html) {
        if (uri == null) {
            return name;
        }
        if (html) {
            return "<a href=\"" + uri.toString() + "\" >" + name + "</a>";
        }
        return "[" + name + "](" + uri.toString() + ")";
    }

    private static String formatBytes(TM tm, long b) {
        return tm.translate("megabytes", b / 1024L / 1024L);
    }

    public static enum Info {
        JAVA,
        OS,
        USER,
        NETWORK;

    }
}

