/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.order.element;

import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.element.StyleSQLElement;
import org.openconcerto.erp.core.common.ui.DeviseTableCellRenderer;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.supplychain.order.element.DemandeAchatItemSQLComponent;
import org.openconcerto.erp.core.supplychain.order.ui.EtatDemandeAchatRenderer;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSource;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;
import org.openconcerto.utils.cc.ITransformer;

public class DemandeAchatItemSQLElement
extends ComptaSQLConfElement {
    public DemandeAchatItemSQLElement() {
        super("DEMANDE_ACHAT_ELEMENT");
        RowAction actionP = new RowAction.PredicateRowAction(new AbstractAction("Cr\u00e9er \u00e0 partir de"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow row = IListe.get(e).getSelectedRow().asRow();
                SQLRowValues rowDupl = new SQLRowValues(row.getTable());
                List<String> copyFields = Arrays.asList("COLOR", "NUMERO_SE", "DESCRIPTIF_SE", "REVISION", "P_HT", "T_HT", "REPERE_SOURCE", "CODE_SOURCE", "NOM_SOURCE", "CODE", "NOM", "QTE", "QTE_UNITAIRE", "REPERE", "REFERENCE", "ID_FABRICANT", "ID_UNITE_VENTE", "ID_ARTICLE", "ID_FOURNISSEUR", "ID_FAMILLE_ARTICLE", "ID_AFFAIRE");
                for (String string : copyFields) {
                    if (!DemandeAchatItemSQLElement.this.getTable().contains(string)) continue;
                    if (string.startsWith("ID_")) {
                        rowDupl.put(string, row.getForeignID(string));
                        continue;
                    }
                    rowDupl.put(string, row.getObject(string));
                }
                rowDupl.put("DATE", new Date());
                EditFrame frame = new EditFrame(DemandeAchatItemSQLElement.this.getDirectory().getElement("DEMANDE_ACHAT_ELEMENT"));
                frame.getSQLComponent().select(rowDupl);
                FrameUtil.showPacked(frame);
            }
        }, true);
        actionP.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionP);
        actionP = new RowAction(new AbstractAction("Transfert en demande de prix"){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleSQLElement styleElt = DemandeAchatItemSQLElement.this.getDirectory().getElement(StyleSQLElement.class);
                int idNormal = styleElt.getAllStyleByName().get("Normal");
                SQLRowValues rowVals = new SQLRowValues(DemandeAchatItemSQLElement.this.getTable().getTable("DEMANDE_PRIX"));
                rowVals.put("DATE", new Date());
                SQLInjector inj = SQLInjector.getInjector(DemandeAchatItemSQLElement.this.getTable(), DemandeAchatItemSQLElement.this.getTable().getTable("DEMANDE_PRIX_ELEMENT"));
                List<SQLRow> rows = SQLRowListRSH.fetch(IListe.get(e).getRequest().getPrimaryTable(), IListe.get(e).getSelection().getSelectedIDs());
                for (SQLRow row : rows) {
                    if (DemandeAchatItemSQLElement.this.getTable().contains("ID_AFFAIRE")) {
                        rowVals.put("ID_AFFAIRE", row.getForeignID("ID_AFFAIRE"));
                    }
                    SQLRowValues rowValsCmdElt = inj.createRowValuesFrom(row);
                    rowValsCmdElt.put("ID_STYLE", idNormal);
                    rowValsCmdElt.put("ID_MODE_VENTE_ARTICLE", 5);
                    rowValsCmdElt.put("ID_TAXE", TaxeCache.getCache().getFirstTaxeAchat().getID());
                    rowValsCmdElt.put("ID_DEMANDE_PRIX", (Object)rowVals);
                    rowValsCmdElt.put("ID_DEMANDE_ACHAT_ELEMENT", row.getID());
                    if (row.getObject("ID_ARTICLE") != null && !row.isForeignEmpty("ID_ARTICLE")) {
                        BigDecimal ha = row.getForeign("ID_ARTICLE").getBigDecimal("PA_HT");
                        rowValsCmdElt.put("PA_HT", ha);
                        rowValsCmdElt.put("PRIX_METRIQUE_HA_1", ha);
                        rowValsCmdElt.put("PA_DEVISE", ha);
                        continue;
                    }
                    rowValsCmdElt.put("PA_HT", BigDecimal.ZERO);
                    rowValsCmdElt.put("PRIX_METRIQUE_HA_1", BigDecimal.ZERO);
                    rowValsCmdElt.put("PA_DEVISE", BigDecimal.ZERO);
                }
                EditFrame frame = new EditFrame(DemandeAchatItemSQLElement.this.getDirectory().getElement("DEMANDE_PRIX"));
                frame.getSQLComponent().select(rowVals);
                FrameUtil.showPacked(frame);
            }
        }, true){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection != null && selection.size() > 0) {
                    int idAff = -1;
                    for (SQLRowValues sqlRowValues : selection) {
                        if (!DemandeAchatItemSQLElement.this.getTable().contains("ID_AFFAIRE") || sqlRowValues.getObject("ID_AFFAIRE") == null || sqlRowValues.isForeignEmpty("ID_AFFAIRE")) continue;
                        if (idAff == -1) {
                            idAff = sqlRowValues.getForeignID("ID_AFFAIRE");
                        }
                        if (idAff == sqlRowValues.getForeignID("ID_AFFAIRE")) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.getRowActions().add(actionP);
        actionP = new RowAction(new AbstractAction("Transfert en commande"){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyleSQLElement styleElt = DemandeAchatItemSQLElement.this.getDirectory().getElement(StyleSQLElement.class);
                int idNormal = styleElt.getAllStyleByName().get("Normal");
                SQLRowValues rowVals = new SQLRowValues(DemandeAchatItemSQLElement.this.getTable().getTable("COMMANDE"));
                rowVals.put("DATE", new Date());
                SQLInjector inj = SQLInjector.getInjector(DemandeAchatItemSQLElement.this.getTable(), DemandeAchatItemSQLElement.this.getTable().getTable("COMMANDE_ELEMENT"));
                List<SQLRow> rows = SQLRowListRSH.fetch(IListe.get(e).getRequest().getPrimaryTable(), IListe.get(e).getSelection().getSelectedIDs());
                for (SQLRow row : rows) {
                    if (DemandeAchatItemSQLElement.this.getTable().contains("ID_AFFAIRE")) {
                        rowVals.put("ID_AFFAIRE", row.getForeignID("ID_AFFAIRE"));
                    }
                    SQLRowValues rowValsCmdElt = inj.createRowValuesFrom(row);
                    rowValsCmdElt.put("ID_STYLE", idNormal);
                    rowValsCmdElt.put("ID_MODE_VENTE_ARTICLE", 5);
                    rowValsCmdElt.put("ID_TAXE", TaxeCache.getCache().getFirstTaxeAchat().getID());
                    rowValsCmdElt.put("ID_COMMANDE", (Object)rowVals);
                    rowValsCmdElt.put("ID_DEMANDE_ACHAT_ELEMENT", row.getID());
                    if (row.getObject("ID_ARTICLE") != null && !row.isForeignEmpty("ID_ARTICLE")) {
                        BigDecimal ha = row.getForeign("ID_ARTICLE").getBigDecimal("PA_HT");
                        rowValsCmdElt.put("PA_HT", ha);
                        rowValsCmdElt.put("PRIX_METRIQUE_HA_1", ha);
                        rowValsCmdElt.put("PA_DEVISE", ha);
                        continue;
                    }
                    rowValsCmdElt.put("PA_HT", BigDecimal.ZERO);
                    rowValsCmdElt.put("PRIX_METRIQUE_HA_1", BigDecimal.ZERO);
                    rowValsCmdElt.put("PA_DEVISE", BigDecimal.ZERO);
                }
                EditFrame frame = new EditFrame(DemandeAchatItemSQLElement.this.getDirectory().getElement("COMMANDE"));
                frame.getSQLComponent().select(rowVals);
                FrameUtil.showPacked(frame);
            }
        }, true){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection != null && selection.size() > 0) {
                    int idAff = -1;
                    for (SQLRowValues sqlRowValues : selection) {
                        if (!DemandeAchatItemSQLElement.this.getTable().contains("ID_AFFAIRE") || sqlRowValues.getObject("ID_AFFAIRE") == null || sqlRowValues.isForeignEmpty("ID_AFFAIRE")) continue;
                        if (idAff == -1) {
                            idAff = sqlRowValues.getForeignID("ID_AFFAIRE");
                        }
                        if (idAff == sqlRowValues.getForeignID("ID_AFFAIRE")) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.getRowActions().add(actionP);
    }

    public void updateStatus(final SQLTable table, final SQLTable tableElt, final int id) {
        SQLRowValues rowVals = new SQLRowValues(tableElt);
        rowVals.put("ID_DEMANDE_ACHAT_ELEMENT", null);
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)tableElt.getField("ID_" + table.getName()), "=", id);
                w = w.and(new Where((FieldRef)tableElt.getField("ID_DEMANDE_ACHAT_ELEMENT"), "!=", (Object)null));
                w = w.and(new Where((FieldRef)tableElt.getField("ID_DEMANDE_ACHAT_ELEMENT"), ">", 1));
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> result = fetcher.fetch();
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (SQLRowValues sqlRowValues : result) {
            ids.add(sqlRowValues.getForeignID("ID_DEMANDE_ACHAT_ELEMENT"));
        }
        this.updateAllStatus(ids);
    }

    private void updateAllStatus(final List<Integer> ids) {
        SQLRowValues rowVals = new SQLRowValues(this.getTable());
        rowVals.put("QTE", null);
        rowVals.put("QTE_UNITAIRE", null);
        rowVals.put("ID_ETAT_DEMANDE_ACHAT_ELEMENT", null);
        List<String> refTable = Arrays.asList("COMMANDE_ELEMENT", "DEMANDE_PRIX_ELEMENT", "BON_RECEPTION_ELEMENT");
        for (String tableName : refTable) {
            SQLRowValues rowValsRef = new SQLRowValues(this.getTable().getTable(tableName));
            rowValsRef.put("QTE", null);
            rowValsRef.put("PA_HT", null);
            rowValsRef.put("ID_DEMANDE_ACHAT_ELEMENT", (Object)rowVals);
            rowValsRef.put("QTE_UNITAIRE", null);
            rowValsRef.put("ID_" + tableName.replaceAll("_ELEMENT", ""), null);
        }
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                input.setWhere(new Where(input.getTable("DEMANDE_ACHAT_ELEMENT").getKey(), ids));
                return input;
            }
        });
        List<SQLRowValues> result = fetcher.fetch();
        for (SQLRowValues sqlRowValues : result) {
            this.updateStatus(sqlRowValues);
        }
    }

    private void updateStatus(SQLRowValues rowValsDmd) {
        Collection<SQLRowValues> rowValsBR = rowValsDmd.getReferentRows(this.getTable().getTable("BON_RECEPTION_ELEMENT"));
        int newStatus = 2;
        SQLRowValues createEmptyUpdateRow = rowValsDmd.createEmptyUpdateRow();
        if (!rowValsBR.isEmpty()) {
            int qte = 0;
            int idBR = 1;
            BigDecimal prix = BigDecimal.ZERO;
            for (SQLRowValues sqlRowValues : rowValsBR) {
                qte += sqlRowValues.getInt("QTE");
                idBR = sqlRowValues.getForeignID("ID_BON_RECEPTION");
                prix = sqlRowValues.getBigDecimal("PA_HT");
            }
            if (qte > 0) {
                createEmptyUpdateRow.put("ID_BON_RECEPTION", idBR);
                createEmptyUpdateRow.put("QTE_RECUE", qte);
                createEmptyUpdateRow.put("P_HT", prix);
                createEmptyUpdateRow.put("T_HT", prix.multiply(rowValsDmd.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(rowValsDmd.getInt("QTE")))));
                newStatus = qte >= rowValsDmd.getInt("QTE") ? 5 : 6;
            }
        } else {
            Collection<SQLRowValues> rowValsCmd = rowValsDmd.getReferentRows(this.getTable().getTable("COMMANDE_ELEMENT"));
            if (!rowValsCmd.isEmpty()) {
                SQLRowValues next = rowValsCmd.iterator().next();
                createEmptyUpdateRow.put("ID_COMMANDE", next.getForeignID("ID_COMMANDE"));
                createEmptyUpdateRow.put("P_HT", next.getBigDecimal("PA_HT"));
                createEmptyUpdateRow.put("T_HT", next.getBigDecimal("PA_HT").multiply(rowValsDmd.getBigDecimal("QTE_UNITAIRE").multiply(new BigDecimal(rowValsDmd.getInt("QTE")))));
                newStatus = 4;
            } else {
                Collection<SQLRowValues> rowValsDmdElt = rowValsDmd.getReferentRows(this.getTable().getTable("DEMANDE_PRIX_ELEMENT"));
                if (!rowValsDmdElt.isEmpty()) {
                    newStatus = 3;
                }
            }
        }
        try {
            createEmptyUpdateRow.put("ID_ETAT_DEMANDE_ACHAT_ELEMENT", newStatus).commit();
        }
        catch (SQLException e) {
            ExceptionHandler.handle("Erreur lors la mise \u00e0 jour de l'\u00e9tat de la demande d'achat [" + rowValsDmd.getID() + "]", e);
        }
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("DATE");
        l.add("REVISION");
        l.add("CODE");
        l.add("NOM");
        l.add("IMPORT");
        l.add("REPRISE");
        l.add("QTE_UNITAIRE");
        l.add("ID_UNITE_VENTE");
        l.add("P_HT");
        l.add("QTE");
        l.add("T_HT");
        l.add("ID_FABRICANT");
        l.add("ID_FOURNISSEUR");
        l.add("CODE_SOURCE");
        l.add("NOM_SOURCE");
        l.add("ID_COMMANDE");
        l.add("ID_BON_RECEPTION");
        l.add("QTE_RECUE");
        l.add("ID_ETAT_DEMANDE_ACHAT_ELEMENT");
        return l;
    }

    @Override
    protected void _initTableSource(SQLTableModelSource res) {
        SQLTable foreignTable = this.getTable().getForeignTable("ID_ETAT_DEMANDE_ACHAT_ELEMENT");
        res.init();
        res.getColumn(foreignTable.getField("NOM")).setRenderer(new EtatDemandeAchatRenderer(foreignTable));
        res.getColumn(this.getTable().getField("P_HT")).setRenderer(new DeviseTableCellRenderer());
        res.getColumn(this.getTable().getField("T_HT")).setRenderer(new DeviseTableCellRenderer());
        res.getColumn(this.getTable().getField("QTE_UNITAIRE")).setRenderer(new DeviseTableCellRenderer());
        super._initTableSource(res);
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.getTable().contains("ID_AFFAIRE")) {
            l.add("ID_AFFAIRE");
        }
        l.add("DATE");
        l.add("REVISION");
        l.add("CODE");
        l.add("NOM");
        return l;
    }

    @Override
    public ListMap<String, String> getShowAs() {
        return ListMap.singleton(null, new String[]{"CODE", "NOM"});
    }

    @Override
    public SQLComponent createComponent() {
        return new DemandeAchatItemSQLComponent(this);
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".demande.achat";
    }
}

