/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.Component;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.erp.core.sales.product.component.ReferenceArticleSQLComponent;
import org.openconcerto.erp.core.sales.product.ui.CurrencyWithSymbolRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTablePanel;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.utils.GestionDevise;

public class ProductQtyPriceListTable
extends RowValuesTablePanel {
    private SQLTableElement tarif;
    private SQLTable article = Configuration.getInstance().getBase().getTable("ARTICLE");
    private SQLRowValues rowValuesArticleCompile = new SQLRowValues(this.article);
    SQLTableElement tableElementVenteHT;
    ReferenceArticleSQLComponent comp;

    public ProductQtyPriceListTable(ReferenceArticleSQLComponent comp) {
        this.init();
        this.uiInit();
        this.comp = comp;
    }

    @Override
    protected void init() {
        SQLElement e = this.getSQLElement();
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTableElement eQuantity = new SQLTableElement(e.getTable().getField("QUANTITE")){

            @Override
            protected Object getDefaultNullValue() {
                return BigDecimal.ONE;
            }
        };
        list.add(eQuantity);
        SQLTableElement eltPourcent = new SQLTableElement(e.getTable().getField("POURCENT_REMISE"));
        list.add(eltPourcent);
        SQLField field = e.getTable().getField("PRIX_METRIQUE_VT_1");
        this.tableElementVenteHT = new SQLTableElement(field, BigDecimal.class);
        list.add(this.tableElementVenteHT);
        this.model = new RowValuesTableModel(e, list, e.getTable().getField("QUANTITE"), false, this.defaultRowVals);
        this.table = new RowValuesTable(this.model, null);
        eltPourcent.addModificationListener(this.tableElementVenteHT);
        this.tableElementVenteHT.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.getObject("POURCENT_REMISE") != null) {
                    return null;
                }
                return row.getObject("PRIX_METRIQUE_VT_1");
            }
        });
        this.tableElementVenteHT.setRenderer(new CurrencyWithSymbolRenderer());
        this.tableElementVenteHT.addModificationListener(eltPourcent);
        eltPourcent.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                if (row.getObject("PRIX_METRIQUE_VT_1") != null) {
                    return null;
                }
                return row.getObject("POURCENT_REMISE");
            }
        });
        DefaultTableCellRenderer eltPourcentTableCellRender = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                System.err.println("ProductPriceListTable. prcTableCellRender .getTableCellRendererComponent():" + value);
                JLabel c = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                c.setHorizontalAlignment(4);
                JTextField fieldMetriqueVT1 = (JTextField)ProductQtyPriceListTable.this.comp.getView("PV_HT").getComp();
                if (value != null && fieldMetriqueVT1.getText().length() > 0) {
                    BigDecimal ht = new BigDecimal(fieldMetriqueVT1.getText());
                    ht = ht.multiply(BigDecimal.ONE.subtract(((BigDecimal)value).movePointLeft(2)));
                    c.setText(value + "% (" + GestionDevise.currencyToString(ht) + ")");
                } else if (value != null) {
                    c.setText(value + "%");
                } else {
                    c.setText("");
                }
                return c;
            }
        };
        eltPourcent.setRenderer(eltPourcentTableCellRender);
    }

    @Override
    public SQLElement getSQLElement() {
        return Configuration.getInstance().getDirectory().getElement("TARIF_QUANTITE");
    }
}

