/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openconcerto.erp.core.common.ui.DeviseCellEditor;
import org.openconcerto.erp.core.common.ui.RowValuesMultiLineEditTable;
import org.openconcerto.erp.core.finance.accounting.ui.DeviseKmRowValuesRenderer;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.UndefinedRowValuesCache;
import org.openconcerto.sql.view.list.CellDynamicModifier;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableControlPanel;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.sql.view.list.RowValuesTableRenderer;
import org.openconcerto.sql.view.list.SQLTableElement;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.table.PercentTableCellRenderer;
import org.openconcerto.utils.DecimalUtils;

public class AnalytiqueItemTable
extends JPanel {
    private final RowValuesTable table;
    private final DeviseKmRowValuesRenderer deviseRenderer = new DeviseKmRowValuesRenderer();
    private final DeviseCellEditor deviseCellEditor = new DeviseCellEditor();
    private SQLRowAccessor rowEcr;
    private static final SQLElement elt = Configuration.getInstance().getDirectory().getElement("ASSOCIATION_ANALYTIQUE");
    private final SQLRowValues rowVals = new SQLRowValues(UndefinedRowValuesCache.getInstance().getDefaultRowValues(elt.getTable()));
    private long totalArepartir;

    public SQLRowValues getDefaultRowValues() {
        return this.rowVals;
    }

    public AnalytiqueItemTable(boolean multilineEditor) {
        this(multilineEditor, null);
    }

    public AnalytiqueItemTable(boolean multilineEditor, final AbstractAction actionOnValidate) {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        Vector<SQLTableElement> list = new Vector<SQLTableElement>();
        SQLTable tableElement = elt.getTable();
        SQLTableElement tableElementNomCompte = new SQLTableElement(tableElement.getField("ID_POSTE_ANALYTIQUE"));
        list.add(tableElementNomCompte);
        final SQLTableElement tableElementPourcent = new SQLTableElement(tableElement.getField("POURCENT"));
        tableElementPourcent.setRenderer(new PercentTableCellRenderer());
        list.add(tableElementPourcent);
        SQLTableElement tableElementMontant = new SQLTableElement(tableElement.getField("MONTANT"), Long.class, this.deviseCellEditor){

            @Override
            protected Object getDefaultNullValue() {
                return 0L;
            }
        };
        list.add(tableElementMontant);
        this.rowVals.put("POURCENT", BigDecimal.ONE.movePointRight(2));
        final RowValuesTableModel model = new RowValuesTableModel(elt, list, tableElement.getField("ID_POSTE_ANALYTIQUE"), false, this.rowVals);
        if (multilineEditor) {
            this.table = new RowValuesMultiLineEditTable(model, null, "ANALYTIQUE"){

                @Override
                public String getStringValue(SQLRowValues rowVals) {
                    return AnalytiqueItemTable.getStringAssocs(rowVals);
                }

                @Override
                public void insertFrom(SQLRowAccessor row) {
                    AnalytiqueItemTable.this.rowEcr = row;
                    AnalytiqueItemTable.this.getDefaultRowValues().put("POURCENT", BigDecimal.TEN.movePointRight(1));
                    AnalytiqueItemTable.this.getDefaultRowValues().put("MONTANT", AnalytiqueItemTable.this.rowEcr.getLong("DEBIT") - AnalytiqueItemTable.this.rowEcr.getLong("CREDIT"));
                    AnalytiqueItemTable.this.totalArepartir = AnalytiqueItemTable.this.rowEcr.getLong("DEBIT") - AnalytiqueItemTable.this.rowEcr.getLong("CREDIT");
                    super.insertFrom(row);
                }
            };
            ToolTipManager.sharedInstance().unregisterComponent(this.table);
            ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
            RowValuesTableControlPanel panelControl = new RowValuesTableControlPanel(this.table);
            panelControl.setVisibleButtonHaut(false);
            panelControl.setVisibleButtonBas(false);
            panelControl.setVisibleButtonClone(false);
            panelControl.setVisibleButtonInserer(false);
            this.add((Component)panelControl, c);
            ++c.gridy;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.add((Component)new JScrollPane(this.table), c);
            this.table.setDefaultRenderer(Long.class, new RowValuesTableRenderer());
            final JButton buttonValider = new JButton("Valider les modifications");
            JButton buttonFermer = new JButton("Fermer");
            c.gridx = 0;
            ++c.gridy;
            c.anchor = 13;
            c.weightx = 1.0;
            c.weighty = 0.0;
            c.fill = 0;
            c.gridwidth = 0;
            JPanel panelButton = new JPanel();
            buttonValider.setEnabled(false);
            panelButton.add(buttonValider);
            panelButton.add(buttonFermer);
            this.add((Component)panelButton, c);
            model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    long totalReparti = 0L;
                    if (AnalytiqueItemTable.this.totalArepartir != 0L) {
                        int i = 0;
                        while (i < model.getRowCount()) {
                            totalReparti += model.getRowValuesAt(i).getLong("MONTANT");
                            ++i;
                        }
                        AnalytiqueItemTable.this.getDefaultRowValues().put("POURCENT", new BigDecimal(totalReparti).divide(new BigDecimal(AnalytiqueItemTable.this.totalArepartir), DecimalUtils.HIGH_PRECISION).setScale(6, RoundingMode.HALF_UP));
                        AnalytiqueItemTable.this.getDefaultRowValues().put("MONTANT", AnalytiqueItemTable.this.totalArepartir - totalReparti);
                        buttonValider.setEnabled(totalReparti == AnalytiqueItemTable.this.totalArepartir);
                    } else {
                        buttonValider.setEnabled(true);
                    }
                }
            });
            final RowValuesMultiLineEditTable multiTable = (RowValuesMultiLineEditTable)this.table;
            buttonValider.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    multiTable.updateField(multiTable.getForeignField(), multiTable.getRowValuesRoot());
                    multiTable.closeTable();
                    if (actionOnValidate != null) {
                        actionOnValidate.actionPerformed(null);
                    }
                }
            });
            buttonFermer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    multiTable.closeTable();
                }
            });
            this.setMinimumSize(new Dimension(this.getMinimumSize().width, 200));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 200));
        } else {
            this.table = new RowValuesTable(model, null);
            ToolTipManager.sharedInstance().unregisterComponent(this.table);
            ToolTipManager.sharedInstance().unregisterComponent(this.table.getTableHeader());
            this.add((Component)new RowValuesTableControlPanel(this.table), c);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            ++c.gridy;
            this.add((Component)new JScrollPane(this.table), c);
        }
        tableElementMontant.addModificationListener(tableElementPourcent);
        tableElementPourcent.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                long montant = row.getObject("MONTANT") == null ? 0L : row.getLong("MONTANT");
                SQLRowAccessor foreignEcr = row.getForeign("ID_ECRITURE");
                if (AnalytiqueItemTable.this.rowEcr != null) {
                    foreignEcr = AnalytiqueItemTable.this.rowEcr;
                }
                long total = foreignEcr.getLong("DEBIT") - foreignEcr.getLong("CREDIT");
                BigDecimal pourcent = BigDecimal.ZERO;
                if (total != 0L) {
                    pourcent = new BigDecimal(montant).divide(new BigDecimal(total), DecimalUtils.HIGH_PRECISION).abs().movePointRight(2).setScale(tableElementPourcent.getDecimalDigits(), RoundingMode.HALF_UP);
                }
                return pourcent;
            }
        });
        tableElementPourcent.addModificationListener(tableElementMontant);
        tableElementMontant.setModifier(new CellDynamicModifier(){

            @Override
            public Object computeValueFrom(SQLRowValues row, SQLTableElement source) {
                BigDecimal percent = row.getObject("POURCENT") == null ? BigDecimal.ZERO : row.getBigDecimal("POURCENT");
                SQLRowAccessor foreignEcr = row.getForeign("ID_ECRITURE");
                if (AnalytiqueItemTable.this.rowEcr != null) {
                    foreignEcr = AnalytiqueItemTable.this.rowEcr;
                }
                long total = foreignEcr.getLong("DEBIT") - foreignEcr.getLong("CREDIT");
                BigDecimal montant = percent.movePointLeft(2).multiply(new BigDecimal(total)).setScale(0, RoundingMode.HALF_UP);
                return montant.longValue();
            }
        });
        ++c.gridy;
        tableElementMontant.setRenderer(this.deviseRenderer);
    }

    public RowValuesTable getTable() {
        return this.table;
    }

    public void updateField(String field, int id) {
        this.table.updateField(field, id);
    }

    public void insertFrom(SQLRowAccessor row) {
        this.rowEcr = row;
        this.getDefaultRowValues().putEmptyLink("ID_SAISIE_KM_ELEMENT");
        if (this.rowEcr != null && !this.rowEcr.isForeignEmpty("ID_MOUVEMENT")) {
            Collection<? extends SQLRowAccessor> rElt;
            SQLRowAccessor r = this.rowEcr.getForeign("ID_MOUVEMENT");
            if (r.getString("SOURCE").equalsIgnoreCase("SAISIE_KM") && (rElt = this.rowEcr.getReferentRows(this.rowEcr.getTable().getTable("SAISIE_KM_ELEMENT"))).size() > 0) {
                this.getDefaultRowValues().put("ID_SAISIE_KM_ELEMENT", rElt.iterator().next().getID());
            }
            this.getDefaultRowValues().put("POURCENT", BigDecimal.TEN.movePointRight(1));
            this.getDefaultRowValues().put("MONTANT", this.rowEcr.getLong("DEBIT") - this.rowEcr.getLong("CREDIT"));
            this.totalArepartir = this.rowEcr.getLong("DEBIT") - this.rowEcr.getLong("CREDIT");
        }
        this.table.insertFrom(row);
    }

    public RowValuesTableModel getModel() {
        return this.table.getRowValuesTableModel();
    }

    public static String getStringAssocs(SQLRowValues rowVals) {
        StringBuffer buf = new StringBuffer();
        SQLTable tableElement = elt.getTable();
        if (rowVals.getID() > 1) {
            SQLRow row = rowVals.getTable().getRow(rowVals.getID());
            Collection rowSet = row.getReferentRows(tableElement);
            for (SQLRow row2 : rowSet) {
                buf.append(String.valueOf(AnalytiqueItemTable.getStringAssoc(row2)) + ", ");
            }
        } else {
            Collection<SQLRowValues> colRows = rowVals.getReferentRows();
            for (SQLRowValues rowValues : colRows) {
                if (!rowValues.getTable().getName().equalsIgnoreCase(tableElement.getName())) continue;
                buf.append(String.valueOf(AnalytiqueItemTable.getStringAssoc(rowValues)) + ", ");
            }
        }
        String string = buf.toString();
        if (string.length() > 2) {
            string = string.substring(0, string.length() - 2);
        }
        return string.trim();
    }

    private static String getStringAssoc(SQLRowAccessor row) {
        StringBuffer buf = new StringBuffer();
        SQLRowAccessor rowVerif = row.getForeign("ID_POSTE_ANALYTIQUE");
        if (rowVerif != null) {
            buf.append(rowVerif.getString("NOM"));
        }
        return buf.toString();
    }
}

