/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.element;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.dbutils.ResultSetHandler;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLInsert;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLUpdate;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;

public class RapprochementBancaireSQLElement
extends ComptaSQLConfElement {
    public static final String TABLE_NAME = "RAPPROCHEMENT_BANCAIRE";

    public RapprochementBancaireSQLElement() {
        super(TABLE_NAME);
    }

    @Override
    protected List<String> getListFields() {
        return Arrays.asList("DATE", "ID_RELEVE_BANCAIRE_ELEMENT", "ID_ECRITURE");
    }

    @Override
    protected SQLComponent createComponent() {
        return null;
    }

    public void add(final Set<Integer> releveElementIds, final Set<Integer> ecritureIds, final String codePointage) throws SQLException {
        SQLUtils.executeAtomic(this.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, SQLException>(){

            @Override
            public Object handle(SQLDataSource ds) throws SQLException {
                SQLTable tRapprochement = RapprochementBancaireSQLElement.this.getTable();
                SQLTable tReleveBancaireElement = RapprochementBancaireSQLElement.this.getTable().getTable("RELEVE_BANCAIRE_ELEMENT");
                SQLTable tEcriture = RapprochementBancaireSQLElement.this.getTable().getTable("ECRITURE");
                DBSystemRoot systemRoot = tRapprochement.getDBSystemRoot();
                ArrayList<String> requests = new ArrayList<String>(2);
                SQLSelect s1 = new SQLSelect();
                s1.addSelect(tReleveBancaireElement.getKey());
                s1.setWhere(new Where(tReleveBancaireElement.getKey(), releveElementIds).and(new Where((FieldRef)tReleveBancaireElement.getField("POINTE"), "=", (Object)false)));
                requests.add(s1.asString());
                SQLSelect s2 = new SQLSelect();
                s2.addSelect(tEcriture.getKey());
                s2.setWhere(new Where(tEcriture.getKey(), ecritureIds).and(new Where((FieldRef)tEcriture.getField("POINTEE"), "=", (Object)"")));
                requests.add(s2.asString());
                System.out.println("RapprochementBancaireSQLElement.add(...) " + requests);
                ResultSetHandler h = new ResultSetHandler(){

                    @Override
                    public Object handle(ResultSet rs) throws SQLException {
                        int i = 0;
                        while (rs.next()) {
                            ++i;
                        }
                        return i;
                    }
                };
                List<?> list = SQLUtils.executeMultiple(systemRoot, requests, Arrays.asList(h, h));
                if (((Integer)list.get(0)).intValue() != releveElementIds.size()) {
                    throw new IllegalStateException("ligne de relev\u00e9 d\u00e9j\u00e0 point\u00e9e");
                }
                if (((Integer)list.get(1)).intValue() != ecritureIds.size()) {
                    throw new IllegalStateException("\u00e9criture d\u00e9j\u00e0 point\u00e9e");
                }
                System.out.println("RapprochementBancaireSQLElement.add(...) " + list);
                Date d = new Date();
                ArrayList<SQLInsert> inserts = new ArrayList<SQLInsert>();
                for (Integer releveElementId : releveElementIds) {
                    for (Integer ecritureId : ecritureIds) {
                        SQLInsert insert = new SQLInsert();
                        insert.add(tRapprochement.getField("DATE"), d);
                        insert.add(tRapprochement.getField("ID_RELEVE_BANCAIRE_ELEMENT"), releveElementId);
                        insert.add(tRapprochement.getField("ID_ECRITURE"), ecritureId);
                        inserts.add(insert);
                    }
                }
                SQLInsert.executeSimilarInserts(systemRoot, inserts, false);
                ArrayList<SQLUpdate> updates = new ArrayList<SQLUpdate>(2);
                SQLUpdate update1 = new SQLUpdate(new Where(tReleveBancaireElement.getKey(), releveElementIds));
                update1.add(tReleveBancaireElement.getField("POINTE"), true);
                updates.add(update1);
                SQLUpdate update2 = new SQLUpdate(new Where(tEcriture.getKey(), ecritureIds));
                update2.add(tEcriture.getField("POINTEE"), codePointage);
                update2.add(tEcriture.getField("DATE_POINTEE"), new Date());
                updates.add(update2);
                SQLUpdate.executeMultipleWithBatch(systemRoot, updates);
                for (Integer id : ecritureIds) {
                    tEcriture.fireTableModified(id);
                }
                return null;
            }
        });
    }
}

