/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.alg.AbstractPathElement;
import org.jgrapht.alg.AbstractPathElementList;
import org.jgrapht.alg.RankingPathElement;

final class RankingPathElementList<V, E>
extends AbstractPathElementList<V, E, RankingPathElement<V, E>> {
    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElement<V, E> pathElement) {
        super(graph, maxSize, pathElement);
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElementList<V, E> elementList, E edge) {
        super(graph, maxSize, elementList, edge);
        int i = 0;
        while (i < elementList.size()) {
            RankingPathElement prevPathElement = (RankingPathElement)elementList.get(i);
            if (this.pathElements.size() <= this.maxSize - 1) {
                double weight = this.calculatePathWeight(prevPathElement, edge);
                RankingPathElement newPathElement = new RankingPathElement(this.graph, prevPathElement, edge, weight);
                this.pathElements.add(newPathElement);
            }
            ++i;
        }
        assert (!this.pathElements.isEmpty());
    }

    protected RankingPathElementList(RankingPathElementList<V, E> original) {
        super(original);
    }

    public boolean addPathElements(RankingPathElementList<V, E> elementList, E edge) {
        assert (this.vertex.equals(Graphs.getOppositeVertex(this.graph, edge, elementList.getVertex())));
        boolean pathAdded = false;
        int vIndex = 0;
        int yIndex = 0;
        while (vIndex < elementList.size()) {
            RankingPathElement prevPathElement = (RankingPathElement)elementList.get(vIndex);
            if (!this.isAlreadyImprovedByThisEdge(edge, prevPathElement) && !this.containsTargetPreviously(prevPathElement)) {
                double weight = this.calculatePathWeight(prevPathElement, edge);
                while (yIndex < this.size()) {
                    RankingPathElement yPathElement = (RankingPathElement)this.get(yIndex);
                    RankingPathElement newPathElement = new RankingPathElement(this.graph, prevPathElement, edge, weight);
                    if (weight < yPathElement.getWeight()) {
                        this.pathElements.add(yIndex, newPathElement);
                        if (this.size() > this.maxSize) {
                            this.pathElements.remove(this.maxSize);
                        }
                        pathAdded = true;
                        break;
                    }
                    if (weight == yPathElement.getWeight()) {
                        if (this.isAlreadyAdded(newPathElement)) break;
                        if (this.size() <= this.maxSize - 1) {
                            this.pathElements.add(yIndex + 1, newPathElement);
                            if (this.size() > this.maxSize) {
                                this.pathElements.remove(this.maxSize);
                            }
                            pathAdded = true;
                            break;
                        }
                    }
                    if (weight > yPathElement.getWeight() && yIndex == this.size() - 1 && this.size() <= this.maxSize - 1) {
                        this.pathElements.add(newPathElement);
                        pathAdded = true;
                        break;
                    }
                    ++yIndex;
                }
            }
            ++vIndex;
        }
        return pathAdded;
    }

    List<RankingPathElement<V, E>> getPathElements() {
        return this.pathElements;
    }

    private double calculatePathWeight(RankingPathElement<V, E> pathElement, E edge) {
        double pathWeight = this.graph.getEdgeWeight(edge);
        if (pathElement.getPrevEdge() != null) {
            pathWeight += pathElement.getWeight();
        }
        return pathWeight;
    }

    private boolean containsTargetPreviously(RankingPathElement<V, E> pathElement) {
        AbstractPathElement tempPathElement = pathElement;
        while (tempPathElement.getPrevEdge() != null) {
            if (tempPathElement.getVertex() == this.vertex) {
                return true;
            }
            tempPathElement = tempPathElement.getPrevPathElement();
        }
        return false;
    }

    private boolean isAlreadyAdded(RankingPathElement<V, E> pathElement) {
        int i = 0;
        while (i <= this.size() - 1) {
            RankingPathElement<V, E> pathElementToTest;
            RankingPathElement yPathElement = (RankingPathElement)this.get(i);
            if (!this.isDifferent(yPathElement, pathElementToTest = pathElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAlreadyImprovedByThisEdge(E edge, RankingPathElement<V, E> prevPathElement) {
        AbstractPathElement pathElementToTest = prevPathElement;
        while (pathElementToTest.getPrevEdge() != null) {
            if (pathElementToTest.getPrevEdge() == edge) {
                return true;
            }
            pathElementToTest = pathElementToTest.getPrevPathElement();
        }
        return false;
    }

    private boolean isDifferent(RankingPathElement<V, E> yPathElement, RankingPathElement<V, E> pathElementToTest) {
        while (yPathElement.getPrevEdge() != null || pathElementToTest.getPrevEdge() != null) {
            if (yPathElement.getPrevEdge() != pathElementToTest.getPrevEdge()) {
                return true;
            }
            yPathElement = yPathElement.getPrevPathElement();
            pathElementToTest = pathElementToTest.getPrevPathElement();
        }
        return false;
    }
}

